package slider;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.Vector;

import FSParser.*;

/***********************************
 * Provides an interface to the slider and all that goes with it
 */
public class ParseFrame extends JFrame {

  Parser parser;
  boolean returnCode;

  JPanel contentPane;
  JPanel parsePanel = new JPanel();
  JButton parseButton = new JButton();
  Component component1;
  Box box1;
  JTextArea jTextField1 = new JTextArea();
  JScrollPane mainScrollPane = new JScrollPane();
  Controller rs = new Controller("", 0.0f, 500.0f);
  BorderLayout borderLayout1 = new BorderLayout();
  JPanel bottomPanel = new JPanel();
  FlowLayout flowLayout1 = new FlowLayout();
  BorderLayout borderLayout2 = new BorderLayout();
  JPanel labelPanel = new JPanel();
  JLabel description = new JLabel();
  JPanel controlPanel = new JPanel();
  JButton cancelButton = new JButton();
  JButton OKButton = new JButton();


    //Construct the frame
    public ParseFrame() {
	enableEvents(AWTEvent.WINDOW_EVENT_MASK);
	try {
	    jbInit();
	}
	catch(Exception e) {
	    e.printStackTrace();
	}

	rs.setTextField(jTextField1);
	rs.setLabel(description);


    }

    //Component initialization
    private void jbInit() throws Exception  {
	contentPane = (JPanel) this.getContentPane();
    component1 = Box.createVerticalStrut(8);
    box1 = Box.createVerticalBox();
    contentPane.setLayout(borderLayout1);
	this.setSize(new Dimension(500, 170));
	this.setTitle("Parser");
    parseButton.setText("Parse");
    parseButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        parseButton_actionPerformed(e);
      }
    });
    jTextField1.setColumns(500);
    jTextField1.setRows(1);
    jTextField1.setFont(new java.awt.Font("Monospaced", 0, 12));
    mainScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
    mainScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
    mainScrollPane.setPreferredSize(new Dimension(400, 65));
    parsePanel.setLayout(flowLayout1);
    bottomPanel.setLayout(borderLayout2);
    cancelButton.setText("Cancel");
    cancelButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        cancelButton_actionPerformed(e);
      }
    });
    OKButton.setText("OK");
    OKButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        OKButton_actionPerformed(e);
      }
    });
    contentPane.add(parsePanel, BorderLayout.CENTER);
    parsePanel.add(mainScrollPane, null);
    mainScrollPane.getViewport().add(box1, null);
    box1.add(jTextField1, null);
    box1.add(component1, null);
    box1.add(rs, null);
    parsePanel.add(parseButton, null);
    contentPane.add(bottomPanel, BorderLayout.SOUTH);
    bottomPanel.add(labelPanel, BorderLayout.NORTH);
    labelPanel.add(description, null);
    bottomPanel.add(controlPanel, BorderLayout.CENTER);
    controlPanel.add(OKButton, null);
    controlPanel.add(cancelButton, null);

    }


    //Overridden so we can exit when window is closed
    protected void processWindowEvent(WindowEvent e) {
	super.processWindowEvent(e);
	if (e.getID() == WindowEvent.WINDOW_CLOSING) {
	    System.exit(0);
	}
    }

    public void run(Parser inParser)
    {
	parser = inParser;
        rs.setParser(parser);
        resetView();

	// allow the user to mess with the interface
	setVisible(true);
    }

  void OKButton_actionPerformed(ActionEvent e) {
    // Create the DM entities
    parser.createDM();
    setVisible(false);
  }

  void cancelButton_actionPerformed(ActionEvent e) {
    setVisible(false);
  }

  void parseButton_actionPerformed(ActionEvent e) {
    returnCode = parser.parse(rs.getTextField().getText());
    if (returnCode == false)
      description.setText("Parsing Error");

    resetView();
  }

  // makes sure the view matches the model
  private void resetView() {
    // set the CNL string
	rs.getTextField().setText(parser.cnlString());
	rs.updateTicks();

	// set the head markers
	int heads[] = new int[14];
	for (int i = 0; i < parser.constituents().size(); i++) {
	    heads[i*2] = ((Constituent)(parser.constituents().elementAt(i))).headPosition();
	    heads[(i*2)+1] = ((Constituent)(parser.constituents().elementAt(i))).headPosition() +
		((Constituent)(parser.constituents().elementAt(i))).headLength();
	}
	rs.setHeads(heads);

	// set the constituent markers/sliders
	float markers[] = new float[6];

	for (int i = 0; i < parser.constituents().size() - 1; i++) {
	    markers[i] = ((Constituent)(parser.constituents().elementAt(i))).endPosition();
	    if (markers[i] == -1)
		markers[i] = parser.cnlString().length();
	}

        if (((Constituent)(parser.constituents().elementAt(0))).endPosition() == -1)
	    markers[0] = 0;

	rs.setValues(markers[0]-1, markers[1]-1, markers[2]-1, markers[3]-1, markers[4]-1, markers[5]-1);
        rs.setDescriptions();
  }
}
