
/**
 * Title:        slider<p>
 * Description:  <p>
 * Copyright:    Copyright (c) <p>
 * Company:      <p>
 * @author
 * @version 1.0
 */
package slider;

import javax.swing.*;
import java.awt.event.*;
import java.util.*;
import java.lang.Integer;
import java.awt.*;
import javax.swing.text.BadLocationException;
import FSParser.*;

/********************************************
 * An extended range slider with extra functionality for the parser
 */
public class Controller extends RangeSlider implements Scrollable {

  Parser parser;
  private JTextArea textfield;
  private JLabel part;
  float[] values;
  int[] tickmarks;
  String[] names = {"agent", "process", "patient", "phrase 1", "phrase 2", "phrase3"};
  JPopupMenu headPopup = new JPopupMenu();
  JMenuItem setHeadMItem = new JMenuItem();

  // constructor
  public Controller(String n, float min, float max) {
    super(n,min,max);
    this.setAutoscrolls(true);
    setHeadMItem.setText("Set Head");
    setHeadMItem.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        setHeadMItem_actionPerformed(e);
      }
    });
    headPopup.add(setHeadMItem);
  }

  public void setValues(float sv, float vdo, float ppone, float pptwo, float ppthree, float ppfour) {
    super.setValues(sv, vdo, ppone, pptwo, ppthree, ppfour);
    values = new float[6];
    values[0] = sv;
    values[1] = vdo;
    values[2] = ppone;
    values[3] = pptwo;
    values[4] = ppthree;
    values[5] = ppfour;
  }

  public void setParser(Parser inParser) {
    parser = inParser;
  }

  // sets the associated text field
  public void setTextField(JTextArea field) {
    this.textfield = field;
    textfield.addKeyListener(new KeyAdapter() {

      public void keyPressed(KeyEvent ke) {

        //calls the popup menu
        if (ke.getModifiers() == ke.CTRL_MASK && ke.getKeyCode() == ke.VK_P) {
         try {
            parser.parse(textfield.getText(0, textfield.getCaretPosition()));
            Vector v = parser.possibleTransitions();
            Vector nouns = new Vector();
            Vector verbs = new Vector();
            Vector trans = new Vector();
            for (int i = 0; i < v.size(); i++) {
              if (v.elementAt(i).equals("noun")) {
                nouns.add("nouns");
                nouns.add("button");
                nouns.add("model");
                nouns.add("mouse");
                nouns.add("user");
                v.set(i, nouns);
              }
              else if (v.elementAt(i).equals("verb")) {
                verbs.add("verbs");
                verbs.add("click");
                verbs.add("save");
                v.set(i, verbs);
              }
              else if (v.elementAt(i).equals("\"at\"")) {
                trans.add("transitions");
                trans.add("at");
                trans.add("from");
                trans.add("to");
                trans.add("using");
                v.set(i, trans);
              }
              else {
                //v.setElementAt(new Vector(), i);
              }
            }

            System.err.println(v);
            PopupWordlist pul = new PopupWordlist(textfield, v);
            Rectangle r = textfield.modelToView(textfield.getCaretPosition());
            Point p = textfield.getLocationOnScreen();
            pul.show(textfield, (int)p.getX()+(int)r.getX()+10, (int)p.getY()+(int)r.getY()+20);
          } catch (BadLocationException ble) {}
        }
        else if (ke.getKeyCode() == ke.VK_ENTER) {
          ke.consume();
        }
        //makes sure that everything scrolls properly
        else if (ke.getKeyCode() == ke.VK_DELETE || ke.getKeyCode() == ke.VK_BACK_SPACE) {
          try {
            Rectangle r = textfield.modelToView(textfield.getCaretPosition());
            r.setBounds((int)r.getX() - 10, 0, 0, 0);
            scrollRectToVisible(r);
          } catch (BadLocationException ble) {}
        }
        else
          try {
            Rectangle r = textfield.modelToView(textfield.getCaretPosition());
            r.setBounds((int)r.getX(), 0, 10, 0);
            scrollRectToVisible(r);
          } catch (BadLocationException ble) {}
      }

      public void keyReleased(KeyEvent ke) {
        updateTicks();
      }
    });

    textfield.addMouseListener(new PopupListener());
  }

  public void setLabel(JLabel name) {
    part = name;
  }


  public JTextArea getTextField() {
    return this.textfield;
  }

  // updates the ticks that the sliders snap to
  public void updateTicks() {
    String st = textfield.getText();
    Vector v = new Vector();
    int i = 0;
    int size = textfield.getColumns();//st.length() -1;

    while (i != -1) {
      v.add(new Float(i));
      i = st.indexOf(" ", i+1);
    }
    v.add(new Float(st.length()));

    tickmarks = new int[v.size()];
    for(int x = 0; x < tickmarks.length; x++) {
      tickmarks[x] = ((Number)v.elementAt(x)).intValue() - 1;
    }
  }

  //snaps knobs to tickmarks
    public void mouseReleased(MouseEvent e) {
	super.mouseReleased(e);
	float[] oldValues = values;
	values = super.getAllValues();
	for (int i = 0; i < values.length; i++)
	    System.err.println(values[i]);
	float svpos = values[0];
	float vdopos = values[1];
	float pponepos = values[2];
	float pptwopos = values[3];
	float ppthreepos = values[4];
	float ppfourpos = values[5];

	float dif = 100;
	float oldDif = dif;
	int index = 0;
	for (int i = 0; i < tickmarks.length; i++) {
	    dif = Math.abs(svpos - tickmarks[i]);
	    if (dif < oldDif) {
		index = i;
	    }
	    oldDif = dif;
	}

	svpos = (float)tickmarks[index];

	dif = 100;
	oldDif = dif;
	index = 0;
	for (int i = 0; i < tickmarks.length; i++) {
	    dif = Math.abs(vdopos - tickmarks[i]);
	    if (dif < oldDif) {
		index = i;
	    }
	    oldDif = dif;
	}

	vdopos = (float)tickmarks[index];
	int vdoindex = index;

	dif = 100;
	oldDif = dif;
	index = 0;
	for (int i = 0; i < tickmarks.length; i++) {
	    dif = Math.abs(pponepos - tickmarks[i]);
	    if (dif < oldDif) {
		index = i;
	    }
	    oldDif = dif;
	}

	pponepos = (float)tickmarks[index];

	dif = 100;
	oldDif = dif;
	index = 0;
	for (int i = 0; i < tickmarks.length; i++) {
	    dif = Math.abs(pptwopos - tickmarks[i]);
	    if (dif < oldDif) {
		index = i;
	    }
	    oldDif = dif;
	}

	pptwopos = (float)tickmarks[index];

	dif = 100;
	oldDif = dif;
	index = 0;
	for (int i = 0; i < tickmarks.length; i++) {
	    dif = Math.abs(ppthreepos - tickmarks[i]);
	    if (dif < oldDif) {
		index = i;
	    }
	    oldDif = dif;
	}

	ppthreepos = (float)tickmarks[index];

	dif = 100;
	oldDif = dif;
	index = 0;
	for (int i = 0; i < tickmarks.length; i++) {
	    dif = Math.abs(ppfourpos - tickmarks[i]);
	    if (dif < oldDif) {
		index = i;
	    }
	    oldDif = dif;
	}

	ppfourpos = (float)tickmarks[index];

	//if (svpos == vdopos)
	//  vdopos = (float)tickmarks[vdoindex + 1];

	//updates the constituent table in the parser, and also the interface
	values[0] = svpos;
	values[1] = vdopos;
	values[2] = pponepos;
	values[3] = pptwopos;
	values[4] = ppthreepos;
	values[5] = ppfourpos;

	for (int i = 0; i < 6; i++) {
	    if (oldValues[i] - values[i] != 0) {
		// Needed because the parser starts the adjunct constituents
		// after their preposition, not at the start of the preposition.
		int extra = 2;  
		int extra2 = 2;   // handles a special case, see below.
		if (i > 1 && values[i] < textfield.getText().length()-1) {
		    try {
			String str = textfield.getText((int)values[i] + 2, textfield.getText().indexOf(" ", (int)values[i]+2) - ((int)values[i] + 2));
			if (str.equals("using")) {
			    names[i+1] = "instrument";
			    extra += 6;
			}
			else if (str.equals("at")) {
			    names[i+1] = "location";
			    extra += 3;
			}
			else if (str.equals("from")) {
			    names[i+1] = "source";
			    extra += 5;
			}
			else {
			    values[i] = oldValues[i];
			}
		    } catch (BadLocationException ble) {}
		}

		if (values[0] == values[1]) {
		    values[0] = oldValues[0];
		    values[1] = oldValues[1];
		}

		System.out.println("moving " + names[i] + " using values[i]: " + values[i]);

		if ((i >= 1) && (values[i-1] == -1))
		    // When the previous constituent doesn't exist, we need to
		    // set the start of the current constituent at 0 rather than -1.
		    // Usually this is for the process.
		    // - kvlinden/mbrass48, 9aug2000
		    extra2 -= 1; 

		if (i != 0)
		    parser.moveConstituent(names[i], new Integer((int)values[i-1]+extra2), new Integer((int)values[i]+1));
		else {
		    // handles the agent constituent, a special case
		    if (values[i] == -1) {
			// Handles the null agent case 
			// Here the boundaries should be -1, -1, rather than 0, 0.
			// - kvlinden/mbrass48, 9aug2000
			parser.moveConstituent(names[i], new Integer(-1), new Integer(-1));
			extra -= 1;  // same as above, except this is for the agent
		    }
		    else
			parser.moveConstituent(names[i], new Integer(0), new Integer((int)values[i]+1));
		}

	
		parser.moveConstituent(names[i+1], new Integer((int)values[i]+extra), 
				       new Integer((int)values[i+1]+1));

		for (int j = 0; j < headArray.length-1; j+=2) {
		    if (headArray[j] < values[i] && headArray[j] > oldValues[i]) {
			parser.changeHead(names[i+1], new Integer(-1), new Integer(-1));
			headArray[j+1] = headArray[j] = -1;
		    }
		    else if (headArray[j] > values[i] && headArray[j] < oldValues[i]) {
			parser.changeHead(names[i], new Integer(-1), new Integer(-1));
			headArray[j+1] = headArray[j] = -1;
		    }
		}
	    }
	}

	System.err.println("");
	System.err.println("");
	parser.printConstituentTable();
	//super.setValues(svpos, vdopos, pponepos, pptwopos, ppthreepos, ppfourpos);
	super.setValues(values[0], values[1], values[2], values[3], values[4], values[5]);
    }

  //assures that dragging a slider off the screen scrolls the screen
  public void mouseDragged(MouseEvent e) {
    super.mouseDragged(e);
    int x = e.getPoint().x;
    if (x > -this.GRIP_WIDTH && x < 3500) {
    Rectangle r = new Rectangle(x, 0, 10, 0);
    scrollRectToVisible(r);
  }}


  //sets labels for the various parts (e.g. patient, process...)
  public void mouseMoved(MouseEvent e) {
    int x = textfield.viewToModel(new Point(e.getX(),5));
    if (values != null) {
      for (int i = 0; i < values.length-1; i++) {
        if (values[i] < x && x < values[i+1]) {
          setLabelText(names[i+1]);
        }
      }
      if (values[0] > x)
        setLabelText(names[0]);
    }
  }

  public void mouseExited(MouseEvent e) {
    part.setText("");
  }

  //sets the text of the label, if it has changed
  private void setLabelText(String text) {
    if (!part.getText().equals(text)) {
      part.setText(text);
    }
  }


  //*****************Scrollable Functions***************
  public Dimension getPreferredScrollableViewportSize() {
    return this.getPreferredScrollableViewportSize();
  }

  public int getScrollableUnitIncrement(Rectangle visibleRect,
                                      int orientation,
                                      int direction) {
    return direction;
  }

  public int getScrollableBlockIncrement(Rectangle visibleRect,
                                       int orientation,
                                       int direction) {
    return direction;
  }

  public boolean getScrollableTracksViewportWidth() {
    return false;
  }

  public boolean getScrollableTracksViewportHeight() {
    return true;
  }

  class PopupListener extends MouseAdapter {
    public void mousePressed(MouseEvent e) {
      maybeShowPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
      maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
      if (e.isPopupTrigger()) {
        headPopup.show(e.getComponent(),
        e.getX(), e.getY());
      }
    }
  }



  void setHeadMItem_actionPerformed(ActionEvent e) {
    int start = textfield.getSelectionStart();
    int end = textfield.getSelectionEnd();

    for (int i = 0; i < 5; i++) {
      if (start <= values[i+1] && start >= values[i]) {
        parser.changeHead(names[i+1], new Integer(start), new Integer(end));
        headArray[(i*2)+3] = end;
        headArray[i*2+2] = start;
      }
      else if (i == 0 && start <= values[i]) {
        parser.changeHead(names[0], new Integer(start), new Integer(end));
        headArray[1] = end;
        headArray[0] = start;
      }

    }

    parser.printConstituentTable();
    repaint();
  }

  //initializes the descriptions
  void setDescriptions() {
    for (int i = 2; i < 6; i++) {
      try {
        if (values[i] < textfield.getText().length()-1) {
          String str = textfield.getText((int)values[i] + 2, textfield.getText().indexOf(" ", (int)values[i]+2) - ((int)values[i] + 2));
          if (str.equals("using")) {
            names[i+1] = "instrument";
          }
          else if (str.equals("at")) {
            names[i+1] = "location";
          }
          else if (str.equals("from")) {
            names[i+1] = "source";
          }
        }
      } catch (BadLocationException ble) {}
    }
  }

}
