//Source file: D:/Projects/Isolde/parser/Constituent.java

package FSParser;

import java.lang.String;

public class Constituent 
{
    private String _name;           // name of the constituent (from the grammar)
    private int _startPosition;     // index of its start position in the input string
    private int _endPosition;       // index of its last position in the input string
    private int _headPosition;      // index of the beginning its head word/phrase
    private int _headLength;        // length of its head/phrase
    private String _domainObjectName;   // unique internal name of the head's DM entity
   
    public Constituent(String inName) 
    {
	_name = inName;
    }

    public void initialize()
    {
	_startPosition = -1;
	_endPosition = -1;
	_headPosition = -1;
	_headLength = 0;
	_domainObjectName = "";
    }

    public String name()
    {
	return _name;
    }

    public int startPosition()
    {
	return _startPosition;
    }

    public int endPosition()
    {
	return _endPosition;
    }

    public int headPosition()
    {
	return _headPosition;
    }

    public int headLength()
    {
	return _headLength;
    }

    public String domainObjectName()
    {
	return _domainObjectName;
    }

    public void setStartPosition(int value)
    {
	_startPosition = value;
	return;
    }

    public void setEndPosition(int value)
    {
	_endPosition = value;
	return;
    }

    public void setHeadPosition(int value)
    {
	_headPosition = value;
	return;
    }

    public void setHeadLength(int value)
    {
	_headLength = value;
	return;
    }

    public void setDomainObjectName(String value)
    {
	_domainObjectName = value;
	return;
    }

    public void print()
    {
	System.out.print(name() + " ");
	System.out.print(startPosition() + " ");
	System.out.print(endPosition() + " ");
	System.out.print(headPosition() + " ");
	System.out.print(headLength() + " ");
	System.out.println(domainObjectName() + " ");
	return;
    }
}
