/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package utility;

/* SortArrayList.java
* a generic sorting ArrayList
*/
import java.util.*;

public class SortArrayList extends ArrayList{
	private Compare compare;
	public SortArrayList (Compare com){
		compare = com;	
		
	}
	
	public void sort(){
		quickSort(0, size() - 1);	
	}
	
	private void quickSort(int left, int right){
		if (right> left) {
			Object o1 = get(right);
			int i = left -1;
			int j = right;
			while (true){
				while (compare.lessThan(
						get(++i), o1))
					;
				while (j>0)
					if (compare.lessThanOrEqual(
						get(--j), o1))
					break;	//out of while
					
				if (i>= j) break;
				swap( i, j);
				
			}
			swap(i, right);
			quickSort(left, i-1);
			quickSort(i+1, right);
			
		}		
	}//quickSort()
	
	private void swap(int loc1, int loc2){
		Object temp = get(loc1);
		set (loc1,get(loc2));
		set (loc2,temp);
	}
	
}//class SortVector