/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   Redistribution in source and binary forms, with or without modification, are not permitted.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.io.File;


public class XMLUtility {

    private static String ampersand = "&amp;";        // (&)
    private static String apostrophe = "&apos;";      // (')
    private static String quote = "&quot;";           // (")
    private static String lessThanSign = "&lt;";      // (<)
    private static String greaterThanSign = "&gt;";   // (>)

    protected static boolean checkXmlFileValidation(File f) {
        String fileName = f.getAbsolutePath();

        //TamotDOMParser parser = new TamotDOMParser();
        TamotXMLValidator parser = new TamotXMLValidator();

        return (parser.validateDocument(fileName));
    }
    
    public static String convertForEntities(String ss) {
        String result = ss;
        
        result = convertForEntity(result,"&",ampersand);
        result = convertForEntity(result,"'",apostrophe);
        result = convertForEntity(result,"\"",quote);
        result = convertForEntity(result,"<",lessThanSign);
        result = convertForEntity(result,">",greaterThanSign);
        
        return result;
    }
    
    public static String convertForEntity(String ss,String specialCharString,String substitute) {
        char specialChar = specialCharString.charAt(0);
        char tmpChar;
        StringBuffer sbuf = new StringBuffer();
        
        for (int i=0; i<ss.length(); i++) {
            tmpChar = ss.charAt(i);
            
            if (tmpChar == specialChar)
                sbuf.append(substitute);
            else
                sbuf.append(tmpChar);
        }
        
        String result = sbuf.toString();
        
        //System.out.println("convertForEntity : ("+specialChar+") -> "+result);
        
        return result;
        
        /*String result = ss;
        
        int i = ss.indexOf(specialCharString);
        if (i >= 0) {
            int length = specialCharString.length();
            int whole = ss.length();
            
            if (i == 0) {
                result = substitute + ss.substring(i+length,whole);
            }
            else {
                String ss1 = ss.substring(0,i);
                result = ss1 + substitute + ss.substring(i+length,whole);
            }
        }
        
        return result;*/
    }
    
    public static String checkAndConvertForEntities(String ss) {
        String result = ss;
        
        result = checkAndConvertForEntity(result,ampersand,"&");
        result = checkAndConvertForEntity(result,apostrophe,"'");
        result = checkAndConvertForEntity(result,quote,"\"");
        result = checkAndConvertForEntity(result,lessThanSign,"<");
        result = checkAndConvertForEntity(result,greaterThanSign,">");
        
        return result;
    }

    public static String checkAndConvertForEntity(String ss,String entityToBeChecked,String substitute) {
        char tmpChar;
        StringBuffer sbuf = new StringBuffer();
        int j;
        
        for (int i=0; i<ss.length(); i++) {
            j = ss.indexOf(entityToBeChecked,i);
            
            if (j == i) {
                sbuf.append(substitute);
                i += entityToBeChecked.length() - 1;
            }
            else {
                tmpChar = ss.charAt(i);
                sbuf.append(tmpChar);
            }
        }
        
        String result = sbuf.toString();
        
        //System.out.println("checkAndConvertForEntity : (ss = "+ss+") ("+substitute+") -> "+result);
        
        return result;

        /*String result = ss;
        
        int i = ss.indexOf(entityToBeChecked);
        if (i >= 0) {
            int length = entityToBeChecked.length();
            int whole = ss.length();
            
            if (i == 0) {
                result = substitute + ss.substring(i+length,whole);
            }
            else {
                String ss1 = ss.substring(0,i);
                result = ss1 + substitute + ss.substring(i+length,whole);
            }
        }
        
        return result;*/
    }
    
}