/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import javax.swing.text.*;
import javax.swing.text.rtf.*;
import javax.swing.event.*;
import javax.swing.undo.*;
import javax.swing.*;

import java.io.*;
import java.util.*;
import java.lang.reflect.*;
import java.awt.datatransfer.*;
import java.awt.dnd.*;


class TextPaneSource implements DragGestureListener, DragSourceListener{

    JTextPane textPane;
    DragSource dragSource;   

    public TextPaneSource(JTextPane pane) {
       textPane = pane;
       dragSource=DragSource.getDefaultDragSource();
       dragSource.createDefaultDragGestureRecognizer(textPane,DnDConstants.ACTION_COPY_OR_MOVE,this);
    }
    
    
    
    public void dragGestureRecognized(DragGestureEvent e) {
        try {
            Transferable transferable=new StringTransferable("Test",textPane);
            //initial cursor, transferable, dsource listener 
            e.startDrag(DragSource.DefaultCopyNoDrop, transferable,this);
            // or if dragSource is an instance variable:
            // dragSource.startDrag(e, DragSource.DefaultCopyNoDrop, transferable,dsListener);
        }catch( InvalidDnDOperationException idoe ) {System.err.println( idoe );}
    }

    public void dragEnter(DragSourceDragEvent e){}
    public void dragOver(DragSourceDragEvent e){}
    public void dragExit(DragSourceEvent e){}
    public void dropActionChanged (DragSourceDragEvent e){}

    public void dragDropEnd( DragSourceDropEvent e ) {
        if ( e.getDropSuccess() == false ) {
             return;
        }
        int dropAction = e.getDropAction();
        if ( dropAction == DnDConstants.ACTION_MOVE ){}

    }
}



class StringTransferable implements Transferable{
    public static final DataFlavor plainTextFlavor=DataFlavor.plainTextFlavor;
    public static final DataFlavor localStringFlavor=DataFlavor.stringFlavor;
    public static DataFlavor RTFFlavor=null;
    
    public static DataFlavor[] flavors=new DataFlavor[3];

    private static final List flavorList = Arrays.asList( flavors );

    private String data;
    private JTextPane textPane;
    
    public StringTransferable(String data,JTextPane textPane){
    	this.data=data;
    	this.textPane=textPane;
    	try {
    	    RTFFlavor=new DataFlavor("text/enriched");
    	} catch (Exception ex){System.err.println("Unable to create RTF flavor.");}
    	System.out.println(RTFFlavor.getMimeType());
        flavors[0]=plainTextFlavor;
        flavors[1]=localStringFlavor;
        flavors[2]=RTFFlavor;
    }
    
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }
    public boolean isDataFlavorSupported( DataFlavor flavor ) {
        return (flavorList.contains(flavor));
    }

    public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
	if (true/*flavor.equals(RTFFlavor)*/){
	    System.out.println("RTF !!!");
	    byte [] buf=new byte[10240];
	    ByteArrayOutputStream os=new ByteArrayOutputStream(10240);

	    StyledDocument doc=textPane.getStyledDocument();
	    try{
	        (textPane.getEditorKit()).write(os,doc,0,doc.getLength());
	    }catch(BadLocationException ex){System.err.println(ex);}
	    buf=os.toByteArray();
	    ByteArrayInputStream is=new ByteArrayInputStream(buf);
	    return is;
	}else if (flavor.equals(StringTransferable.plainTextFlavor)) {
            String charset = flavor.getParameter("charset").trim();
            if (charset.equalsIgnoreCase("unicode")) {
                System.out.println("returning unicode charset");
                // uppercase U in Unicode here!
                return new ByteArrayInputStream(data.getBytes("Unicode"));
            } else if (charset.equalsIgnoreCase("ascii")) {
                System.out.println("returning ascii charset");
                // uppercase U in Unicode here!
                return new ByteArrayInputStream(data.getBytes("Ascii"));
            }else{
                System.out.println("returning latin-1 charset"); 
                return new ByteArrayInputStream(data.getBytes("iso8859-1"));
            }
        } else if (StringTransferable.localStringFlavor.equals(flavor)) {
            return data;
        }else{
            throw new UnsupportedFlavorException (flavor);
        }
    }
}

