/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.io.File;


/***********************************
 * Provides an interface to the slider and all that goes with it
 */
public class TaskInput extends JDialog 
{

  private GenericComponent _gc = null;     //shijian 1-11-2001
  // for linking tasks
  private GenericComponent _gcPrevious = null;   
  private GenericComponent _gcCurrent = null;   

  private boolean _ok = false;
  
  boolean returnCode;

  JPanel contentPane;
  JPanel parsePanel = new JPanel();
  Component component1;
  Box box1;
  // change to textfield
  JTextField jTextField1 = new JTextField();
  JScrollPane mainScrollPane = new JScrollPane();
  BorderLayout borderLayout1 = new BorderLayout();
  JPanel bottomPanel = new JPanel();
  FlowLayout flowLayout1 = new FlowLayout();
  BorderLayout borderLayout2 = new BorderLayout();
  JPanel labelPanel = new JPanel();
  JLabel description = new JLabel();
  JPanel controlPanel = new JPanel();
  JButton cancelButton = new JButton();
  JButton OKButton = new JButton();
  JCheckBox linkBox = new JCheckBox("Link"); 
  
  //the interface will change based upon the mode(s) the parser is called in  
  private boolean linking = true;      //link constructed tasks together
    
  //Construct the frame
  public TaskInput() {
    super();
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
	
    OKButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        OKButton_actionPerformed(e);
      }
    });
  }

  //Construct the frame
  public TaskInput(Frame owner) {
    super(owner, true);//create a modal dialog
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }

      //if we are repeating, we need to add things after every return
      jTextField1.addActionListener(new java.awt.event.ActionListener() {

	public void actionPerformed(ActionEvent e) {
	  parseTextField_actionPerformed();
	}
      });
	
      OKButton.addActionListener(new java.awt.event.ActionListener() {

		public void actionPerformed(ActionEvent e) {
	  		OKButton_ContMode();
		}
      });
		
      parsePanel.add(linkBox); //only for repeating interface

  }
  

  //Component initialization
  private void jbInit() throws Exception  {
  	
    contentPane = (JPanel) this.getContentPane();
    component1 = Box.createVerticalStrut(8);
    box1 = Box.createVerticalBox();
    contentPane.setLayout(borderLayout1);
    this.setSize(new Dimension(500, 170));
    
    //this.setTitle("Edit");
    this.setTitle("Task Input"); 
    
    jTextField1.setColumns(500);
    jTextField1.setFont(new java.awt.Font("Monospaced", 0, 12));
    mainScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
    mainScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
    mainScrollPane.setPreferredSize(new Dimension(400, 65));
    parsePanel.setLayout(flowLayout1);
    bottomPanel.setLayout(borderLayout2);
    cancelButton.setText("Cancel");
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        cancelButton_actionPerformed(e);
      }
    });
    
    OKButton.setText("OK");
    contentPane.add(parsePanel, BorderLayout.CENTER);
    parsePanel.add(mainScrollPane, null);
    mainScrollPane.getViewport().add(box1, null);
    box1.add(jTextField1, null);
    box1.add(component1, null);
    
    //shijian 2001-4-3
    //parsePanel.add(parseButton, null);
    linkBox.setSelected(linking);  //brasser 2001-6-21
    linkBox.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
	if (e.getStateChange() == ItemEvent.SELECTED) {
	  linking = true;
	} else {
	  linking = false;
	}
      }
    });
	
    contentPane.add(bottomPanel, BorderLayout.SOUTH);
    bottomPanel.add(labelPanel, BorderLayout.NORTH);
    labelPanel.add(description, null);
    bottomPanel.add(controlPanel, BorderLayout.CENTER);
    controlPanel.add(OKButton, null);
    controlPanel.add(cancelButton, null);

  }

  //Overridden so we can exit when window is closed
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }

  public void run(String title)	//EditionDialog ed)
  {
    
    //taskManager = new TapeRecorder_TM_Manager(true); //brasser
	
    this.setTitle(title);
    
    // allow the user to mess with the interface
    setVisible(true);
    requestFocus();
  }
  

  void OKButton_actionPerformed(ActionEvent e) {

    //shijian: 27-2-2001
    //make sure there at least 3 words in the semantics
	 
    //parser.printConstituentTable(); 
	 
    String newSeman= jTextField1.getText();
    StringTokenizer stk = new StringTokenizer(newSeman);
    if (stk.countTokens() < 3){
      String mes =  "Enter at least 3 words, please!";
      JOptionPane.showMessageDialog(MainFrame.getMainFrame(),
				    mes, "Warning",JOptionPane.WARNING_MESSAGE);
      return;
    	
    }
    
    _ok = true;
	
    return;
  }

  void cancelButton_actionPerformed(ActionEvent e) {
    setVisible(false);
    _ok= false;
  }

  //shijian 2001-3-29
  public boolean isOK(){
    return _ok;
  }
  	
	
  //creates the domain and task model information	
  private void parseTextField_actionPerformed() {

    String taskName= jTextField1.getText().trim();
	
    //shijian
    //1-11-2001
    //if there is no text, 
    if (taskName.length() == 0) {
      setVisible(false);
      _ok= true;
      return;
    }
    _gc = NewManager.newTask(-1,-1,taskName);
    jTextField1.setText("");
    if (_gcPrevious != null && _gc != null &&
	linkBox.isSelected()){
      //create link between the coms
      //System.out.println("-----------ok create links");

      NewManager.newLink(_gcPrevious.getName(), 
			 _gc.getName());
    }
    if (_gc != null)
      _gcPrevious = _gc;
  
  }
  
  //called only in continuous, task mode
  private void OKButton_ContMode() {

    //shijian
    //1-11-2001
    parseTextField_actionPerformed();
  	
  	
    setVisible(false);
    _ok= true;
  }

}
