/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   Redistribution in source and binary forms, with or without modification, are not permitted.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;

import com.sun.xml.parser.Resolver;
import com.sun.xml.tree.XmlDocument;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TamotXMLValidator {

    InputSource input;
    XmlDocument doc;

    private void displayErrors(SAXParseException e,String fileName) {
        int lineNum = e.getLineNumber();
        
        JOptionPane.showMessageDialog(MainFrame.mainFrame,
            "The following error occurs when validating the XML document : \n"+
            e.getMessage()+"\n"+
            "\n"+
            "File = "+fileName+"\n"+
            "Error occurs around line "+lineNum,
            "Error",JOptionPane.ERROR_MESSAGE);
    }
    
    public boolean validateDocument(String fileName) {
        boolean result = true;
        
        try {
            input = Resolver.createInputSource (new File (fileName));
            doc = XmlDocument.createXmlDocument(input, true);
        }
        catch (SAXParseException err) {
            displayErrors(err,fileName);
            result = false;

        } catch (SAXException e) {
            System.out.println("TamotXMLValidator SAXException error : ");
            Exception    x = e.getException ();

            ((x == null) ? e : x).printStackTrace ();
            result = false;
        } catch (Throwable t) {
            System.out.println("TamotXMLValidator Throwable error : ");
            t.printStackTrace ();
            result = false;
        }
        
        return result;
    }
}