/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   Redistribution in source and binary forms, with or without modification, are not permitted.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.io.File;


public class TMUtility {
    
    public static void display(String ss) {
        //System.out.println("TMUtility : "+SystemOptions.domainModelFlag);
        if (SystemOptions.domainModelFlag) System.out.println(ss);
    }
    
    public static void display(String routineName,String ss) {
        System.out.println(routineName+" : "+ss);
    }
    
    public static void display(String routineName,Integer id2) {
        System.out.println(routineName+" : "+id2);
    }

    public static void display(String routineName,int i) {
        System.out.println(routineName+" : "+i);
    }

    public static void display(String routineName,double ii) {
        System.out.println(routineName+" : "+ii);
    }

    public static void display(String routineName,boolean flag) {
        System.out.println(routineName+" : "+flag);
    }

    public static void displayTab() {
        System.out.print("    ");
    }
    
    public static void displayTab(int j) {
        for (int i=0; i<j; i++)
            displayTab();
    }
    
    public static void displayLine(int j) {
        for (int i=0; i<j; i++)
            System.out.println("");
    }
    
    public static void displayGenericComponent(String routineName, GenericComponent gc) {
        /*
        if (gc instanceof LinkableComponent) {
            displayLinkableComponent(routineName,(LinkableComponent) gc);
            return;
        }
        */
        
        System.out.print(routineName+" : name = "+gc.getName()+", ID = "+gc.ID);
        System.out.println(" ("+gc.getX()+","+gc.getY()+")");
    }

    public static void displayGenericComponent(GenericComponent gc) {
        if (gc instanceof Link) {
            Link link = (Link) gc;
            
            displayLink(link);
        } else {
            if (gc instanceof LinkableComponent) {
                LinkableComponent lc = (LinkableComponent) gc;
                
                //System.out.print(lc.getName()+", ID = "+lc.ID);
                //System.out.print(" ("+lc.getX()+","+lc.getY()+")");
                //System.out.println(" ("+lc.backupX+","+lc.backupY+")");
                System.out.print(lc.getName()+", ID = "+lc.ID);
                System.out.println(" ("+lc.getX()+","+lc.getY()+")");
            } else {
                System.out.print(gc.getName()+", ID = "+gc.ID);
                System.out.println(" ("+gc.getX()+","+gc.getY()+")");
            }
        }
    }

    public static void displayLinkableComponent(String routineName, LinkableComponent lc) {
        if (lc != null)
            System.out.println(routineName+" : name = "+lc.getName()+", ID = "+lc.ID);
        else
            System.out.println(routineName+" : null");
        
        //System.out.print(routineName+" : name = "+lc.getName()+", ID = "+lc.ID);
        //System.out.print(" ("+lc.getX()+","+lc.getY()+")");
        //System.out.println(" ("+lc.backupX+","+lc.backupY+")");
    }

    public static void displayLink(Link link) {
        LinkableComponent lc1 = link.lc1;
        LinkableComponent lc2 = link.lc2;
        
        System.out.println("name = "+link.getName()+", ID = "+link.ID);
        
        if (lc1 != null)
            System.out.println("    lc1 = "+lc1.getName()+", ID = "+lc1.ID);
            
        if (lc2 != null)
            System.out.println("    lc2 = "+lc2.getName()+", ID = "+lc2.ID);
            
        if (link.parentName != null)
            System.out.println("    parentName = "+link.parentName);
    }
    
    public static void displayLink(String routineName, Link link) {
        System.out.print(routineName+" : ");
        displayLink(link);
    }
}