/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import java.util.*;


public class MainTree extends ImprovedJTree implements MouseListener {
    public MainTree() {
    	putClientProperty("JTree.lineStyle", "Angled");
    	
       	//addTreeSelectionListener(new FrameSelectionListener());
       	
       	addMouseListener(this);
       	addMouseListener(new PopupListener());
       	
        //DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        GenericComponentTreeCellRenderer renderer = new GenericComponentTreeCellRenderer();
        //renderer.setLeafIcon(new Task(""));
        renderer.setBackgroundSelectionColor(Task.BACKGROUND_SELECTED_COLOR);
        setCellRenderer(renderer);
    }

    /**
     * Required by MouseListener.
     * <p>External operations: depending on the state of the tree.
     */
    public void mousePressed(MouseEvent e) {
        Integer id2 = findID(e.getX(),e.getY());
        
       	TreePath treePath = getClosestPathForLocation(e.getX(),e.getY());
        
        // select the component in desktop
        if (id2 == null) Manager.select(treePath);
        else Manager.select(treePath,id2);
           
       	if (Manager.isLeaf(treePath)) {
       		Manager.openParentFrame(treePath);
       	}
       	else if (Manager.isRoot(treePath)) {
       	   	Manager.openChildFrame(treePath);
       	   	Manager.deselect();
       	   	Manager.selectNode(Manager.fetchTreePath(Manager.ROOT_STRING,null,Manager.tree));
       	}
        else if (isExpanded(treePath)) {
        	Manager.openChildFrame(treePath);
        }
       	else if (isCollapsed(treePath)) {
       		Manager.openParentFrame(treePath);
       	}
    }
    
    private Integer findID(int x,int y) {
        Integer result = null;

        // get name & parentName
        TreePath treePath = getClosestPathForLocation(x,y);
        TreePath parentPath = treePath.getParentPath();
        
        if (parentPath == null) return result;
        
        DefaultMutableTreeNode dmCurrentNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        String name = getName(dmCurrentNode);

        DefaultMutableTreeNode dmParentNode = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        String parentName = getName(dmParentNode);
        
        // find index of the duplicated task selected
        int index = 0;
        
        DefaultMutableTreeNode dmTmpNode;
        String tmpName;

        for (Enumeration e = dmParentNode.children();e.hasMoreElements();) {
            dmTmpNode = (DefaultMutableTreeNode)e.nextElement();
            
            tmpName = getName(dmTmpNode);
            if (tmpName.equals(name)) index++;
            
            if (dmTmpNode.equals(dmCurrentNode)) break;
        }
        
        // find the ID of the duplicated task
        Node parentNode = Manager.skeleton.toParentNode(name,parentName);
        
        result = parentNode.getID(name,index);

        //System.out.println("ID of component selected in left-hand tree = "+result);
        
        return result;
    }
    
    private String getName(DefaultMutableTreeNode dmNode) {
        return ((String)dmNode.getUserObject());
    }

    public void mouseEntered(MouseEvent e){}
    public void mouseExited(MouseEvent e){}
    public void mouseClicked(MouseEvent e){}
    public void mouseReleased(MouseEvent e){}
}