/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/


package taskModellingTool;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.reflect.*;
import java.util.*;
import javax.swing.tree.*;

public class LGserverDialog{

    private static final int MARGINX=5;
    private static final int MARGINY=5;
    private static final int GAPX=10;
    private static final int GAPY=5;
    private static final int SIZEX1=100;
    private static final int SIZEX2=250;
    private static final int SIZEXOK=60;
    private static final int SIZEXCANCEL=80;
    private static final int SIZEY=20;
    
    private static final Color BACKGROUND_COLOR=null;//Color.white;
    //private static final Color BACKGROUND_COLOR=new Color(255,255,255);
    private static final String LGSERVERLABEL ="Set Server Name";
      
    private boolean abort=false;
    
    private boolean modifyItself=true;
    
    private String oldName=null;    
    protected JTextField jTextF;
    protected LGServer lgSever;

          
    public LGserverDialog(){
        lgSever = new LGServer();
    	String [] options={"OK","Cancel"};
    	int n=JOptionPane.showOptionDialog(MainFrame.mainFrame,createPanel(),
    	    "Language Generation Server",JOptionPane.OK_CANCEL_OPTION,
    	    JOptionPane.PLAIN_MESSAGE,null,options,options[0]);

    	if (n == JOptionPane.OK_OPTION )
    	{
            String title = "Please reenter server name";
    	    if ( ((jTextF.getText()).equals("")) ) 
    	    {
    	        
    	        String mesg="The Language Server Name cannot be a empty!!";
    	       
                JOptionPane.showMessageDialog(MainFrame.mainFrame, mesg, title,
                       JOptionPane.WARNING_MESSAGE); // Icon icon) 
    	    
                LGserverDialog lgServer= new LGserverDialog();

            }
            else lgSever.setLGServerName(jTextF.getText());
         }
    }
    

    private JPanel createPanel(){
    	
    	JPanel panel=new JPanel();
        panel.setBackground(BACKGROUND_COLOR);
        panel.setFont(new Font("Helvetica", Font.PLAIN, 14));        
    	panel.setLayout(null);
    	JComponent jc;
    	int posx=MARGINX;
    	int posy=MARGINY;
    	    	
    	panel.setPreferredSize(new Dimension(MARGINX+SIZEX1+GAPX+SIZEX2,    
    	        MARGINY+(SIZEY+GAPY)*(3)));

        oldName= lgSever.getLGServerName();
    		    
    		    //Label
    	jc=new JLabel(LGSERVERLABEL);
    	           
    	              		    
    	jc.setBounds(posx,posy,SIZEX1,SIZEY);
    	posx+=SIZEX1+GAPX;
        panel.add(jc);
        
        //Value
        jTextF=new JTextField(oldName);
    	jTextF.setBounds(posx,posy+SIZEY+2*GAPY,SIZEX2,SIZEY);
    	
    	panel.add(jTextF);
        return panel;
    }

}

