/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.image.*;
import com.sun.media.jai.codec.*;
import javax.swing.*;

public class ImageGenerator {
	
    public static final int MARGIN=5;
    

    public static void createPNG(Node node,String filename) {
        Set set = node.keySet();
        int l = node.getNumCouples();
       // System.out.println("No of components= "+l);

    	//Thomas - html report
        //System.out.println("");
        //System.out.println("");
        //System.out.println("ImageGenerator begins for : "+filename);
        
        GenericComponent [] gc = new GenericComponent[l];
        
    	// temporary buffer to hold graphics in order to update x,y,width & height correctly
        // for all GenericComponent
    	BufferedImage tmpImage = new BufferedImage(1,1,BufferedImage.TYPE_3BYTE_BGR);
    	Graphics2D g2b = tmpImage.createGraphics();
        g2b.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);

        int i = 0;
        String name;
        Integer currentID;
        for (Iterator it=set.iterator();it.hasNext();) {
            //gc[i]=node.getComponent((String)it.next());
            name = (String)it.next();

            for (Iterator itID = node.getIDIterator(name);itID.hasNext();) {
                currentID = (Integer)(itID.next());

                gc[i] = node.getComponent(name,currentID);
            
                if (gc[i] instanceof Link)
                    ((Link)gc[i]).updateLink();                // in order to update x,y,width & height for links correctly
                gc[i].drawComponent(g2b);                   // in order to update x,y,width & height for tasks correctly
                i++;
            }
        }

   	    //Manager.skeleton.printRegister();				// for debugging only

   	    //Calculate image size
        int w=0;
        int h=0;
        int x=0;
        int y=0;
        if (l>0){
            x=gc[0].getX();
            y=gc[0].getY();
            //MODIFICATION
            /*if (gc[0] instanceof LinkableComponent) w=x+(int)Math.round(((LinkableComponent)gc[0]).giveWidth());
            else*/ w=x+gc[0].getWidth();
            h=y+gc[0].getHeight();
            int temp;
            for (i=1;i<l;i++){
            	temp=gc[i].getX();
                if (temp<x) x=temp;
                //MODIFICATION
                /*if (gc[i] instanceof LinkableComponent) temp+=(int)Math.round(((LinkableComponent)gc[i]).giveWidth());
                else */temp+=gc[i].getWidth();
                if (temp>w) w=temp;
                
            	temp=gc[i].getY();
                if (temp<y) y=temp;
                temp+=gc[i].getHeight();
                if (temp>h) h=temp;
            }
            w-=x;
            h-=y;
            x-=MARGIN;
            y-=MARGIN;
            w+=2*MARGIN;
            h+=2*MARGIN;
        } else {
            w=2*MARGIN;
            h=2*MARGIN;
        }
        
        //create image	
    	BufferedImage image=new BufferedImage(w,h,BufferedImage.TYPE_3BYTE_BGR);
    	Graphics2D g2=image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
        
   	    g2.setColor(Color.white);
        g2.fill(new Rectangle(0,0,w,h));        
        g2.translate(-x,-y);
        GenericComponent  gc1;
        for (i=0;i<l;i++){
            gc1=  gc[i];

            if (gc1 instanceof Link)
            	((Link)gc1).updateLink();

            //Thomas - html report
            //System.out.println(gc1.name+" : "+"("+gc1.getX()+","+gc1.getY()+") width = "+gc1.getWidth()+", height = "+gc1.getHeight());

            g2.translate(gc1.getX(),gc1.getY());
            gc1.drawComponent(g2);
            g2.translate(-gc1.getX(),-gc1.getY());            

            //System.out.println(gc1.name+" : "+"("+gc1.getX()+","+gc1.getY()+") width = "+gc1.getWidth()+", height = "+gc1.getHeight());
        }
        
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filename));
            ImageEncoder enc = ImageCodec.createImageEncoder("png",out,new PNGEncodeParam.RGB());
            enc.encode(image.getRaster(),image.getColorModel());
            out.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void findPNGCoordinates(Node node,String filename) {
        Set set = node.keySet();
        int l = node.getNumCouples();
        
        GenericComponent [] gc = new GenericComponent[l];
        
        // temporary buffer to hold graphics in order to update x,y,width & height correctly
        // for all GenericComponent
        BufferedImage tmpImage = new BufferedImage(1,1,BufferedImage.TYPE_3BYTE_BGR);
        Graphics2D g2b = tmpImage.createGraphics();
        g2b.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);

        int i = 0;
        String name;
        Integer currentID;
        for (Iterator it=set.iterator();it.hasNext();) {
            name = (String)it.next();

            for (Iterator itID = node.getIDIterator(name);itID.hasNext();) {
                currentID = (Integer)(itID.next());

                gc[i] = node.getComponent(name,currentID);
            
                if (gc[i] instanceof Link)
                    ((Link)gc[i]).updateLink();  // in order to update x,y,width & height for links correctly
                gc[i].drawComponent(g2b);        // in order to update x,y,width & height for tasks correctly
                i++;
            }
        }

        // Calculate whole image size including all components : (x,y), width & height
        int w=0;
        int h=0;
        int x=0;
        int y=0;
        if (l>0){
            x=gc[0].getX();
            y=gc[0].getY();
            w=x+gc[0].getWidth();
            h=y+gc[0].getHeight();
            int temp;
            for (i=1;i<l;i++){
                temp = gc[i].getX();
                if (temp<x) x=temp;
                temp += gc[i].getWidth();
                if (temp>w) w=temp;
                
                temp = gc[i].getY();
                if (temp<y) y=temp;
                temp += gc[i].getHeight();
                if (temp>h) h=temp;
            }
            w -= x;
            h -= y;
            x -= MARGIN;
            y -= MARGIN;
            w += 2*MARGIN;
            h += 2*MARGIN;
        } else {
            w = 2*MARGIN;
            h = 2*MARGIN;
        }
        
        // find the PNG coordinates
        int tmpX,tmpY,tmpW,tmpH;
        for (i=0;i<l;i++) {
            tmpX = gc[i].getX();
            tmpY = gc[i].getY();
            tmpW = gc[i].getWidth();
            tmpH = gc[i].getHeight();
            
            gc[i].pngX1 = tmpX - x;
            gc[i].pngY1 = tmpY - y;
            gc[i].pngX2 = gc[i].pngX1 + tmpW;
            gc[i].pngY2 = gc[i].pngY1 + tmpH;
        }
    }
    
//THE SAME AS PNG EXCEPTED IT IS THE OLD VERSION: DO NO USE
    public static void createJPEG(Node node,String filename){
        Set set=node.keySet();
        int l=set.size();
        GenericComponent [] gc=new GenericComponent[l];
        int i=0;
        for (Iterator it=set.iterator();it.hasNext();){
            gc[i++]=node.getComponent((String)it.next());  
        }
        //Calculate image size
        int w=0;
        int h=0;
        int x=0;
        int y=0;
        if (l>0){
            x=gc[0].getX();
            y=gc[0].getY();
            w=x+gc[0].getWidth();
            h=y+gc[0].getHeight();
            int temp;
            for (i=1;i<l;i++){
            	temp=gc[i].getX();
                if (temp<x) x=temp;
                temp+=gc[i].getWidth();
                if (temp>w) w=temp;
                
            	temp=gc[i].getY();
                if (temp<y) y=temp;
                temp+=gc[i].getHeight();
                if (temp>h) h=temp;
            }
            w-=x;
            h-=y;
            x-=MARGIN;
            y-=MARGIN;
            w+=2*MARGIN;
            h+=2*MARGIN;
        } else {
            w=2*MARGIN;
            h=2*MARGIN;
        }
        
        //create image	
    	BufferedImage image=new BufferedImage(w,h,BufferedImage.TYPE_3BYTE_BGR);
    	Graphics2D g2=image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
        
        g2.setColor(Color.white);
        g2.fill(new Rectangle(0,0,w,h));        
        g2.translate(-x,-y);
        for (i=0;i<l;i++){
            g2.translate(gc[i].getX(),gc[i].getY());
            gc[i].drawComponent(g2);
            g2.translate(-gc[i].getX(),-gc[i].getY());            
        }
        
        try {
        BufferedOutputStream out=new BufferedOutputStream(new FileOutputStream(filename));
        ImageEncoder enc=ImageCodec.createImageEncoder("jpeg",out,new JPEGEncodeParam());
        enc.encode(image.getRaster(),image.getColorModel());
        out.close();
        } catch (IOException e){System.err.println(e);}
    }


}

/*class ImageEnc extends ImageEncoderImpl{
    ImageEnc(java.io.OutputStream output, ImageEncodeParam param){
    	super(output,param);
    }
}*/
    /*class TestFrame extends JComponent {
    	public Node node;
    	public TestFrame(Node node){
    	    this.node=node;
    	    setSize(300,300);
    	}
    	public void paintComponent(Graphics g){
    	    super.paintComponent(g);
    	    Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
            Set set=node.keySet();
            GenericComponent gc;
            for (Iterator i=set.iterator();i.hasNext();){
                gc=node.getComponent((String)i.next());
                gc.drawComponent(g2);
            
            }
    	}
    }*/