/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.io.*;
import java.util.*;
import java.lang.reflect.*;
import javax.swing.JOptionPane;
import javax.swing.JFileChooser;
import javax.swing.text.*;
import javax.swing.text.rtf.*;
import javax.swing.text.html.*;

// for export the new domian model
import domainModel.*;
import utility.*;




public class ExportationLG{
	 private static final String MAPPING_FILE="cfg"+File.separator+"LGMapping.cfg";
	 private static final String MAPPING_FILE_LG_NEW="cfg"+File.separator+"LGMappingNDM.cfg";

	 private static final String DM_MAPPING_FILE="cfg"+File.separator+"DmConceptMapping.cfg";
	
	 private static final String OBJECT="(dm-object)";
	 private static final String ACTION="(dm-action)";
	 
	 private static DmManager _dMm=Manager.getXDM().getDmManager(); 
	 private static DmRelation _dMRelat = DmRelation.getInstance();

	 //String defined for manage domain model to LISP mapping
	 // domain instances
	 private static final String _DOMAIN_INSTANCE_BEGIN = "domain_instance_begin"; 	//	(def-dm-instance
	 private static final String _CONCEPT_OF  ="concept_of" ;		//:dm-concept
	 private static final String _CARDINALITY ="cardinality" ;		//:dm-cardinality
	 private static final String _PREMODIFIER="premodifier";		//:dm-premodifier
	 private static final String _POSTMODIFIER="postmodifier"	;	//:dm-postmodifier
	 private static final String _DIRTY="dirty"	;			//:dirty
	 private static final String _DOMAIN_RELATIONS ="domain_relations"; 	//:dm-relations
	 private static final String _BEGIN_REL ="begin_rel"; 		//(
	 private static final String _BEGIN_ITEM ="begin_item" ;		//(
	 private static final String _DOMAIN_RELATION_PREFIX ="domain_relation_prefix";	//dm-
	 private static final String _END_ITEM ="end_item" 	;	//)
	 private static final String _END_REL ="end_rel" ;		//)
	 private static final String _DOCUMENTATION_PREFIX ="documentation_prefix" ;	//:documentation
	 private static final String _DOMAIN_END ="domain_end" ;		//)
    private static final String _LABEL ="label"; // instance label
    
    //23-1-2002
    private static final String _1_OR_2_D ="1-2d"; // contextaul type
    private static final String _3_D ="3d"; // contextaul type
    
	 //18-10-2001
	 private static final String _DETERMINATOR ="determinator"; //object instance determinator
	 															//except for Interface instances
   //18-10-2001
   private static final String _CONTEXTUAL_TYPE ="contextual_type"; //object instance CONTEXTUAL TYPE

	 //Domain concept 		
	 private static final String _DOMAIN_CONCEPT_BEGIN ="domain_concept_begin";		//(def-dm-concept
	 private static final String _CONCEPT_TYPE ="concept_type"; 		//:dm-type
	 //private static final String _ENTITY_TYPE ="entity_type"; 		// 		dm-object
	 //private static final String _ENTITY_TYPE ="entity_type"; 		// 		dm-object
	 //private static final String _ENTITY_TYPE ="entity_type"; 		// 		dm-object
	 private static final String _USER_TYPE ="user_type" ; 		//		dm-user
	 private static final String _SYSTEM_TYPE ="system_type" ; 		//		dm-system
	 private static final String _INTERFACE_TYPE ="interface_type" ; 
	// private static final String _D3_INTERFACE_TYPE="d3_interface_type"; 	//		dm-system
	 private static final String _ACTION_TYPE ="action_type" ; 		//		dm-action
	 private static final String _SPELLING="spelling"; 		//	 	:dm-spelling
	 private static final String _MASSNOUN="mass_noun"; 		//	 	:dm-mass-noun
	 private static final String _PLURAL ="plural" ; 		//			dm-plural
	 private static final String _1ST_PERSON="1st_person"; 		//		:dm-1st-person
	 private static final String _3RD_PERSON="3rd_person"; 		//		:dm-3rd-person
	 private static final String _ING="ing"; 		//		:dm-ing
	 private static final String _PAST="past"; 		//			:dm-past
	 private static final String _PP="pp"	; 		//		:dm-pp
	 private static final String _PROP="prop"; 		//			:dm-prop
	 
	 private static final String _ACTION_CONCEPT_SUFFIX="action_concept_suffix"; 		//	FOR DM concept
	 private static final String _ENTITY_CONCEPT_SUFFIX="entity_concept_suffix"; 		//	FOR DM concept
 
	 // shijian 2001-2-20
	 // prefix for domain elements 
	 private static final String _PREFIX_CONCEPT="dmconcept_prefix"; 		//	FOR DM concept
	 private static final String _PREFIX_EINSTANCE="entity_instance_prefix"	; 		//	for entity instance
	 private static final String _PREFIX_AINSTANCE="action_instance_prefix"; 		//	for action instance
	 private static final String _SEMANTICS="semantics"; 		//	for action instance
	 
	 // shijian 2001-3-28
	 // prefix for additional task and link attributes 
	 private static final String _FEEDBACKDM="_feedbackDM"; 		
	 private static final String _PRECONDM="_preconDM"	; 	
	 private static final String _ACTOR="actor"; 	
	 private static final String _WARNING="warning"; 	
	 private static final String _OTHER="other"; 
	 
	 // shijian 2001-7-13
	 // document style parameters
	 private static final String _stylePackagePreffix="style_package_preffix"; 		
	 private static final String _stylePackagesuffix="style_package_suffix"	; 	
	 private static final String _styleParameter="style_parameter"; 	
	 private static final String _styleHow="style_how"; 	
	 private static final String _stepByStep="step_by_step"; 
	 
	 //25-7-2001
	 private static final String _modalityCan="modality_can"; 	
	 private static final String _purposeFirst="purpose_first"; 	
	 private static final String _conjunction="conjunction"; 	

	 private static final String _styleTrue="style_true"; 	
	 private static final String _styleFalse="style_false"; 	
	 
  ////3-10-2001 
	 /*
    public static void exportFromFile(File f) {
        Hashtable mapping;
    	BufferedReader in;
    	PrintWriter out;
    	//PrintStream out;
    	mapping=new Hashtable();
    	try{
    	    in=new BufferedReader(new FileReader(MAPPING_FILE));
    	    String s,s1,s2;
    	    StringTokenizer st;
    	    while ((s=in.readLine())!=null){
    	    	if (!s.trim().equals("")) if (!s.substring(0,1).equals("#")){
    	    	    st=new StringTokenizer(s);
    	    	    if (st.countTokens()>=2){
    	    	    	s1=st.nextToken();
    	    	    	s2=st.nextToken();
    	                mapping.put(s1,s2);
    	            }
    	        }
    	    }
	    in.close();
	    
	    out=new PrintWriter(new FileOutputStream(f));
        out.println("(in-package :dm)");
        out.println();
	    out.println(";;----------------------------------------------------");
	    out.println(";;                Task model part                     ");
	    out.println(";;----------------------------------------------------");
	    out.println();
	    writeComponents(out,mapping);
	    writeExpansions(out,mapping);
	    
            String [] options={"Yes","No"};
    	    String message="The Task Model has been exported.\n Would you like to incorporate the Domain Model?";
    	    int choice=JOptionPane.showOptionDialog(MainFrame.mainFrame,message,"Warning",JOptionPane.OK_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE,null,options,options[0]);
	    
	    if (choice==0){
	        out.println(";;----------------------------------------------------");
	        out.println(";;               Domain model part                    ");
	        out.println(";;----------------------------------------------------");
	        out.println();
	        
    	        final JFileChooser fc=new JFileChooser(FileManager.FOLDER);
    	        fc.addChoosableFileFilter(new IMPFilter());
                fc.setFileView(new TMTFileView());
    	        int returnVal=fc.showOpenDialog(MainFrame.mainFrame);
                if (returnVal==JFileChooser.APPROVE_OPTION) {
                    File ff=fc.getSelectedFile();
                    String ss=fc.getTypeDescription(ff);
                    if (ss.equals("TAMOT2 ASCII")) exportFromFileDomain(ff,out,mapping);
                }                
	    }
	    
	    out.close();
	} catch (Exception e){error("Exportation failed !!! "+e);}
    }
  */  
    public static void writeDomain(PrintStream out) {
    	TreeMap t = Manager.dmManager.actionMapping;
    	Set set = t.keySet();
        
    	DomainAction a;
    	DomainObject o;
        
    	for (Iterator i = set.iterator(); i.hasNext();) {
    	    a = (DomainAction)t.get(i.next());
            
    	    out.println(ACTION);
            
    	    out.println(a.name);  	    
    	    out.println(a.actor);
     	    out.println(a.actee);
    	    out.println(a.verb);
    	    out.println(a.proposition);
    	    out.println(a.documentation);
    	    out.println();
    	}
        
    	t = Manager.dmManager.objectMapping;
    	set = t.keySet();
        
    	for (Iterator i=set.iterator();i.hasNext();) {
    	    o = (DomainObject)t.get(i.next());
            
    	    out.println(OBJECT);
            
    	    out.println(o.name);  	    
    	    out.println(o.class_name);
     	    out.println(o.part_of);
    	    out.println(o.lexical_root);
    	    out.println(o.documentation);
    	    out.println(o.cardinality);

    	    out.println();
    	}
    }
    
    //deprecated
    private static void exportFromFileDomain(File f,PrintWriter out,Hashtable mapping){
    	
    	String s,ss; 
    	try {
    	    BufferedReader in=new BufferedReader(new FileReader(f));
    	    while ((s=in.readLine())!=null){
    	        if (s.equals(OBJECT)){    	            
    	            s=in.readLine();
    	            out.println((String)mapping.get("domain_begin")+" "+s);
    	            
    	            s=in.readLine();
    	            if (!s.equals("")) out.println((String)mapping.get("classname")+" "
    	                +(String)mapping.get("domain_class_prefix")+s);
    	            
    	            s=in.readLine();
    	            if (!s.equals("")) out.println((String)mapping.get("domain_relations")+" "+
    	                (String)mapping.get("begin_rel")+(String)mapping.get("begin_item")+
    	                (String)mapping.get("part_of")+" "+s+(String)mapping.get("end_item")+
    	                (String)mapping.get("end_rel"));
    	            
    	            out.println((String)mapping.get("cardinality")+" "+"singular");
    	            
    	            s=in.readLine();
    	            if (!s.equals("")) out.println((String)mapping.get("lexical-root")+" \""+s+ "\"");
    	            
    	            s=in.readLine();
    	            if (!s.equals("")) out.println((String)mapping.get("documentation")+" \""+s+ "\"");
    	            
    	            out.println((String)mapping.get("domain_end"));
    	            out.println();
    	        }
    	        else if (s.equals(ACTION)){
    	            s=in.readLine();
    	            out.println((String)mapping.get("domain_begin")+" "+s);
    	            
    	            if (!s.equals("")) out.println((String)mapping.get("classname")+" "+"dm-action");
    	            
    	            s=in.readLine();
    	            ss=in.readLine();
    	            if ((!s.equals(""))&&(!s.equals(""))) out.println((String)mapping.get("domain_relations")+" "
    	                +(String)mapping.get("begin_rel")+(String)mapping.get("begin_item")+
    	                (String)mapping.get("dm-actor")+" "+s+(String)mapping.get("end_item")+
    	                (String)mapping.get("begin_item")+(String)mapping.get("dm-actee")+" "+
    	                ss+(String)mapping.get("end_item")+(String)mapping.get("end_rel"));
    	            else if ((!s.equals(""))&&(s.equals(""))) out.println((String)mapping.get("domain_relations")
    	                +" "+(String)mapping.get("begin_rel")+(String)mapping.get("begin_item")+
    	                (String)mapping.get("dm-actor")+" "+s+(String)mapping.get("end_item")+
    	                (String)mapping.get("end_rel"));
    	            else if ((s.equals(""))&&(!s.equals(""))) out.println((String)mapping.get("domain_relations")
    	                +" "+(String)mapping.get("begin_rel")+(String)mapping.get("begin_item")+
    	                (String)mapping.get("dm-actee")+" "+ss+(String)mapping.get("end_item")+
    	                (String)mapping.get("end_rel"));
    	                	            
    	            s=in.readLine();
    	            if (!s.equals("")) out.println((String)mapping.get("lexical-root")+" \""+s+ "\"");
    	            
    	            s=in.readLine();
    	            if (!s.equals("")) out.println((String)mapping.get("documentation")+" \""+s+ "\"");

    	            out.println((String)mapping.get("domain_end"));
    	            out.println();
    	        }
    	    }
    	    in.close();
        } catch (Exception excep){error("Error in Domain Model!!!  "+excep);}
    }
 
    /*2001
    public static void export(File f){
        Hashtable mapping;
    	  BufferedReader in;
    */	
    /*	PrintStream out; change to PrintWriter for output plaintext as opposed to styled-text
     *	As a result, the definition of the following methods needs to be changed accordingly
     *		writeComponents(out,mapping);
     *    	writeExpansions(out,mapping);
     *		exportDomain(out,mapping);
     *		writeNode(PrintWriter out,Node node,String name,Set expansionSet,Hashtable mapping)
     *		write(GenericComponent gc,PrintWriter o,Hashtable mapping)
     *		exportFromFileDomain(ff,out,m
     *		writeTask((Task)gc,o,mapping);
     *		writeBooleanConnector((BooleanC
     *		writeBooleanConnector((BooleanC
     *		writeLink((Link)gc,o,mapping);
     */	  	
 /*   	PrintWriter out;
    	mapping=new Hashtable();
    	try{
    	    in=new BufferedReader(new FileReader(MAPPING_FILE));
    	    String s,s1,s2;
    	    StringTokenizer st;
    	    while ((s=in.readLine())!=null){
    	    	if (!s.equals("")) if (!s.substring(0,1).equals("#")){
    	    	    st=new StringTokenizer(s);
    	    	    if (st.countTokens()>=2){
    	    	    	s1=st.nextToken();
    	    	    	s2=st.nextToken();
    	                mapping.put(s1,s2);
    	            }
    	        }
    	    }
	    in.close();
	    
	    out=new PrintWriter(new FileOutputStream(f));

        out.println("(in-package :dm)");
        out.println();

	    out.println(";;----------------------------------------------------");
	    out.println(";;                Task model part                     ");
	    out.println(";;----------------------------------------------------");        
	    out.println();
	    //writeComponents(out,mapping);
       // writeExpansions(out,mapping);
        writeComponentsWithParent(out,mapping);
	    writeExpansionsWithParent(out,mapping);
	    
          /*  /*String [] options={"Yes","No"};
    	    String message="The Task Model has been exported.\n Would you like to incorporate the Domain Model?";
    	    int choice=JOptionPane.showOptionDialog(MainFrame.mainFrame,message,"Warning",JOptionPane.OK_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE,null,options,options[0]);*/
	    
	    //if (choice==0){
	 /*       out.println(";;----------------------------------------------------");
	        out.println(";;               Domain model part                    ");
	        out.println(";;----------------------------------------------------");
	        out.println();
	        
                exportDomain(out,mapping);
                
	    //}
	    
	    out.close();
	} catch (Exception e){error("Exportation failed !!! "+e);}
    }
 */   
    private static void exportDomain(PrintWriter out,Hashtable mapping){
    	
    	try {
    	    TreeMap t=Manager.dmManager.actionMapping;
    	    Set set=t.keySet();
    	    DomainAction a;
    	    String s,ss,sss;
    	    for (Iterator i=set.iterator();i.hasNext();){
    	    	a=(DomainAction)t.get(i.next());

                if ( !a.name.equals(""))
                {
    	        	//System.out.print("Exportion Domain Action: "+a.name+"...");
    	            out.println((String)mapping.get("domain_begin")+" "+relpaceSpaceWithDash(a.name));
    	                
                    s=a.name;
    	            if (!s.equals("")) out.println((String)mapping.get("classname")+" "+"dm-action");
    	            s=a.verb;
    	            if (!s.equals("")) out.println((String)mapping.get("lexical-root")+" "+ "\"" + s+ "\"");
                
    	            s=a.actor;
    	            ss=a.actee;
    	            sss=a.proposition;
    	            if (sss.equals("")){
    	                if ((s != null)&&(!s.equals(""))) 
    	                {
    	                	out.println((String)mapping.get("domain_relations")+" "+(String)mapping.get("begin_rel")+
    	                	(String)mapping.get("begin_item")+(String)mapping.get("actor")+" "+s+
    	                	(String)mapping.get("end_item"));
    	                	out.println("                " + (String)mapping.get("begin_item")+
    	                	(String)mapping.get("actee")+" "+ss+(String)mapping.get("end_item")+
    	                	(String)mapping.get("end_rel"));
			    
		                }
		        	            
    	                else if ((!s.equals(""))&&(s.equals(""))) out.println((String)mapping.get("domain_relations")+
    	                " "+(String)mapping.get("begin_rel")+(String)mapping.get("begin_item")+
    	                (String)mapping.get("actor")+" "+s+(String)mapping.get("end_item")+(String)mapping.get("end_rel"));
    	                else if ((s.equals(""))&&(!s.equals(""))) out.println((String)mapping.get("domain_relations")+
    	                " "+(String)mapping.get("begin_rel")+(String)mapping.get("begin_item")+
    	                (String)mapping.get("actee")+" "+ss+(String)mapping.get("end_item")+(String)mapping.get("end_rel"));
    	            }else {
    	                if ((s != null)&&(!s.equals(""))) 
    	                {
    	                	out.println((String)mapping.get("domain_relations")+" "+(String)mapping.get("begin_rel")+
    	                	(String)mapping.get("begin_item")+(String)mapping.get("actor")+" "+s+
    	                	(String)mapping.get("end_item"));
    	                	out.println("                    " + (String)mapping.get("begin_item")+
    	                	(String)mapping.get("actee")+" "+ss+(String)mapping.get("end_item"));	
    	                	out.println("                    " +(String)mapping.get("begin_item")+
    	                	(String)mapping.get("proposition")+" "+relpaceSpaceWithDash(sss)+
    	                	(String)mapping.get("end_item")+ (String)mapping.get("end_rel"));
    	                }
    	            
    	                else if ((!s.equals(""))&&(s.equals(""))) out.println((String)mapping.get("domain_relations")+
    	                " "+(String)mapping.get("begin_rel")+(String)mapping.get("begin_item")+
    	                (String)mapping.get("actor")+" "+s+(String)mapping.get("end_item")+
    	                (String)mapping.get("begin_item")+(String)mapping.get("proposition")+
    	                " "+sss+(String)mapping.get("end_item")+(String)mapping.get("end_rel"));
    	                else if ((s.equals(""))&&(!s.equals(""))) out.println((String)mapping.get("domain_relations")+
    	                " "+(String)mapping.get("begin_rel")+(String)mapping.get("begin_item")+
    	                (String)mapping.get("actee")+" "+ss+(String)mapping.get("end_item")+
    	                (String)mapping.get("begin_item")+(String)mapping.get("proposition")+
    	                " "+sss+(String)mapping.get("end_item")+(String)mapping.get("end_rel"));
    	            }    	                  	            
    	                  	            
 	                    	            
    	            s=a.documentation;
    	            if (!s.equals("")) out.println((String)mapping.get("documentation_prefix")+" \""+s+ "\"");
                
    	            out.println((String)mapping.get("domain_end"));
    	            out.println();
    	        	//System.out.println("Ok");
               }
    	    }
    	    t=Manager.dmManager.objectMapping;
    	    set=t.keySet();
    	    DomainObject o;
    	    for (Iterator i=set.iterator();i.hasNext();){
    	    	o=(DomainObject)t.get(i.next());
    	    	//System.out.print("Exportion Domain Object: "+o.name+"...");
                if ( !o.name.equals(""))
                {
    	            out.println((String)mapping.get("domain_begin")+" "+relpaceSpaceWithDash(o.name));
    	                
    	            s=o.class_name;
    	            if (!s.equals("")) out.println((String)mapping.get("classname")+" "+
    	            (String)mapping.get("domain_class_prefix")+s);
    	            //else     	   out.println((String)mapping.get("classname")+" "+"dm-object";
   	                
    	            s=o.cardinality;
    	            out.println((String)mapping.get("cardinality")+" "+s);
    	                
    	            s=o.lexical_root;
    	            if (!s.equals("")) out.println((String)mapping.get("lexical-root")+" \""+s+ "\"");
    	            s=o.part_of;
    	            if (!s.equals("")) out.println((String)mapping.get("domain_relations")+" "+
    	            (String)mapping.get("begin_rel")+(String)mapping.get("begin_item")+
    	            (String)mapping.get("part_of")+" "+s+(String)mapping.get("end_item")+(String)mapping.get("end_rel"));
     	                
    	            s=o.documentation;
    	            if (!s.equals("")) out.println((String)mapping.get("documentation_prefix")+" \""+s+ "\"");
    	                
    	            out.println((String)mapping.get("domain_end"));
    	            out.println();
    	        	//System.out.println("Ok");
                }
    	    }
        } catch (Exception excep){error("Error in Domain Model!!!  "+excep);}
    }
 ////3-10-2001 
    /*
    private static void write(GenericComponent gc,PrintWriter o,Hashtable mapping){
    	if (gc instanceof Task) writeTask((Task)gc,o,mapping);
    	else if (gc instanceof BooleanConnector) writeBooleanConnector((BooleanConnector)gc,o,mapping);
    	else if (gc instanceof Link) writeLink((Link)gc,o,mapping);
    }
    
    private static void writeTask(Task t,PrintWriter o,Hashtable mapping){				//task_composite_begin :expansion  task_composite_prefix exp
    	if (mapping.containsKey("task_prefix")&&mapping.containsKey("task_begin")&&
    	mapping.containsKey("task_end")&&mapping.containsKey("task_composite_begin")&&
    	mapping.containsKey("task_composite_prefix")&&mapping.containsKey("documentation_prefix")){
    	    o.println((String)mapping.get("task_begin")+" "+(String)mapping.get("task_prefix")+
    	    relpaceSpaceWithDash(t.getName()));
    	    if(t.composite) 
    	    {
    	    	o.print((String)mapping.get("task_composite_begin")+" ");
    	    	o.println((String)mapping.get("task_composite_prefix")+ relpaceSpaceWithDash(t.getName()));
    	    }
    	    
    	    String s;
    	    Class c=t.getClass();
    	    Field field;
    	    String type;
    	    for (int i=0;i<t.dialogsFields.length;i++){
    	    	s=(String)t.dialogsFields[i];
    	    	if (mapping.containsKey(s)){
    	          try{
    	    	    field=c.getField(s);
    	    	    type=field.getType().getName();
    	    	    if (type.equals("boolean"))
    	    	    {
    	    	    	boolean b=field.getBoolean(t);   	    	
    	    	    	if (b) o.println((String)mapping.get(s)+" "+b);
    	            }
    	            else if (type.equals("int")){
    	    	        int nb=field.getInt(t);    	    	
    	    	    	o.println((String)mapping.get(s)+" "+nb);
   	            }
    	            else if (type.equals("java.lang.String")) 
    	            {
    	            	String str=(String)field.get(t);
    	    	        if (!str.equals("")){
    	    	    	    o.println((String)mapping.get(s)+" "+relpaceSpaceWithDash(str) );
    	    	        }

    	    	        
    	            }
    	          }catch (Exception excep){error("Error in Task!!!  "+excep);}
    	        }
    	    }
    	    String name =t.getName();
    	    if (Manager.RTFDB.containsKey(name)){
    	            DefaultStyledDocument doc=Manager.RTFDB.getDocument(name);

    	            if (doc.getLength()!=0) {
    	            	o.print((String)mapping.get("documentation_prefix") + " \"");
    	            	try{
    	            		o.println(doc.getText(0, doc.getLength()));
    	                } catch (Exception ex){}
                        o.print("\"");
    	   */     /*       
    	                o.println((String)mapping.get("documentation_prefix"));
    	                RTFEditorKit kit=(RTFEditorKit)Manager.editor.textPane.getEditorKit();
    	                try{
    	                    kit.write(o,doc,0,doc.getLength());
    	                } catch (Exception ex){}
    	          */   //  out.println();	
    	               // out.println(END_DESCRIPTION);	
    	              // out.println();	getContent,
    /*	            }
    	    }
    	    
    	    
    	    o.println((String)mapping.get("task_end"));
    	    o.println();
    	    
    	    // set dirty to false after the language generation file is exported
    	    t.dirty= false;
    	    
    	    
    	} else error("Script error (Task)");
    }
   */ 
    private static void writeBooleanConnector(BooleanConnector b,PrintWriter o,Hashtable mapping){
    	if (mapping.containsKey("boolean_connector_prefix")&&mapping.containsKey("boolean_connector_begin")&&
    	mapping.containsKey("boolean_connector_end")){
    	    o.println((String)mapping.get("boolean_connector_begin")+" "+
    	    (String)mapping.get("boolean_connector_prefix")+b.getName());
    	    String s;
    	    Class c=b.getClass();
    	    Field field;
    	    String type;
    	    for (int i=0;i<b.dialogsFields.length;i++){
    	    	s=(String)b.dialogsFields[i];
    	    	if (mapping.containsKey(s)){
    	          try{
    	    	    field=c.getField(s);
    	    	    type=field.getType().getName();
    	    	    if (type.equals("java.lang.String")){
    	    	        String str=(String)field.get(b);
    	    	        if (!str.equals("")){
    	    	    	    o.println((String)mapping.get(s)+" "+str);
    	    	        }
    	            }
    	            else if (type.equals("int")){
    	    	        int nb=field.getInt(b);    	    	
    	    	    	o.println((String)mapping.get(s)+" "+nb);
   	            }
    	            else if (type.equals("boolean")) {
    	    	        boolean bb=field.getBoolean(b);    	    	
    	    	    	o.println((String)mapping.get(s)+" "+bb);
    	            }
    	          }catch (Exception e){}
    	        }
    	    }
    	    o.println((String)mapping.get("boolean_connector_end"));
    	    o.println();
    	} else error("Script error (BooleanConnector)");
    }
    
    private static void writeLink(Link l,PrintWriter o,Hashtable mapping){
    	if (mapping.containsKey("link_prefix")&&mapping.containsKey("link_begin")&&
    	mapping.containsKey("link_end")&&mapping.containsKey("origin")&&mapping.containsKey("destination")){
    	    o.println((String)mapping.get("link_begin")+" "+(String)mapping.get("link_prefix")+l.getName());
    	    //o.println((String)mapping.get("origin")+" "+l.lc1.getName());
    	    //o.println((String)mapping.get("destination")+" "+l.lc2.getName());
    	    o.println((String)mapping.get("origin")+" "+"action-"+ relpaceSpaceWithDash(l.lc1.getName())); //name1));
    	    o.println((String)mapping.get("destination")+" "+"action-"+ relpaceSpaceWithDash(l.lc2.getName())); //name2));
    	    String s;
    	    Class c=l.getClass();
    	    Field field;
    	    String type;
    	    for (int i=0;i<l.dialogsFields.length;i++){
    	    	s=(String)l.dialogsFields[i];
    	    	if (mapping.containsKey(s)){
    	          try{
    	    	    field=c.getField(s);
    	    	    type=field.getType().getName();
    	    	    if (type.equals("java.lang.String")){
    	    	        String str=(String)field.get(l);
    	    	        if (!str.equals("")){
    	    	    	    o.println((String)mapping.get(s)+" "+str);
    	    	        }
    	            }
    	            else if (type.equals("int")){
    	    	        int nb=field.getInt(l);    	    	
    	    	    	o.println((String)mapping.get(s)+" "+nb);
   	            }
    	            else if (type.equals("boolean")) {
    	    	        boolean b=field.getBoolean(l);    	    	
    	    	    	o.println((String)mapping.get(s)+" "+b);
    	            }
    	          }catch (Exception e){}
    	        }
    	    }
    	    o.println((String)mapping.get("link_end"));
    	    o.println();
    	} else error("Script error (Link)");
    }
 ////3-10-2001 
    /*
    private static void writeComponents(PrintWriter out,Hashtable mapping){
        Set compSet=new TreeSet();
    	Set set=Manager.skeleton.nodeRegister.keySet();
    	GenericComponent gc;
    	String name;
    	for (Iterator i=set.iterator();i.hasNext();){
            String pName= (String) i.next();
    	    gc=Manager.skeleton.stringToFirstGenericComponent(pName);   //(String)i.next());
    	    name=gc.getName();
            
             
            String mesg =   "Task Name: "+ name+ "  Parent Name: " +  pName;
            JOptionPane.showMessageDialog(MainFrame.mainFrame,mesg);


    	    if (!compSet.contains(name)){
    	    	compSet.add(name);
    	        System.out.print("Writing "+name+" ...");
    	        write(gc,out,mapping);
    	        System.out.println("OK");
    	        
    	   */     /*if (Manager.RTFDB.containsKey(name)){
    	            DefaultStyledDocument doc=Manager.RTFDB.getDocument(name);
    	            if (doc.getLength()!=0){
    	                out.println(BEGIN_DESCRIPTION);
    	                RTFEditorKit kit=(RTFEditorKit)Manager.editor.textPane.getEditorKit();
    	                try{
    	                    kit.write(out,doc,0,doc.getLength());
    	                } catch (Exception ex){}
    	                out.println();	
    	                out.println(END_DESCRIPTION);	
    	                out.println();	
    	            }
    	        }*/
  /*  	    }
    	}       	
    }
  */  
    private static void writeExpansions(PrintWriter out,Hashtable mapping){
    	if (mapping.containsKey("root"))
            writeNode(out,Manager.skeleton.root,(String)mapping.get("root"),new TreeSet(),mapping);
    }
    private static void writeNode(PrintWriter out,Node node,String name,Set expansionSet,Hashtable mapping){
    	System.out.print("Writing expansion "+name+" ...");
      if (mapping.containsKey("expansion_begin")&&mapping.containsKey("expansion_prefix")&&
      mapping.containsKey("start_expansion")&&  //mapping.containsKey("expansion_separator")&&
      mapping.containsKey("finish_expansion")&&mapping.containsKey("expansion_end")){
    	if (name.equals((String)mapping.get("root"))) out.println((String)mapping.get("expansion_begin")+
    	    " " + relpaceSpaceWithDash(name));
    	else out.println((String)mapping.get("expansion_begin")+" "+
    	    (String)mapping.get("expansion_prefix")+ relpaceSpaceWithDash(name));
    	Set keys=node.keySet();
    	Couple c;
    	LinkableComponent lc;
    	String childName;
    	LinkedList list=new LinkedList();
    	int nb=0;
   	
   	//1. print the node
    	if (keys.size()>0) out.print((String)mapping.get("start_expansion"));
    	boolean first;
    	boolean already=false;
    	for (Iterator it=keys.iterator();it.hasNext();){
            childName=(String)it.next();
    	    c=node.getCouple(childName);
    	    if (c.object instanceof LinkableComponent){
    	    	lc=(LinkableComponent)c.object;
    	    	first=firstComponent(lc);
    	    	if (lc instanceof Task) {
    	    	    if (first) {
    	    	    	if (already) out.print(" "); // using space as expansion_separator --- ((String)mapping.get("expansion_separator"));
    	    	    	out.print((String)mapping.get("task_prefix")+relpaceSpaceWithDash(childName));
    	    	        already=true;
    	    	    }
    	    	}
    	    	else if (lc instanceof BooleanConnector) {
    	    	    if (first) {
    	    	    	if (already) out.print(" "); // using space as expansion_separator ---((String)mapping.get("expansion_separator"));
    	    	    	out.print((String)mapping.get("boolean_connector_prefix")+ relpaceSpaceWithDash(childName));
    	    	        already=true;
    	    	    }
    	    	}
    	    	if (!it.hasNext()) out.println((String)mapping.get("finish_expansion"));
                //only for a CompositeComponent
    	    	if (!c.node.isEmpty()){
    	    	    list.add(c.node);
    	    	    list.add(childName);
    	    	    nb++;
    	    	}
    	    }
    	}
    	out.println((String)mapping.get("expansion_end"));
    	out.println();
    	
    	//System.out.println("OK");

    	//System.out.println(name+" contains "+nb+" branch(es)");
    	
    	//2. print the branches
    	Node n;
    	for (int i=0;i<nb;i++){
    	    n=(Node)list.removeFirst();
    	    childName=(String)list.removeFirst();
    	    if (!expansionSet.contains(childName)){
    	    	expansionSet.add(childName);
    	    	writeNode(out,n,childName,expansionSet,mapping);
    	    }
    	}
      }
    }
    
    private static boolean firstComponent(LinkableComponent lc){
    	boolean result=true;
    	int nb=lc.linkList.size();
    	Link l;
    	for (int i=0;i<nb;i++){
    	    l=(Link)lc.linkList.elementAt(i);
    	    if (l.lc2==lc) {
    	    	result=false;
    	    	break;
    	    }
    	}
    	return result;
    }
    
    public static void importDomainChooser(){
    	final JFileChooser fc=new JFileChooser(FileManager.FOLDER);
    	fc.addChoosableFileFilter(new IMPFilter());
        fc.setFileView(new TMTFileView());
    	int returnVal=fc.showOpenDialog(MainFrame.mainFrame);
        if (returnVal==JFileChooser.APPROVE_OPTION) {
            File ff=fc.getSelectedFile();
            String ss=fc.getTypeDescription(ff);
            if (ss.equals("TAMOT2 ASCII")) importDomain(ff);
        }                
    	
    }
    
    public static void importDomain(File f) {
    	Hashtable mapping;
    	BufferedReader inMapping;
    	mapping=new Hashtable();
    	try{
    	    inMapping=new BufferedReader(new FileReader(DM_MAPPING_FILE));
    	    String sDm,s1,s2;
    	    StringTokenizer st;
    	    while ((sDm=inMapping.readLine())!=null){
    	    	if (!sDm.equals("")) if (!sDm.substring(0,1).equals("#")){
    	    	    st=new StringTokenizer(sDm);
    	    	    if (st.countTokens()>=2){
    	    	    	// change all entries into lower case, so that to  
    	    	    	// achieve case insensitive effect
    	    	    	s1=(st.nextToken()).toLowerCase(); //s1=st.nextToken() ;
    	    	    	s2=(st.nextToken()).toLowerCase(); //s1=st.nextToken();

    	                mapping.put(s1,s2);
    	            }
    	        }
    	    }
	        inMapping.close();
	    
	    
	    	String s,ss; 
	    	try {
	    	    BufferedReader in=new BufferedReader(new FileReader(f));
	    	    DomainAction a;
	    	    DomainObject o;
	    	    while ((s=in.readLine())!=null){
	    	        if (s.equals(OBJECT)){    	                	            
	    	            s=in.readLine();
	    	            o=new DomainObject(s);
	    	            Manager.dmManager.register(s,o);    
	    	            System.out.println("dm-object: " + s);	            
	    	            s=in.readLine();
	    	            System.out.println("before mapping: " + s);
	    	            s=(String)mapping.get(s.toLowerCase());	// use lower case always
	    	            if (s ==null ||s.equals("")) s = "object";
	    	            System.out.println("after mapping: " + s);
	    	            
	     	            o.setClassName(s);
	    	            s=in.readLine();
	    	            o.setPartOf(s); 	            
	    	            s=in.readLine();
	    	            o.setLexicalRoot(s);     	            
	    	            s=in.readLine();
	    	            o.setDocumentation(s);
	    	            s=in.readLine();
	    	            if (s.equals("")) o.setCardinality(DomainModelManager.CARDINALITY_CONTENTS[0]);
	    	            else o.setCardinality(s);

	/*    	            
	     	            o.class_name=s.toLowerCase();
	   	               	        
	    	            s=in.readLine();
	    	            o.part_of=s.toLowerCase(); 	            
	    	            s=in.readLine();
	    	            o.lexical_root=s.toLowerCase();    	            
	    	            s=in.readLine();
	    	            o.documentation=s;
	  */  	
	    	        }
	    	        else if (s.equals(ACTION)){
	    	            s=in.readLine();
	    	            a=new DomainAction(s);
	    	            Manager.dmManager.register(s,a);
	    	            s=in.readLine();
	    	            a.setActor(s);	//a.actor=s;
                        if (!(Manager.dmManager.isDmObjKey(s)) )
                        {
                          o=new DomainObject(s);
                          Manager.dmManager.register(s,o);
                        }

	    	            s=in.readLine();
	    	            a.setActee(s); 	//a.actee=s;
                        if (!(Manager.dmManager.isDmObjKey(s))) 
                        {
                          o=new DomainObject(s);
                          Manager.dmManager.register(s,o);
                        }


	    	            s=in.readLine();
	    	            a.setVerb(s);  	//a.verb=s;
	    	            s=in.readLine();
	    	            a.setProposition(s); 	//a.proposition=s;
                         if (!(Manager.dmManager.isDmObjKey(s))) 
                         {
                           o=new DomainObject(s);
                           Manager.dmManager.register(s,o);
                         }




	    	            s=in.readLine();
	    	            a.setDocumentation(s); 	//a.documentation=s;
	    	        }
	    	    }
	    	    in.close();
	        } catch (Exception excep){error("Error in Domain Model!!!  "+excep);}    
	    } catch (Exception e){error("Importation failed !!! "+e);}	
    }
    
    
    protected static void error(String s){
    	JOptionPane.showMessageDialog(MainFrame.mainFrame, s, "Error",JOptionPane.ERROR_MESSAGE);
    }

   protected static String relpaceSpaceWithDash(String s){
         
        int m = s.length();
        if (m == 0) return  s;

        StringBuffer sb=new StringBuffer("");
        for (int i = 0; i<m;i++ )
        {
            if (s.charAt(i) == ' ')  sb.append('-');
            else sb.append(s.charAt(i));

        }


        return sb.toString();

   }


   ///--------------------------------------------------------------------------------------------

      private static void writeComponentsWithParent(PrintWriter out,Hashtable mapping){
        Set compSet=new TreeSet();
      	Set set=Manager.skeleton.nodeRegister.keySet();
      	GenericComponent gc;
      	String name;
      	for (Iterator i=set.iterator();i.hasNext();){
              String pName= (String) i.next();
      	    gc=Manager.skeleton.stringToFirstGenericComponent(pName);   //(String)i.next());
      	    name=gc.getName();
              
       	    if (!compSet.contains(name)){
      	    	compSet.add(name);
                Set keys=((TreeMap)Manager.skeleton.nodeRegister.get(name)).keySet();
                String parentName;
                for (Iterator it=keys.iterator();it.hasNext();){
                    parentName=(String)it.next();
                    if (parentName.equals("/"))         //KernelTree.TOP_ROOT))
                        parentName= (String)mapping.get("root");

                  //  String mesg =   "Task Name: "+ name+ "  Parent Name: " +  parentName;
                  //  JOptionPane.showMessageDialog(MainFrame.mainFrame,mesg);
                    
                     writeWithParent(gc,out,mapping,parentName);
                }
      	    }
      	}       	
      }

     private static void writeWithParent(GenericComponent gc,
                                        PrintWriter o,
                                        Hashtable mapping,
                                        String parent){
     	if (gc instanceof Task) 
     	        writeTaskWithParent((Task)gc,o,mapping,parent);
     	else if (gc instanceof BooleanConnector) 
     	        writeBooleanConnectorWithParent((BooleanConnector)gc,o,mapping,parent);
     	else if (gc instanceof Link) 
     	        writeLinkWithParent((Link)gc,o,mapping,parent);
     }


    private static void writeTaskWithParent(Task t,PrintWriter o,
                                Hashtable mapping, String parent){				//task_composite_begin :expansion  ta
    	if (mapping.containsKey("task_prefix")&&mapping.containsKey("task_begin")&&
    	mapping.containsKey("task_end")&&mapping.containsKey("task_composite_begin")&&
    	mapping.containsKey("task_composite_prefix")&&mapping.containsKey("documentation_prefix")){
    	    String taskName=LISPUtility.replaceSigns(t.getName());
    	    parent=LISPUtility.replaceSigns(parent);
    	 
    		o.println((String)mapping.get("task_begin")+" "+(String)mapping.get("task_prefix")+
    	    relpaceSpaceWithDash(taskName+"_"+parent ));
    	    if(t.composite) 
    	    {
    	    	o.print((String)mapping.get("task_composite_begin")+" ");
    	    	o.println((String)mapping.get("task_composite_prefix")+ relpaceSpaceWithDash(taskName));	//t.getName()));
    	    }
    	    
    	    String s;
    	    Class c=t.getClass();
    	    Field field;
    	    String type;
    	    for (int i=0;i<t.attributesToDisplay.length; i++){	//dialogsFields.length;i++){
    	    	s=(String)t.attributesToDisplay[i][0];
    	    	if (mapping.containsKey(s)){
    	          try{
    	    	    field=c.getField(s);
    	    	    type=field.getType().getName();
    	    	    if (type.equals("boolean"))
    	    	    {
    	    	    	boolean b=field.getBoolean(t);   	    	
    	    	    	if (b) o.println((String)mapping.get(s)+" "+b);
    	            }
    	            else if (type.equals("int")){
    	    	        int nb=field.getInt(t);    	    	
    	    	    	o.println((String)mapping.get(s)+" "+nb);
   	            	}
    	            else if (type.equals("java.lang.String")) 
    	            {
    	            	String str=(String)field.get(t);
    	            	str=LISPUtility.replaceSigns(str);
    	    	        if (!str.equals("")){	//
    	    	        	if (s.equals(_SEMANTICS)||
    	    	        		s.equals(_PRECONDM) ||
    	    	        		s.equals(_FEEDBACKDM)){
    	    	        		String conceptName =Manager.getXDM().getDmManager().
    	    	        			getAInstance(str).getConceptOf().getName();
						    	conceptName=LISPUtility.replaceSigns(conceptName);

						    	o.println((String)mapping.get(s)+" "+
    	    	        			(String)mapping.get(_PREFIX_AINSTANCE) + 
    	    	        			relpaceSpaceWithDash(conceptName)
    	    	        			+"-"+ relpaceSpaceWithDash(str) );
   	    	        		}
   	    	        		//shijian 2001-3-28
    	    	        /* else if (s.equals(_WARNING) ||
    	    	        			s.equals(_ACTOR) ||
    	    	        			s.equals(_OTHER)){
    	    	    	    	o.println((String)mapping.get(s)+" \""
    	    	    	    		+str + "\"");
   	    	        		}
   	    	        		
							else
    	    	    	    	o.println((String)mapping.get(s)+" "+relpaceSpaceWithDash(str) );
    	    	    	 */
    	    	        }
						
    	    	        

    	            }
    	          }catch (Exception e){}
    	        }
    	    }
    	   /* 
    	    String name =t.getName();
    	    if (Manager.RTFDB.containsKey(name)){
    	            DefaultStyledDocument doc=Manager.RTFDB.getDocument(name);

    	            if (doc.getLength()!=0) {
    	            	o.print((String)mapping.get("documentation_prefix") + " \"");
    	            	try{
    	            		String str=doc.getText(0, doc.getLength());
    	            		str = LISPUtility.replaceDoubleQuotes(str);
    	            		o.println(str);	//doc.getText(0, doc.getLength()));
    	                } catch (Exception ex){}
                        o.print("\"");
    	            }
    	    }
    	    
    	    */
    	    
    	    //export task comment in ASCII
    	    String note= "note";
    	    //writeRTFtoASCII(note, t, o, mapping,parent);
    	    //Manager.RTFDBM.exportASCII(t.getName(), o, mapping);	
    	    	
    	    //export task comment in HTML
    	    Manager.RTFDBM.exportRTF_HTML( t.getName(), o, mapping);
    	    	
    	    //export task comment in RTF
    	    //writeRTF(note, t, o, mapping,parent);
    	    //Manager.RTFDBM.exportRTF(t.getName(), o, mapping);	
  	    	
    	    o.println((String)mapping.get("task_end"));
    	    o.println();
    	    
    	    // set dirty to false after the language generation file is exported
    	    t.dirty= false;
    	    
    	    
    	} else error("Script error (Task)");
    }
    

    private static void writeBooleanConnectorWithParent(BooleanConnector b,PrintWriter o,
                                                    Hashtable mapping, String parent){
    	if (mapping.containsKey("boolean_connector_prefix")&&mapping.containsKey("boolean_connector_begin")&&
    	mapping.containsKey("boolean_connector_end")){
    		
     	    parent=LISPUtility.replaceSigns(parent);
   	    	o.println((String)mapping.get("boolean_connector_begin")+" "+
    	    (String)mapping.get("boolean_connector_prefix")+relpaceSpaceWithDash(b.getName()+"_"+parent) );
    	    String s;
    	    Class c=b.getClass();
    	    Field field;
    	    String type;
    	    for (int i=0;i<b.dialogsFields.length;i++){
    	    	s=(String)b.dialogsFields[i];
    	    	if (mapping.containsKey(s)){
    	          try{
    	    	    field=c.getField(s);
    	    	    type=field.getType().getName();
    	    	    if (type.equals("java.lang.String")){
    	    	        String str=(String)field.get(b);
    	    	        if (!str.equals("")){
      	    				str=LISPUtility.replaceSigns(str);
  	    	        	
    	    	    	    o.println((String)mapping.get(s)+" "+str);
    	    	        }
    	            }
    	            else if (type.equals("int")){
    	    	        int nb=field.getInt(b);    	    	
    	    	    	o.println((String)mapping.get(s)+" "+nb);
   	            }
    	            else if (type.equals("boolean")) {
    	    	        boolean bb=field.getBoolean(b);    	    	
    	    	    	o.println((String)mapping.get(s)+" "+bb);
    	            }
    	          }catch(Exception excep){error("Error in boolean connector!!!  "+excep);}
    	        }
    	    }
    	    o.println((String)mapping.get("boolean_connector_end"));
    	    o.println();
    	} else error("Script error (BooleanConnector)");
    }
    
    private static void writeLinkWithParent(Link l,PrintWriter o,
                                    Hashtable mapping, String parent){
    	if (mapping.containsKey("link_prefix")&&mapping.containsKey("link_begin")&&
    	mapping.containsKey("link_end")&&mapping.containsKey("origin")&&mapping.containsKey("destination")){
     	    String taskName;   	    
     	    parent=LISPUtility.replaceSigns(parent);
   			o.println((String)mapping.get("link_begin")+" "+
    	              (String)mapping.get("link_prefix")+l.getName());
    	    if (l.lc1 instanceof Task){
    	    	taskName=LISPUtility.replaceSigns(l.lc1.getName());
     	    	o.println((String)mapping.get("origin")+" "+"action-"+
     	              relpaceSpaceWithDash(taskName+"_"+parent )); //name1));
    	    }
     	    else 
      	    	o.println((String)mapping.get("origin")+" "+"bc-"+
     	              relpaceSpaceWithDash(l.lc1.getName()+"_"+parent )); //name1));
     	    if (l.lc2 instanceof Task){
    	    	taskName=LISPUtility.replaceSigns(l.lc2.getName());
  	    		o.println((String)mapping.get("destination")+" "+"action-"+ 
    	              relpaceSpaceWithDash(l.lc2.getName()+"_"+parent )); 
    	    } else 
  	    		o.println((String)mapping.get("destination")+" "+"bc-"+ 
    	              relpaceSpaceWithDash(l.lc2.getName()+"_"+parent )); 

    	    String s;
    	    Class c=l.getClass();
    	    Field field;
    	    String type;
    	    for (int i=0;i<l.attributesToDisplay.length;i++){
    	    	s=(String)l.attributesToDisplay[i][0];
    	    	if (mapping.containsKey(s)){
    	          try{
    	    	    field=c.getField(s);
    	    	    type=field.getType().getName();
    	    	    if (type.equals("java.lang.String")){
    	    	        String str=(String)field.get(l);
    	    	        if (!str.equals("")){
    	    	        	str=LISPUtility.replaceSigns(str);

       	    	        	if (s.equals(_PRECONDM)){
    	    	        		String conceptName =Manager.getXDM().getDmManager().
    	    	        			getAInstance(str).getConceptOf().getName();
						    	conceptName=LISPUtility.replaceSigns(conceptName);

						    	o.println((String)mapping.get(s)+" "+
    	    	        			(String)mapping.get(_PREFIX_AINSTANCE) + conceptName
    	    	        			+"-"+ relpaceSpaceWithDash(str) );
   	    	        		} else
	    	    	    	    o.println((String)mapping.get(s)+" "+relpaceSpaceWithDash(str));
    	    	        }
    	            }
    	            else if (type.equals("int")){
    	    	        int nb=field.getInt(l);    	    	
    	    	    	o.println((String)mapping.get(s)+" "+nb);
   	            }
    	            else if (type.equals("boolean")) {
    	    	        boolean b=field.getBoolean(l);    	    	
    	    	    	o.println((String)mapping.get(s)+" "+b);
    	            }
    	          }catch (Exception excep){error("Error in Link!!!  "+excep);}
    	        }
    	    }
    	    o.println((String)mapping.get("link_end"));
    	    o.println();
    	} else error("Script error (Link)");
    }
    

    private static void writeExpansionsWithParent(PrintWriter out,Hashtable mapping){
    	if (mapping.containsKey("root"))
            writeNodeWithParent(out,Manager.skeleton.root,(String)mapping.get("root"),new TreeSet(),mapping);
    }
    private static void writeNodeWithParent(PrintWriter out,Node node,
                                String name,Set expansionSet,
                                Hashtable mapping){
    	//System.out.print("Writing expansion "+name+" ...");
      if (mapping.containsKey("expansion_begin")&&mapping.containsKey("expansion_prefix")&&
          mapping.containsKey("start_expansion")&&  //mapping.containsKey("expansion_separator")&&
          mapping.containsKey("finish_expansion")&&mapping.containsKey("expansion_end")){
    	
     	  //String taskName;   	    
     	  name=LISPUtility.replaceSigns(name);

     	  if (name.equals((String)mapping.get("root"))) 
     	  	out.println((String)mapping.get("expansion_begin")+
    	     " " + relpaceSpaceWithDash(name));
    	  else out.println((String)mapping.get("expansion_begin")+" "+
    	    (String)mapping.get("expansion_prefix")+ relpaceSpaceWithDash(name));
    	Set keys=node.keySet();
    	Couple c;
    	LinkableComponent lc;
    	String childName;
    	LinkedList list=new LinkedList();
    	int nb=0;
   	
   	//1. print the node
    	if (keys.size()>0) out.print((String)mapping.get("start_expansion"));
    	boolean first;
    	boolean already=false;
    	for (Iterator it=keys.iterator();it.hasNext();){
            childName=(String)it.next();
    	    c=node.getCouple(childName);
            childName=LISPUtility.replaceSigns(childName);
   	    	if (c.object instanceof LinkableComponent){
    	    	lc=(LinkableComponent)c.object;
    	    	first=firstComponent(lc);
    	    	if (lc instanceof Task) {
    	    	    if (first) {
    	    	    	if (already) out.print(" "); // using space as expansion_separator --- 
    	    	    	out.print((String)mapping.get("task_prefix")+relpaceSpaceWithDash(childName + "_" +name));
    	    	        already=true;
    	    	    }
    	    	}
    	    	else if (lc instanceof BooleanConnector) {
    	    	    if (first) {
    	    	    	if (already) out.print(" "); // using space as expansion_separator ---((String)mapping.get("expansion_separator"));
    	    	    	out.print((String)mapping.get("boolean_connector_prefix")+ 
    	    	    	            relpaceSpaceWithDash(childName+ "_" +name));
    	    	        already=true;
    	    	    }
    	    	}
    	    	if (!it.hasNext()) out.println((String)mapping.get("finish_expansion"));
                //only for a CompositeComponent
    	    	if (!c.node.isEmpty()){
    	    	    list.add(c.node);
    	    	    list.add(childName);
    	    	    nb++;
    	    	}
    	    }
    	}
    	out.println((String)mapping.get("expansion_end"));
    	out.println();
    	
    	//System.out.println("OK");

    	//System.out.println(name+" contains "+nb+" branch(es)");
    	
    	//2. print the branches
    	Node n;
    	for (int i=0;i<nb;i++){
    	    n=(Node)list.removeFirst();
    	    childName=(String)list.removeFirst();
    	    if (!expansionSet.contains(childName)){
    	    	expansionSet.add(childName);
    	    	writeNodeWithParent(out,n,childName,expansionSet,mapping);
    	    }
    	}
      }
    }
    
    
    //2001-1-11 
    // this method should be called exportLISP
    //--------------------------------------------------------------
    public static void export(File f){
    			   
       //shijian 2001-2-20
       // create DM, if semntics is nil (for those tasks)
       DmManager.createDMIfNil();
       
      Hashtable mapping;
    	BufferedReader in;
    	
    	PrintWriter out;
    	mapping=new Hashtable();
    	try{
    	    in=new BufferedReader(new FileReader(MAPPING_FILE_LG_NEW));
    	    String s,s1,s2;
    	    StringTokenizer st;
    	    while ((s=in.readLine())!=null){
    	    	if (!s.trim().equals("")) if (!s.substring(0,1).equals("#")){
    	    	    st=new StringTokenizer(s);
    	    	    if (st.countTokens()>=2){
    	    	    	s1=st.nextToken();
    	    	    	s2=st.nextToken();
    	                mapping.put(s1,s2);
    	            }
    	        }
    	    }
		    in.close();
		    
		    out=new PrintWriter(new FileOutputStream(f));
		    
	       exportStyleParameters(out,mapping);
	       
	       out.println("(in-package :dm)");
	       out.println();
	
		    out.println(";;----------------------------------------------------");
		    out.println(";;                Task model part                     ");
		    out.println(";;----------------------------------------------------");        
		    out.println();
	       writeComponentsWithParent(out,mapping);
		    writeExpansionsWithParent(out,mapping);
		    
	       out.println(";;----------------------------------------------------");
	       out.println(";;               Domain model part                    ");
	       out.println(";;----------------------------------------------------");
	       out.println();
	       	
	       exportDomainNew(out,mapping);
	                
		    out.close();
		} catch (Exception e){error("Exportation failed !!! "+e);}
    }
    
    private static void exportDomainNew(PrintWriter out,Hashtable mapping){
    	
	    	exportEConcept( out, mapping);
	    	exportAConcept( out, mapping);
	    	exportEInstance( out, mapping);	
	    	exportAInstance( out, mapping);
    	
    }
    
    private static void exportEInstance(PrintWriter out,Hashtable mapping){
    	
    	try {
			Iterator i = _dMm.getEInstanceAll().iterator();
			EntityInstance e;
	
			while (i.hasNext()) {
	    	    String s,ss,sss;
    	    	e=(EntityInstance)i.next();
             if ( !e.getName().equals(""))
             {
 	            out.println((String)mapping.get(_DOMAIN_INSTANCE_BEGIN )+" "+
 	            	(String)mapping.get(_PREFIX_EINSTANCE) +
 	            	relpaceSpaceWithDash(e.getID()));
 	                
               DmConcept con =e.getConceptOf();
 	            if (!con.equals(null)) 
 	            	out.println((String)mapping.get(_CONCEPT_OF)+" "+
	 	            	relpaceSpaceWithDash(e.getConceptOf().getName())+		//getName()));
	 	            	(String)mapping.get(_ENTITY_CONCEPT_SUFFIX)+"-"+
	 	            	relpaceSpaceWithDash(con.getType()));
               	s=e.getCardinality();
 	            if (s != null && !s.trim().equals("")) 
 	            	out.println((String)mapping.get(_CARDINALITY )+" "+relpaceSpaceWithDash(s));
               	s=e.getPreModifier();
 	            if (s != null ){
 	            	s = s.trim();
 	            	if ( !s.trim().equals("")) {
	 	            	// replace special XML characters
				    	s=LISPUtility.replaceSigns(s);
	 	            	out.println((String)mapping.
	 	            		get(_PREMODIFIER)+" "+" \""+s+ "\"");
 	            	}
 	            }
               	s=e.getPostModifier();
 	            if (s != null ){
 	            	s = s.trim();
 	            	if( !s.trim().equals("")) {
	 	            	// replace special XML characters
				    	s=LISPUtility.replaceSigns(s);
	 	            	out.println((String)mapping.
	 	            		get(_POSTMODIFIER)+" "+" \""+s+ "\"");
 	            	}
 	            }
 	            
 	 //18-10-2001
				s=e.getLabel();
 	            if (s != null ){
	            		s = s.trim();
	 	            	if (!s.trim().equals("")) {
	 	            	// replace special XML characters
				    	s=LISPUtility.replaceSigns(s);
	 	            	out.println((String)mapping.
	 	            		get(_LABEL)+" "+" \""+s+ "\"");
	 	            	}
 	            }
               	s=e.getDeterminator();
 	            if (s != null ){
 	            	s = s.trim();
 	            	if( !s.trim().equals("")) {
	 	            	// replace special XML characters
				    	s=LISPUtility.replaceSigns(s);
	 	            	out.println((String)mapping.
	 	            		get(_DETERMINATOR)+" "+" \""+s+ "\"");
 	            	}
 	            }
 	 //18-10-2001
 	   /*
 	            if (e instanceof InterfaceInstance){
 	            	InterfaceInstance ii=(InterfaceInstance)e;
					s=ii.getLabel();
	 	            if (s != null ){
 	            		s = s.trim();
		 	            	if (!s.trim().equals("")) {
		 	            	// replace special XML characters
					    	s=LISPUtility.replaceSigns(s);
		 	            	out.println((String)mapping.
		 	            		get(_LABEL)+" "+" \""+s+ "\"");
		 	            	}
	 	            }
 	            	
 	            }
 	       */
 	        //    if (e.getDirty()) 
  	        //    	out.println((String)mapping.get(_DIRTY)+" "+e.getDirty());
 	            	
 	            	
 	            //output Entity relation _BEGIN_ITEM 
					out.println((String)mapping.get(_DOMAIN_RELATIONS )+" "+
								(String)mapping.get(_BEGIN_REL ));			
 	           	String allEntRle[] = _dMRelat.getAllEntityRelations();
					TreeMap eInstances = e.getEntityRelations();    
					for (int j = 0; j < allEntRle.length; j++) {
						if (eInstances.get(allEntRle[j]) != null){
							out.println("     "+(String)mapping.get(_BEGIN_ITEM)+
								(String)mapping.get(_DOMAIN_RELATION_PREFIX)+
								relpaceSpaceWithDash(allEntRle[j]) + " " +
								(String)mapping.get(_PREFIX_EINSTANCE) +
								relpaceSpaceWithDash(((DmInstance) eInstances.get(allEntRle[j])).getID())+
								(String)mapping.get(_END_ITEM));
							
		    			//	System.out.println("     "+allEntRle[j]+" Instance: " 
		    			//		+((DmInstance) eInstances.get(allEntRle[j])).getName());				
						}
		       	}
					out.println("     "+(String)mapping.get(_END_REL  ));			
    	            
	                    	            
 	            s=e.getNote();
 	            if (s != null && !s.trim().equals("")) {
 	            	// replace special XML characters
			    	s=LISPUtility.replaceDoubleQuotes(s);
 	            	out.println((String)mapping.get(_DOCUMENTATION_PREFIX )+" \""+s+ "\"");
 	            }
             
 	            out.println((String)mapping.get(_DOMAIN_END ));
 	            out.println();
 	        	//System.out.println("Ok");
           }
    	   }
    	 } catch (Exception excep){error("Error in Entity Instance!!!  "+excep);}

    }
    
    private static void exportAInstance(PrintWriter out,Hashtable mapping){
    	
    	try {
			Iterator i = _dMm.getAInstanceAll().iterator();
			ActionInstance a;
	
			while (i.hasNext()) {
	    	    String s,ss,sss;
    	    	a=(ActionInstance)i.next();
             if ( !a.getName().equals(""))
             {
 	            DmConcept con =a.getConceptOf();
 	            // replace special XML characters
			    String conName=LISPUtility.replaceSigns(con.getName());


             	out.println((String)mapping.get(_DOMAIN_INSTANCE_BEGIN )+" "+
 	            	(String)mapping.get(_PREFIX_AINSTANCE) + 
 	            	relpaceSpaceWithDash(conName) + "-"+
 	            	relpaceSpaceWithDash(a.getID()));	//getName()));
 	                
               //DmConcept con =a.getConceptOf();
 	            if (!con.equals(null)) 
 	            	out.println((String)mapping.get(_CONCEPT_OF)+" "+
	 	            	relpaceSpaceWithDash(a.getConceptOf().getName()) +	
	 	            	(String)mapping.get(_ACTION_CONCEPT_SUFFIX)+"-"+
	 	            	relpaceSpaceWithDash(con.getType()));
              	s=a.getPreModifier();
 	            if (s != null && !s.trim().equals("")) {
 	            	// replace special XML characters
			    	s=LISPUtility.replaceSigns(s);
 	            	out.println((String)mapping.get(_PREMODIFIER)+" "+" \""+s+ "\"");
 	            }
               	s=a.getPostModifier();
 	            if (s != null && !s.trim().equals("")) {
 	            	// replace special XML characters
			    	s=LISPUtility.replaceSigns(s);
 	            	out.println((String)mapping.get(_POSTMODIFIER)+" "+" \""+s+ "\"");
 	            }
 	        //    if (a.getDirty()) 
 	        //    	out.println((String)mapping.get(_DIRTY)+" "+a.getDirty());
 	            	
 	            	
 	            //output  relation _BEGIN_ITEM 
				out.println((String)mapping.get(_DOMAIN_RELATIONS )+" "+
								(String)mapping.get(_BEGIN_REL ));			
  	            //output action-entity relation  
	           	String allActRle[] = _dMRelat.getAllActionRelations();
					TreeMap reActInstances = a.getActionRelations(); 
					
					//17-1-2002
					TreeMap contextTypes = a.getEContextTypes();  
					String type;
					for (int j = 0; j < allActRle.length; j++) {
						if (reActInstances.get(allActRle[j]) != null){
							out.println("     "+(String)mapping.get(_BEGIN_ITEM)+
								(String)mapping.get(_DOMAIN_RELATION_PREFIX)+
								 relpaceSpaceWithDash(allActRle[j]) + " " +
								 (String)mapping.get(_PREFIX_EINSTANCE) + 
								relpaceSpaceWithDash(((DmInstance) reActInstances.get(allActRle[j])).getID())+
								(String)mapping.get(_END_ITEM));
							//17-1-2002
							//write contextual type if it is not normal
							type = (String) contextTypes.get(allActRle[j]);
							if (!(type.equals(ContextualType.getNormal()))){
								out.println("     "+(String)mapping.get(_BEGIN_ITEM)+
									(String)mapping.get(_DOMAIN_RELATION_PREFIX)+
									 relpaceSpaceWithDash(allActRle[j]) + 
									 (String)mapping.get(_CONTEXTUAL_TYPE)+ " "+ 
									 (String)mapping.get(type) +
									 (String)mapping.get(_END_ITEM));
							}
		    				//System.out.println("     "+allActRle[j]+" Instance: " 
		    				//	+((DmInstance) reActInstances.get(allActRle[j])).getName());				
						}
		       	}
		       	
	 	        //output action-action relation  
 	           	String allActActRle[] = _dMRelat.getAllActionActRelations();
					TreeMap reActActInstances = a.getActionActRelations();    
					for (int j = 0; j < allActActRle.length; j++) {
						if (reActActInstances.get(allActActRle[j]) != null){
							out.println("     "+(String)mapping.get(_BEGIN_ITEM)+
								(String)mapping.get(_DOMAIN_RELATION_PREFIX)+
								 relpaceSpaceWithDash(allActActRle[j]) + " " +
								 (String)mapping.get(_PREFIX_AINSTANCE) + 
								relpaceSpaceWithDash(((DmInstance) reActActInstances.
								get(allActActRle[j])).getConceptOf().getName())+ "-"+
								relpaceSpaceWithDash(((DmInstance) reActActInstances.
									get(allActActRle[j])).getID())+
									(String)mapping.get(_END_ITEM));
							
		    				//System.out.println("     "+allActRle[j]+" Instance: " 
		    				//	+((DmInstance) reActInstances.get(allActRle[j])).getName());				
						}
		       	}
					out.println("     "+(String)mapping.get(_END_REL  ));		
					
 	            s=a.getNote();
 	            if (s != null && !s.trim().equals("")) {
 	            	// replace special XML characters
			    	s=LISPUtility.replaceDoubleQuotes(s);
 	            	out.println((String)mapping.get(_DOCUMENTATION_PREFIX )+" \""+s+ "\"");
 	            }
 	            
 	            out.println((String)mapping.get(_DOMAIN_END ));
 	            out.println();
 	        	//System.out.println("Ok");
           }
    	   }
    	 } catch (Exception excep){error("Error in Action Instance!!!  "+excep);}

    }
    
    //export all concepts of types Entity, User, and System
    private static void exportEConcept(PrintWriter out,Hashtable mapping){
    	
    	try {
    		Collection conE = _dMm.getObjectCons();
    			//getConceptSome(ConceptType.getDefaultEntityType());
    		Collection conU = _dMm.getConceptSome(ConceptType.getDefaultUserType());
    		Collection conS = _dMm.getConceptSome(ConceptType.getDefaultSystemType());
    		Collection conI = _dMm.getInterfaceCons();

    		//getConceptSome(ConceptType.getInterfaceType());
     	//	System.out.println("number of entity concepts: " + conE.size());
    	//	System.out.println("number of system concepts: " + conS.size());
    	//	System.out.println("number of user concepts: " + conU.size());
   		
    		HashSet ts = new HashSet(conE);
    		ts.addAll(conU);	//
     		ts.addAll(conS);	//
	   		ts.addAll(conI);	//
     	//	System.out.println("number of all entity concepts: " + ts.size());

	   		Iterator i = ts.iterator();
			DmConcept c;
	
			while (i.hasNext()) {
	    	    String s;
    	    	 c=(DmConcept)i.next();
             if ( !c.getName().equals(""))
             {
	 	            out.println((String)mapping.get(_DOMAIN_CONCEPT_BEGIN  )+" "+
	 	            	relpaceSpaceWithDash(c.getName())+		//getName()));
	 	            	(String)mapping.get(_ENTITY_CONCEPT_SUFFIX)+"-"+
	 	            	relpaceSpaceWithDash(c.getType()));
	 	                
	               s=c.getType();
	 	            if (s != null && !s.trim().equals("")){ 
	 	            	if (s.equals(ConceptType.getDefaultSystemType()))
	 	            		out.println((String)mapping.get(_CONCEPT_TYPE )+" "+
	 	            			(String)mapping.get(_SYSTEM_TYPE ) );
	 	            	else if (s.equals(ConceptType.getDefaultUserType()))
	 	            		out.println((String)mapping.get(_CONCEPT_TYPE )+" "+
	 	            			(String)mapping.get(_USER_TYPE ));
	 	            /*(	else if (s.equals(ConceptType.getInterfaceType()))
	 	            		out.println((String)mapping.get(_CONCEPT_TYPE )+" "+
	 	            			(String)mapping.get(_INTERFACE_TYPE ));
	 	            */	else
	 	            		out.println((String)mapping.get(_CONCEPT_TYPE )+" "+
	 	            			(String)mapping.get(relpaceSpaceWithDash(c.getType())));
	 	            				//_ENTITY_TYPE ));
	 	            }
	 	            
	 	            s=c.getCard(DmConcept._ENGLISH).getSpelling();
	 	            if (s != null && !s.trim().equals("")) {
	 	            	// replace special XML characters
				    	s=LISPUtility.replaceSigns(s);
	 	            	out.println((String)mapping.get(_SPELLING )+" "+" \""+s+"\"");
	 	            }
	 	            EnglishNoun eNoun = (EnglishNoun)c.getCard(DmConcept._ENGLISH);
	 	            if ( eNoun.isMassNoun()) {
	 	            	s= "yes";
	 	            	out.println((String)mapping.get(_MASSNOUN)+" "+
	 	            			" \""+relpaceSpaceWithDash(s)+"\"");
	 	            
	 	            }
	 	            if (c.getCard(DmConcept._ENGLISH) instanceof IrregularNoun) {
	 	            	s=((IrregularNoun)(c.getCard(DmConcept._ENGLISH))).getPlural();
	 	            	if (s != null && !s.trim().equals("")) {
		 	            	// replace special XML characters
					    	s=LISPUtility.replaceSigns(s);
	 	            		out.println((String)mapping.get(_PLURAL  )+" "+" \""+relpaceSpaceWithDash(s)+" \"");
	 	            	}
	 	            }
	 	       //     if (c.getDirty()) 
	 	        //    	out.println((String)mapping.get(_DIRTY)+" "+c.getDirty());
	 	            			                    	            
	 	            s=c.getNote();
	 	            if (s != null && !s.trim().equals("")) {
	 	            	// replace special XML characters
				    	s=LISPUtility.replaceDoubleQuotes(s);
	 	            	out.println((String)mapping.get(_DOCUMENTATION_PREFIX )+" \""+s+ "\"");
	 	            }
	             
	 	            out.println((String)mapping.get(_DOMAIN_END ));
	 	            out.println();
 	        	//System.out.println("Ok");
           }
    	   }
    	 } catch (Exception excep){error("Error in Entity Concept!!!  "+excep);}

    }
    
    //export all concepts of types Action
    private static void exportAConcept(PrintWriter out,Hashtable mapping){
    	
    	try {
    		Collection conA = _dMm.getActionCons();
    			//getConceptSome(ConceptType.getDefaultActionType());
    		//System.out.println("number of action concepts: " + conA.size());
			Collection allCon = _dMm.getConceptAll();
    		//System.out.println("number of all concepts: " + allCon.size());
			
			Iterator i = conA.iterator();
			DmConcept c;
	
			while (i.hasNext()) {
	    	    String s;
    	    	 c=(DmConcept)i.next();
             if ( !c.getName().equals(""))
             {
    				//System.out.println("Act concepts: " + c.getName());
    				
	 	            out.println((String)mapping.get(_DOMAIN_CONCEPT_BEGIN  )+" "+
	 	            	//(String)mapping.get(_PREFIX_CONCEPT)+
	 	            	//relpaceSpaceWithDash(c.getID()));		//
	 	            	relpaceSpaceWithDash(c.getName()) +	
	 	            	(String)mapping.get(_ACTION_CONCEPT_SUFFIX)+"-"+
	 	            	relpaceSpaceWithDash(c.getType()));
	 	                
	 	           	out.println((String)mapping.get(_CONCEPT_TYPE )+" "+
	 	           		(String)mapping.get(relpaceSpaceWithDash(c.getType())));
	 	           			//_ACTION_TYPE ) );
	 	            
	 	            s=c.getCard(DmConcept._ENGLISH).getSpelling();
	 	            if (s != null && !s.trim().equals("")){ 
	 	            	// replace special XML characters
		    			s=LISPUtility.replaceSigns(s);		    
	 	            	out.println((String)mapping.get(_SPELLING )+" "+" \""+s+"\"");
	 	            }
 	            	s=((EnglishVerb)c.getCard(DmConcept._ENGLISH)).getProp();
 	            	if (s != null && !s.trim().equals("")) { 
	 	            	// replace special XML characters
		    			s=LISPUtility.replaceSigns(s);	
 	            		out.println((String)mapping.get(_PROP)+" \""+relpaceSpaceWithDash(s)+"\"");
 	            	}
 	            	if (c.getCard(DmConcept._ENGLISH) instanceof IrregularVerb) {
	 	            	IrregularVerb ir = (IrregularVerb)(c.getCard(DmConcept._ENGLISH));
	 	            	
	 	            	s=ir.get1stP();
	 	            	if (s != null && !s.trim().equals("")) { 
		 	            	// replace special XML characters
			    			s=LISPUtility.replaceSigns(s);
	 	            		out.println((String)mapping.get(_1ST_PERSON)+" \""+relpaceSpaceWithDash(s)+"\"");
	 	            	}
	 	            	s=ir.get3rdP();
	 	            	if (s != null && !s.trim().equals("")) { 
		 	            	// replace special XML characters
			    			s=LISPUtility.replaceSigns(s);
	 	            		out.println((String)mapping.get(_3RD_PERSON)+" \""+relpaceSpaceWithDash(s)+"\"");
	 	            	}
	 	            	s=ir.getPlural();
	 	            	if (s != null && !s.trim().equals("")) { 
		 	            	// replace special XML characters
			    			s=LISPUtility.replaceSigns(s);
	 	            		out.println((String)mapping.get(_PLURAL)+" \""+relpaceSpaceWithDash(s)+"\"");
	 	            	}
	 	            	s=ir.getPast();
	 	            	if (s != null && !s.trim().equals("")) { 
		 	            	// replace special XML characters
			    			s=LISPUtility.replaceSigns(s);

	 	            		out.println((String)mapping.get(_PAST)+" \""+relpaceSpaceWithDash(s)+"\"");
	 	            	}
	 	            	s=ir.getPp();
	 	            	if (s != null && !s.trim().equals("")) { 
		 	            	// replace special XML characters
			    			s=LISPUtility.replaceSigns(s);
	 	            		out.println((String)mapping.get(_PP)+" \""+relpaceSpaceWithDash(s)+"\"");
	 	            	}
	 	            }
	 	            
	 	         //   if (c.getDirty()) 
	 	         //   	out.println((String)mapping.get(_DIRTY)+" "+c.getDirty());
	 	            			                    	            
	 	            s=c.getNote();
	 	            if (s != null && !s.trim().equals("")) { 
	 	            	// replace special XML characters
		    			s=LISPUtility.replaceDoubleQuotes(s);
	 	            	out.println((String)mapping.get(_DOCUMENTATION_PREFIX )+" \""+s+ "\"");
	 	            }
	             
	 	            out.println((String)mapping.get(_DOMAIN_END ));
	 	            out.println();
 	        	//System.out.println("Ok");
           }
    	   }
    	 } catch (Exception excep){error("Error in Action Concept!!!  "+excep);}

    }
    
    
    //export document style parameters
    private static void exportStyleParameters(PrintWriter out,Hashtable mapping){
    	
    	try {
	 		out.println((String)mapping.get(_stylePackagePreffix )+" "+
	 	           		(String)mapping.get(_stylePackagesuffix ) );
	       	out.println();
	       	
	 		// output modality-can
		 	out.print((String)mapping.get(_styleParameter )+" "+
	 			 		(String)mapping.get(_modalityCan )+" " );
	 		if (_dMm.isModalityCan())
	 			out.println((String)mapping.get(_styleTrue )+")" );
	 		else 
	 			out.println((String)mapping.get(_styleFalse )+")" );
	       	
	       	//output style parameter conjunction
		 	out.print((String)mapping.get(_styleParameter )+" "+
	 			 		(String)mapping.get(_conjunction )+" " );
	 		if (_dMm.isConjunction())
	 			out.println((String)mapping.get(_styleTrue )+")" );
	 		else 
	 			out.println((String)mapping.get(_styleFalse )+")" );
	 			
       		//output how
	 		out.print((String)mapping.get(_styleParameter )+" " +
	 			 		(String)mapping.get(_styleHow )+" " );
	 		if (_dMm.isStyleHow())
	 			out.println((String)mapping.get(_styleTrue )+")" );

	 		else 
	 			out.println((String)mapping.get(_styleFalse )+")" );
	 		// output purpose-first
		 	out.print((String)mapping.get(_styleParameter )+" "+
	 			 		(String)mapping.get(_purposeFirst )+" " );
	 		if (_dMm.isPurposeFirst())
	 			out.println((String)mapping.get(_styleTrue )+")" );
	 		else 
	 			out.println((String)mapping.get(_styleFalse )+")" );
	 		
	 		//output step-by-step
	 		out.print((String)mapping.get(_styleParameter )+" "+
	 			 		(String)mapping.get(_stepByStep )+" " );
	 		if (_dMm.isStepByStep())
	 			out.println((String)mapping.get(_styleTrue )+")" );
	 		else 
	 			out.println((String)mapping.get(_styleFalse )+")" );
	 			
		   	out.println();
 			
    		
    	} catch (Exception excep){error("Error in style paramters!!!  "+excep);}

    }
    
    //20-9-2001
    //write RTF task-comment in HTML 
    private static void writeRTFtoHTML(String note,Task t,PrintWriter out,
                                Hashtable mapping, String parent){
    	final String BEGIN_BODY="<body>";
    	final String END_BODY="</body>";
    	
    	final String BEGIN_COMPONENT=" <HR size=\"1\">    <TABLE BORDER=\"0.5\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\"><TR BGCOLOR=\"#F2E8D3\" ID=\"TableHeadingColor\"><TD COLSPAN=2><FONT SIZE=\"+1\"><CENTER><B>";
    	final String END_COMPONENT="    </B></CENTER></FONT></TD></TR></TABLE>";
    	
    	final int lbb=BEGIN_BODY.length();
    	final int leb=END_BODY.length();

    	CharArrayWriter tempOut;
    	BufferedReader tempIn;
		String name=t.getName();
		String s;
		DefaultStyledDocument doc;
		MinimalHTMLWriter2 w;
		
		doc = Manager.RTFDB.getDocument(name);
		if (doc.getLength()>0) {
			try {
				
				out.print((String)mapping.get("documentation_prefix") + " \"");

				tempOut = new CharArrayWriter();
				w = new MinimalHTMLWriter2(tempOut,doc,0,doc.getLength());
				w.write();
			    
				tempOut.close();
				tempIn = new BufferedReader(new CharArrayReader(tempOut.toCharArray()));
/*				boolean body = false;
				boolean stop=false;
				boolean first=false;
				int l;
	*/			while ((s=tempIn.readLine())!=null) {
		    		    //System.out.println("comment text = "+s);           //Thomas
		 /*   		l=s.length()-lbb;
		    		for (int j=0;j<=l;j++) {
		        		if (s.substring(j,j+lbb).equals(BEGIN_BODY)) {
		    	    		s=tempIn.readLine();
		    	    		body=true;
		    	    		first=true;
		    	    		break;
		        		}
		    		}
		    		l=s.length()-leb;
		    		for (int j=0;j<=l;j++) {
		        		if (s.substring(j,j+leb).equals(END_BODY)) {
		    	    		stop=true;
		    	    		break;
			        	}
			    	}
			    	if (stop) break;
			    	if (first) {
			    		// <HR color="#0000ff" noshade size="5">
		    	        // out.println("<HR>");
			    	    out.println(BEGIN_COMPONENT);
			        	out.println("      "+name);
				        out.println(END_COMPONENT);
		        
				        if (gc instanceof Task) {
			    	    	Task t=(Task)gc;
		
		                    selectTaskAttributes(t,out);
				            if (Manager.skeleton.hasChildNode(name)) {
			    		        out.println(" <P>   <IMG SRC=\""+name+"."+type+"\"> </P>");
		    	        
			    		        //Thomas
			    	    	    addDetailsForSubtasks(name,out);
			    	        }
			        	}
			
		                if (body) {
		    	            String comment = "   <FONT SIZE=\"-1\" align=\"left\"><I><B> comment: </B></I></FONT>";  
			                out.print(comment);
				        }
			    	    first=false;
			    	}
		    	    if (body) {
		       	*/		out.println(s);
		         //   }
		        }
		        tempIn.close();
		        
		        out.print("\"");

			}
    		catch (Exception e) {
    			System.out.println("Error when exporting RTF: "+(e.toString()));
    		}
		}
	}
	
	
    //20-9-2001
    //write RTF task-comment in ASCII 
    private static void writeRTFtoASCII(String note,Task t,PrintWriter o,
                                Hashtable mapping, String parent){
    	String name =t.getName();
	    if (Manager.RTFDB.containsKey(name)){
	            DefaultStyledDocument doc=Manager.RTFDB.getDocument(name);

	            if (doc.getLength()!=0) {
	            	o.print((String)mapping.get("documentation_prefix") + " \"");
	            	try{
	            		String str=doc.getText(0, doc.getLength());
	            		str = LISPUtility.replaceDoubleQuotes(str);
	            		o.println(str);	//doc.getText(0, doc.getLength()));
	                } catch (Exception ex){}
                    o.print("\"");
	            }
	    }

    }
	
    //20-9-2001
    //write task-comment in RTF 
    private static void writeRTF(String note,Task t,PrintWriter out,
                                Hashtable mapping, String parent){
    	String name =t.getName();
	    if (Manager.RTFDB.containsKey(name)){
	    	DefaultStyledDocument doc=Manager.RTFDB.getDocument(name);
			out.print((String)mapping.get("documentation_prefix") + " \"");
            if (doc.getLength()!=0) {
                RTFEditorKit kit = (RTFEditorKit)Manager.editor.textPane.getEditorKit();
                
                try {
                    kit.write(out,doc,0,doc.getLength());
                }
                catch (Exception ex) {
    				System.out.println("Error when exporting RTF: "+(ex.toString()));
                }
            }
            out.print("\"");

	    }
    }
	
}









