/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   Redistribution in source and binary forms, with or without modification, are not permitted.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import java.util.*;
import java.beans.*;

/**
 * This class contains a {@link GraphicPanel}.
 * The selection of a frame causes some actions on other components such as the navigation tree.
 * <P><A HREF="../source/ComponentInternalFrame.html#ComponentInternalFrame_beginning">Source</A>
 */
///ComponentInternalFrame_beginning
public class ComponentInternalFrame extends JInternalFrame implements InternalFrameListener{
    protected static final int WIDTH=300;
    protected static final int HEIGHT=300;
    protected static final int INSETS_WIDTH=13;
    protected static final int INSETS_HEIGHT=50;
    protected static final int GRAPHICPANEL_WIDTH=WIDTH-INSETS_HEIGHT;
    protected static final int GRAPHICPANEL_HEIGHT=HEIGHT-INSETS_HEIGHT;
    
    protected static final int NB_FRAMES=7;
    
    private static int openFrameCount = 0;
    private static int openFrameCountModulo=0;
    private static final int xOffset = 30, yOffset = 30;
    
    protected GraphicPanel gpanel;
    protected String name;
    
    /**
     * Create a new frame with a new {@link GraphicPanel} inside.
     * <P><A HREF="../source/ComponentInternalFrame.html#ComponentInternalFrame">Source</A>
     */
    ///ComponentInternalFrame
    public ComponentInternalFrame(String name,GenericComponent [] elements) {
        super(name, 
              true, //resizable
              true, //closable
              true, //maximizable
              true);//iconifiable
        
    	//System.out.println("ComponentInternalFrame : "+name);

    	openFrameCount++;
        openFrameCountModulo=(openFrameCount-1)%NB_FRAMES;
        this.name = name;
        //...Create the GUI and put it in the window...

        //...Then set the window size or call pack...
        setSize(WIDTH,HEIGHT);
        setPreferredSize(new Dimension(WIDTH,HEIGHT));
        //Insets i=getInsets();

        //Set the window's location.
        int locationX = xOffset*openFrameCountModulo;
        int locationY = yOffset*openFrameCountModulo;
        setLocation(locationX,locationY);
        
        //create a graphic panel
        updateGraphicPanel(elements);
        
        getContentPane().add(new JScrollPane(gpanel), BorderLayout.CENTER);
        
        addInternalFrameListener(this);
    }

    /*public void setLocation(Point p){
    	super.setLocation(p);
    	Manager.desktop.updateSize();
    }

    public void setLocation(int w,int h){
    	super.setLocation(w,h);
    	Manager.desktop.updateSize();
    }*/

    /**
     * Update the frame with elements[].
     * Create a new panel if it doesn't exist.
     * If elements is null, empty the frame. 
     * <P><A HREF="../source/ComponentInternalFrame.html#updateGraphicPanel">Source</A>
     */
    ///updateGraphicPanel
    public void updateGraphicPanel(GenericComponent [] elements) {
    	boolean mustBeRepainted = (gpanel!=null);    	
    	
        if (gpanel==null) gpanel = new GraphicPanel(name);
    	else gpanel.removeAll();
    	
    	if (elements!=null) {
    	    LinkedList l = new LinkedList();
    	    
            for (int i=0;i<elements.length;i++)
                if (elements[i] instanceof Link) l.add(elements[i]);
                else gpanel.add(elements[i],0);
                
            int length=l.size();
            
            for (int i=0;i<length;i++)
                gpanel.add((Link)l.removeFirst());
        }
            
        if (mustBeRepainted) gpanel.repaint();
    }
    
    public void updateScrollBar(Dimension d) {
    	if (d!=null) {
    	    gpanel.setPreferredSize(d);
    	    gpanel.revalidate();
    	}
    }
    
    /**
     * Required by InternalFrameListener.
     *<p>External Operations:
     *Manager.selectNode(<i>name of the frame</i>);
     * <P><A HREF="../source/ComponentInternalFrame.html#internalFrameActivated">Source</A>
     */
    ///internalFrameActivated
    public void internalFrameActivated(InternalFrameEvent e) {
        //TMUtility.display("internalFrameActivated","");

        Manager.desktop.currentFrame = name;
    	if (!(Manager.nodeSelectionVeto) && (Manager.tree.isVisible())) Manager.selectNode(name);
    	Manager.nodeSelectionVeto = false;

        Manager.desktop.selectOnly(name);   // to fix changes from JDK v.1.22 to v.1.3
    }
    
    /**
     * Required by InternalFrameListener but not used.
     * <P><A HREF="../source/ComponentInternalFrame.html#internalFrameClosed">Source</A>
     */
    ///internalFrameClosed
    public void internalFrameClosed(InternalFrameEvent e) {}
    
    /**
     * Required by InternalFrameListener.
     *<p>External operations:
     *<ol> If this frame is already activated.
     *<li> Manager.openParentFrame(<i> current TreePath </i>)
     *<li> Manager.tree.collapsePath(<i> current TreePath </i>);
     *<li> Manager.select(<i>name of the frame</i>);
     *</ol>
     * <P><A HREF="internalFrameClosing">Source</A>
     */
    ///internalFrameClosing
    public void internalFrameClosing(InternalFrameEvent e) {
    	if (Manager.tree.isVisible())
    	    if (Manager.desktop.currentFrame==name) {
    	        TreePath treePath=Manager.fetchTreePath(name,Manager.tree);
    	    	    if (!(name.equals(Manager.ROOT_STRING))) Manager.openParentFrame(treePath);
    	    	    Manager.tree.collapsePath(treePath);
    	    	    Manager.select(treePath);
    	    }
   	
    }
    
    /**
     * Required by InternalFrameListener but not used.
     * <P><A HREF="../source/ComponentInternalFrame.html#internalFrameDeactivated">Source</A>
     */
    ///internalFrameDeactivated
    public void internalFrameDeactivated(InternalFrameEvent e) {}

    /**
     * Required by InternalFrameListener but not used.
     * <P><A HREF="../source/ComponentInternalFrame.html#internalFrameDeiconified">Source</A>
     */
    ///internalFrameDeiconified
    public void internalFrameDeiconified(InternalFrameEvent e) {}

    /**
     * Required by InternalFrameListener but not used.
     * <P><A HREF="../source/ComponentInternalFrame.html#internalFrameIconified">Source</A>
     */
    ///internalFrameIconified
    public void internalFrameIconified(InternalFrameEvent e) {}
    
    /**
     * Required by InternalFrameListener but not used.
     * <P><A HREF="../source/ComponentInternalFrame.html#internalFrameOpened">Source</A>
     */
    ///internalFrameOpened
    public void internalFrameOpened(InternalFrameEvent e) {}
    
    /**
     *Returns the name of the frame.
     * <P><A HREF="../source/ComponentInternalFrame.html#getName">Source</A>
     */
    ///getName
    public String getName() {
    	return name;
    }
    
    public static void resetCount() {
    	openFrameCount=0;
    	openFrameCountModulo=0;
    }
    
}