/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.awt.*;
import javax.swing.*;

public class Banner extends JWindow {

    public static JProgressBar pbar;
    
    /**
     * Create a window with a progress bar.
     * To be used when {@Link MainFrame} constructor is creating the GUI
     */
    ///
    public Banner() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        
        ImageIcon icon = new ImageIcon("icons/Logo3.jpg");
        //ImageIcon icon = new ImageIcon("icons/Logo.jpg");
     	//ImageIcon icon=new ImageIcon(ClassLoader.getSystemResource("icons/IsoldeLogo16.jpg"));
     	
        pbar = new JProgressBar(0,7);
        
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        
    	setBounds(screenSize.width/2-w/2,screenSize.height/2-h/2,w,h);
        
     	Container c = getContentPane();
     	c.add(new JLabel(icon),BorderLayout.CENTER);
     	c.add(pbar,BorderLayout.SOUTH);

    }
}