/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.text.*;
import java.lang.reflect.*;


public class AttributesPanel extends JPanel{

    private static final int MARGINX=5;
    private static final int MARGINY=5;
    private static final int GAPX=10;
    private static final int GAPY=5;
    private static final int SIZEX1=85;
    private static final int SIZEX2=70;
    private static final int SIZEY=20;
    private static final char INFINITE=236;
    
    private static final Color BACKGROUND_COLOR=new Color(255,255,255);
    private static final Color FIELD_COLOR=new Color(0,0,0);    
    private static final Color VALUE_COLOR=new Color(150,150,200);
    
    private GenericComponent currentComponent=null;
    
    
    class ALBoolean implements ActionListener{
        private Field field;
        private AbstractButton button;
        public ALBoolean(Field field,AbstractButton button){
            this.field=field;
            this.button=button;
        } 
        public void actionPerformed(ActionEvent e){
   	    try {
   	        field.setBoolean(currentComponent,button.isSelected());
   	        
   	        currentComponent.repaint();
   	        EditManager.restoreAttributesCoherence(currentComponent.getName(),
                Manager.desktop.getSelectedFrame().getTitle());
   	    } catch (Exception except){}
   	}
    }
    /**
     * Initialise a empty panel
     */
    ///
    public AttributesPanel(){
        super();
        setBackground(BACKGROUND_COLOR);
        setFont(new Font("Helvetica", Font.PLAIN, 14));        
        setLayout(null);       
    }
    
    /**
     * Display the attributes of the specified {@link GenericComponent}
     */
    ///
    public void displayAttributes(GenericComponent gc){
    	currentComponent=gc;
    	removeAll();
    	repaint();
    	if (gc==null) setPreferredSize(new Dimension(0,0));    	
    	else {
    	    Class cl=gc.getClass();
    	    Object [][] obj=gc.getAttributesToDisplay();
    	    Field field;
    	    JComponent jc;
    	    int posx=MARGINX;
    	    int posy=MARGINY;
    	    	
    	    setPreferredSize(new Dimension(MARGINX+SIZEX1+GAPX+SIZEX2,MARGINY+(SIZEY+GAPY)*obj.length));
    	    String fieldName;
    	    for (int i=0;i<obj.length;i++) if ((gc.getUserAttributes())[i]){
    	    	
    	    	//shijian 2001-3-22
    	    	fieldName = (String) obj[i][0];
            	if(!(Manager.systemOptions.domainModelFlag) &&
            		(fieldName.equals("dirty") ||
            		fieldName.equals("warning") ||
            		fieldName.equals("actor") ||
            		fieldName.equals("other"))) 
            		continue;
    		    
    		try{
    		    field=(cl.getField((String)obj[i][0]));
    		    //Label
    		    jc=new JLabel((String)obj[i][0]);
    	            jc.setBackground(getBackground());
    	            jc.setForeground(FIELD_COLOR);    		    
    		    jc.setBounds(posx,posy,SIZEX1,SIZEY);
    		    posx+=SIZEX1+GAPX;
                    add(jc);
                    
                    //Value
                    jc=(obj[i].length>1)?(buildJComponent(field,gc,(((Boolean)obj[i][1])).booleanValue())):(buildJComponent(field,gc));
    	            jc.setBackground(getBackground());
    	            jc.setForeground(VALUE_COLOR);    		    
    		    jc.setBounds(posx,posy,SIZEX2,SIZEY);
    		    posx=MARGINX;
    		    posy+=SIZEY+GAPY;
                    add(jc);
                    
    		} catch (Exception e){System.out.println("getField error");}
    	    }
    	}
    	scrollRectToVisible(new Rectangle(0,0,0,0));
    	revalidate();
    }
    
    private boolean getDefaultEditionValue(Field field){
    	String type=field.getType().getName();
    	if (type.equals("java.lang.String")) return false;
    	else if ((type.equals("boolean"))||(type.equals("int"))) return true;
    	else return false;
    }
    
    private JComponent buildJComponent(Field field,GenericComponent gc){
    	return buildJComponent(field,gc,getDefaultEditionValue(field));
    }
    
    private JComponent buildJComponent(Field field,GenericComponent gc,boolean editionValue){
    	String type=field.getType().getName();
    	JComponent result=null;
    	try{
    	    if (type.equals("java.lang.String")){
    	    	JLabel jc;
    	    	jc=new JLabel((String)field.get(gc));
    	    	result=jc;
    	    }
    	    else if (type.equals("int")){
    	    	int nb=field.getInt(gc);    	    	
    	    	JTextArea jc;
    	    	if (nb>=0) jc=new JTextArea(Integer.toString(nb));
    	    	else jc=new JTextArea("");
    	    	jc.setEditable(false);
    	    	result=jc;
    	    }
    	    else if (type.equals("boolean")) {
    	    	JCheckBox jc=new JCheckBox("",field.getBoolean(gc));
    	    	jc.setEnabled(editionValue);
    	    	if (editionValue) jc.addActionListener(new ALBoolean(field,jc));
    	    	result=jc;
    	    }
    	} catch (Exception e){System.out.println("error");}
    	if (result!=null) {
    	    result.setBackground(getBackground());
    	    result.setForeground(getForeground());
    	}
        return result;
    }
    
    /**
     * Empty the attribute panel
     */
    ///
    public void reset(){
    	displayAttributes(null);
    }
    
    /**
     * Updates the attributes when the selected {@link GenericComponent} has been
     * updated
     */
    ///
    public void updateAttributes(){
    	if (currentComponent!=null) displayAttributes(currentComponent);
    }
}
