/*
   Tamot --- Task Modelling Editor 
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   Redistribution in source and binary forms, with or without modification, are not permitted.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software. 
*/

package taskModellingTool;

import java.awt.*;
import javax.swing.*;
import java.io.CharArrayReader;


public class AboutDialog {
    
    // MARGINX SIZEX1 GAPX SIZEX2 MARGINX

    private static final int MARGINX=5;
    private static final int MARGINY=5;
    private static final int GAPX=10;
    private static final int GAPY=5;
    private static final int SIZEX1=80;
    private static final int SIZEX2=250;
    private static final int SIZEY=20;
    
    private static final Color BACKGROUND_COLOR = null;   //Color.white;
    private static final String PASSWORD = "i2tech";

    private static JDialog dialog;
    
    public AboutDialog() {
        JOptionPane pane = new JOptionPane(createPanel(),
            JOptionPane.PLAIN_MESSAGE,JOptionPane.DEFAULT_OPTION);

        dialog = pane.createDialog(MainFrame.mainFrame, "About Tamot");
        
        dialog.show();
    }
    
    private void addLabel(JPanel panel, String ss) {
        JLabel jc = new JLabel("<html>\n"+ss);
        panel.add(jc);
    }

    private JPanel copyrightPanel() {
        JPanel result = new JPanel();
        result.setBackground(Color.white);
        result.setLayout(new BoxLayout(result, BoxLayout.Y_AXIS));
        
        addLabel(result,"&#169; Copyright Commonwealth Scientific and Industrial Research Organisation ('CSIRO'), Australia 2000.");
        addLabel(result," ");
        addLabel(result,"All rights in this Software are reserved to CSIRO. You are only permitted to have this Software");
        addLabel(result,"in your possession and to make use of it if you have agreed to a License Agreement with CSIRO.");
        addLabel(result," ");
        addLabel(result,"Please see web site at http://www.cmis.csiro.au/iit/Projects/Isolde/Tamot/ for the latest information");
        addLabel(result,"about Tamot.");
        
        return result;
    }
    
    private JPanel thirdPartyAcknowledgementPanel() {
        JPanel result = new JPanel();
        result.setBackground(Color.white);
        result.setLayout(new BoxLayout(result, BoxLayout.Y_AXIS));
        
        addLabel(result,"This product includes software developed by the following :");
        addLabel(result," ");
        addLabel(result,"1.    the Apache Software Foundation (http://www.apache.org/) --- IBM XML4J;");
        addLabel(result,"2.    the Sun Microsystems, Inc (http://java.sun.com/xml/) --- Java Project X;");
        addLabel(result,"3.    the SAXON XSLT Processor from Michael Kay (http://users.iclway.co.uk/mhkay/saxon/) --- Saxon.");
        
        return result;
    }

    private JPanel developmentTeamPanel() {
        JPanel result = new JPanel();
        result.setBackground(Color.white);
        result.setLayout(new BoxLayout(result, BoxLayout.Y_AXIS));
        
        addLabel(result,"This product is being developed by the Intelligent Interactive Technology Group (IIT),");
        addLabel(result,"CSIRO Mathematical and Information Science.");
        addLabel(result," ");
        addLabel(result,"Web site : http://www.cmis.csiro.au/iit/");
        addLabel(result," ");
        addLabel(result,"IIT Group Leader          : <font color='red'>Dr. Cecil&#233; Paris</font>, email Cecile.Paris@cmis.csiro.au");
        addLabel(result,"Isolde Project Leader     : <font color='red'>Dr. Shijian Lu</font>, email Shijian.Lu@cmis.csiro.au");
        addLabel(result,"Isolde Development Member : <font color='red'>Dr. Keith Vander Linden</font>, email kvlinden@calvin.edu");
        addLabel(result,"Isolde Development Member : <font color='red'>Dr. Nathalie Colineau</font>, email Nathalie.Colineau@cmis.csiro.au");
        //addLabel(result,"Isolde Development Member : <font color='red'>Thomas Lo</font>, email Thomas.Lo@cmis.csiro.au.");
        
        return result;
    }

    private void addTitleLabel(JPanel panel, String ss) {
        addLabel(panel,"<font  face=\"Arial Rounded MT Bold\" size=\"4\" color=\"#4B0082\">"+ss+"</font>");
    }
    
    private JPanel createPanel() {
        JPanel aboutPanel = new JPanel();
        aboutPanel.setBackground(BACKGROUND_COLOR);
        aboutPanel.setFont(new Font("Helvetica", Font.PLAIN, 14));        
        aboutPanel.setLayout(new BoxLayout(aboutPanel, BoxLayout.Y_AXIS)); 

        JComponent jc;

        addTitleLabel(aboutPanel,"TAMOT 3 --- Version "+MainMenu.versionNum);
        addTitleLabel(aboutPanel," ");

        addTitleLabel(aboutPanel,"IMPORTANT NOTICE");
        jc = copyrightPanel();
        aboutPanel.add(jc);

        addTitleLabel(aboutPanel," ");
        addTitleLabel(aboutPanel,"CURRENT DEVELOPMENT TEAM");
        jc = developmentTeamPanel();
        aboutPanel.add(jc);

        addTitleLabel(aboutPanel," ");
        addTitleLabel(aboutPanel,"THIRD-PARTY SOFTWARE ACKNOWLEDGEMENT");
        jc = thirdPartyAcknowledgementPanel();
        aboutPanel.add(jc);

        addTitleLabel(aboutPanel," ");

        return aboutPanel;
    }
}