/**
 *  Tamot --- Task Modelling Editor
 *  Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
 *  (CSIRO), Australia. All rights reserved. 
 *
 *  The Software, owned by CSIRO Australia, has been developed by the CSIRO 
 *  Intelligent Interactive Technology group. 
 *  For more information, please see http://www.cmis.csiro.au/iit/.
 *
 *  The Software is a beta-test version for internal research and evaluation purposes 
 *  by the Licensee. The Software is still at a development stage. 
 *  It has not undergone complete testing and may have inherent errors,
 *  bugs or deficiencies that can affect the operation of the Software. 
 *
 *  We encourage your feedback and suggestions. Any bugs / suggestions found please email to
 *  Shijian.Lu@cmis.csiro.au. 
 *
 *  After you have signed the Beta-Test Software License Agreement with the CSIRO,
 *  CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
 *  personal, non-commercial and lawful end use. Implied licenses are negated. 
 *
 *  Warranty Disclaimer : 
 *
 *  CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
 *  the Software by the Licensee will not infringe any third partys 
 *  Intellectual Property Rights nor that the Software will be of merchantable quality,
 *  or suitable for a particular purpose. CSIRO excludes all terms, conditions and
 *  warranties implied by custom, the general law or statute in relation to the
 *  Software.
*/

package rosetm;
import rose.*;

/**
 * class UseCaseTM is a wrapper class for RoseUseCase generated by 
 * using J-Integra. (See  <A HREF="http://www.linar.com/">http://www.linar.com/</A><P>)
 * The aim of this class is to provide customised functionality for create 
 * use cases, 20-11-2001
*/

public class ClassTM extends RoseClass{
	public ClassTM() throws java.io.IOException, java.net.UnknownHostException {
    	super();
  	}	
	
  /**
   * containOperation. 
   *
   * @param     roseClass (in); the name of a rose class.
   * @param     opName (in); operation name.
   * @return    return value.  "true" if opName is an operation in 
   * 			roseCalss.
   * @exception java.io.IOException If there are communications problems.
   * @exception com.linar.jintegra.AutomationException If the remote server throws an exception.
   */
public static boolean containOperation (IRoseClass roseClass, 
										 String opName)  {
	try{									 	
		IRoseOperation opTemp =null;								 	
		IRoseOperationCollection opCol =roseClass.getOperations(); 	
	    for (short i = 1; i<= opCol.getCount(); i++){
        	opTemp=(IRoseOperation)opCol.getAt(i);
        	if (opTemp.getName().equals(opName))
				return true;
        }
	  	return false;
	} catch (Exception e)
	{
		System.err.println(e);
	  	return false;
	}
		
}
	
  /**
   * getOperation. 
   *
   * @param     roseClass (in); the name of a rose class.
   * @param     opName (in); operation name.
   * @return    return value.  the operation whose name is opName.
   * 			null, if there is no such operation
   * @exception java.io.IOException If there are communications problems.
   * @exception com.linar.jintegra.AutomationException If the remote server throws an exception.
   */
public static IRoseOperation getOperation (IRoseClass roseClass, 
										 String opName)  {
	IRoseOperation opTemp =null;
	
	try{									 	
		IRoseOperationCollection opCol =roseClass.getOperations(); 	
	    for (short i = 1; i<= opCol.getCount(); i++){
        	opTemp=(IRoseOperation)opCol.getAt(i);
        	if (opTemp.getName().equals(opName))
				return opTemp;
        }
	  	return null;
	} catch (Exception e)
	{
		System.err.println(e);
	  	return null;
	}
		
}

}