/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

//Source file: D:/Projects/Isolde/parser/Transition.java

package parser.FSParser;

import java.util.Vector;

public class Transition {
  private int _source;         // source state of the arc
  private int _destination;    // destination/target state of the arc
  private String _guard;       // condition placed on following the arc
  private Vector _operations;  // list of operations to perform when following the arc

  // operation codes: 
  public static final int UNDERFLOW = 0;         // an underflow for the enumerated type
  public static final int INCREMENT_CURRENT = 1; // increment the current parse string index
  public static final int PREPSTART_EQ_CURRENT = 2;  // set preposition start = current index
  public static final int PREPSTART_EQ_WORKING = 3;  // set preposition start = working index
  public static final int DETSTART_EQ_CURRENT = 4;  // set determiner start = current index
  public static final int DETSTART_EQ_WORKING  = 5;  // set determiner start = working index
  public static final int START_EQ_CURRENT = 6;  // set constituent start = current index
  public static final int START_EQ_WORKING = 7;  // set constituent start = working index
  public static final int WORKING_EQ_START = 8;  // set working index = constituent start index
  public static final int WORKING_EQ_CURRENT =9;  // set working index = current index
  public static final int HEAD_EQ_CURRENT = 10;   // mark current word as constituent head
  public static final int END_EQ_CURRENT_MINUS_1 = 11;  // set constituent end position
  //       (also sets length and DM name)
  public static final int ADD_TO_HEAD = 12;	   // for multiword heads. brasser 2001-6-14
  public static final int RESTART_PARSER = 13;	   // for multiple tasks in a single sentence. brasser 2001-7-6
  public static final int SET_ROLE = 14;		   // setting discourse roles. brasser 2001-7-17
  public static final int OVERFLOW = 15;         // an overflow for the enumerated type

  public Transition(int inSource, int inDestination, String inGuard) 
  {
    _source = inSource;
    _destination = inDestination;
    _guard = inGuard;
    _operations = new Vector();   // these will be added with addOperation()
  }

  public void addOperation(int inOpCode)
  {
    if (inOpCode <= UNDERFLOW)
      System.out.println("Transition operation underflow for code: " + inOpCode);
    else if (inOpCode >= OVERFLOW)
      System.out.println("Transition operation overflow for code: " + inOpCode);
    else
      _operations.add(new Integer(inOpCode));
    return;
  }

  public int source()
  {
    return _source;
  }

  public int destination()
  {
    return _destination;
  }

  public String guard()
  {
    return _guard;
  }

  public Vector operations()
  {
    return _operations;
  }
}
