/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

//Source file: D:/Projects/Isolde/parser/Constituent.java

/* Revision History

   Added facilities for the prepositionPosition for the contextual type.
   kvlinden, 23jan2002

   */


package parser.FSParser;

import java.lang.String;

public class Constituent {
  private String _name;           // name of the constituent (from the grammar)
  private int _prepositionPosition; // preposition's starting index in the input string
  private int _determinerStart; // determiner's starting index in the input string
  private int _startPosition;     // index of its start position in the input string
  private int _endPosition;       // index of its last position in the input string
  private int _headPosition;      // index of the beginning its head word/phrase
  private int _headLength;        // length of its head/phrase
  private String _domainObjectName;   // unique internal name of the head's DM entity
   
  public Constituent(String inName) 
  {
    _name = inName;
  }

  public void initialize()
  {
    _prepositionPosition = -1;
    _determinerStart = -1;
    _startPosition = -1;
    _endPosition = -1;
    _headPosition = -1;
    _headLength = 0;
    _domainObjectName = "";
  }

  public String name()
  {
    return _name;
  }

  public int prepositionPosition()
  {
    return _prepositionPosition;
  }


  public int determinerStart()
  {
    return _determinerStart;
  }

  public int startPosition()
  {
    return _startPosition;
  }

  public int endPosition()
  {
    return _endPosition;
  }

  public int headPosition()
  {
    return _headPosition;
  }

  public int headLength()
  {
    return _headLength;
  }

  public String domainObjectName()
  {
    return _domainObjectName;
  }

  // The Constituent should know about its own header - kvlinden, 23jan2002
  public String getHeader()
  {
    return "name            prep\tdeter\tstart\tend\thead\tLen\tDMName\n";
  }

  public void setPrepositionPosition(int value)
  {
    _prepositionPosition = value;
    return;
  }


  public void setDeterminerStart(int value)
  {
    _determinerStart = value;
    return;
  }

  public void setStartPosition(int value)
  {
    _startPosition = value;
    return;
  }

  public void setEndPosition(int value)
  {
    _endPosition = value;
    return;
  }

  public void setHeadPosition(int value)
  {
    _headPosition = value;
    return;
  }

  public void setHeadLength(int value)
  {
    _headLength = value;
    return;
  }

  public void setDomainObjectName(String value)
  {
    _domainObjectName = value;
    return;
  }

  public String toString()
  {
    // First, include a set portion of the constituent name.
    String nameString = "";
    for (int i = 0; i < 15; i++)
      if (i < name().length())
	nameString += name().charAt(i);
      else
	nameString += ' ';

    // Now, concatenate the rest of the information.
    return 
      nameString + " \t" + 
      prepositionPosition() + " \t" + 
      determinerStart() + " \t" + 
      startPosition() + " \t" + 
      endPosition() + " \t" + 
      headPosition() + " \t" + 
      headLength() + " \t" + 
      domainObjectName() + " \n";
  }
}
