/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package domainModel.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import java.io.*;
import domainModel.*;
import taskModellingTool.*;


public class DmNonActPane extends JPanel {
	
  	private DmManager _dMM=Manager.getXDM().getDmManager();	// default _dMM 
 	private static DmRelation _dMRelat = DmRelation.getInstance();
	private DmConcept _eCon;

	//define labels to be used in the dialod box
	private static final String _name = "Name";
	private static final String _type = "Type";
	private static final String _dirty = "Dirty";
	private static final String _spelling = "Spelling";
	private static final String _mass = "Mass Noun";
	private static final String _plural = "Plural";
	private static final String _note = "Comment";
	
	
	// put all entity concepts(including User and System types in _concepts
   private JComboBox _conCm, _cardCm, _enInsCm;
 
   //define editable components
	private JTextField _nameT,_premT,_postmT;

   private JCheckBox _dirtyC;
   private JTextArea _noteA;
   
	public DmEdit(DmManager dmm ){
		super();
		_dMM =dmm;

		_pane = new JOptionPane(getAllPanel(),
    		JOptionPane.PLAIN_MESSAGE,JOptionPane.OK_CANCEL_OPTION);
    		
	    _dmDialog = _pane.createDialog(_parent, _title);
		_dmDialog.show();
		
		onButtonPress();
	}
	
	public DmEdit(JFrame parent, String title){
		super();
		_parent =parent;
		_title =title;
		//	_pane = new JOptionPane(getAllPanel(),
    	//	JOptionPane.PLAIN_MESSAGE,JOptionPane.OK_OPTION);
    	
    	String [] options = {"Close"};
		_pane= new JOptionPane(getAllPanel(), JOptionPane.PLAIN_MESSAGE, 
			JOptionPane.DEFAULT_OPTION, null, options,
 			options[0]);
    	
	   	_dmDialog = _pane.createDialog(_parent, _title);
		_dmDialog.show();
		
		onButtonPress();
				
	}

	private JPanel getAllPanel(){
		JPanel allPanel= new JPanel();
      	allPanel.setLayout(new GridLayout(1,3));
       	allPanel.add(getNonActPanel());
      	allPanel.add(getActInsPanel());
     	allPanel.add(getConPanel());

		return allPanel;	
	}


	private JComponent[] getAllPanels(){
		JComponent[]      components = new JComponent[3];
		components[0] = getFieldsPanel();
		components[1] = getNotePanel();
		components[2] = getCardPane();
		return components;	
	}

	private JPanel getFieldsPanel(){
		JPanel fieldsPanel= new JPanel();
      fieldsPanel.setLayout(new GridLayout(3,2));
		
      fieldsPanel.add(new JLabel(_name));
     	_nameT = new JTextField(_eCon.getName());
      fieldsPanel.add(_nameT);
      
      fieldsPanel.add(new JLabel(_type));
     	//_typeT = new JTextField(_eCon.getType());
   	_typteCm.setSelectedItem(_eCon.getType());
      fieldsPanel.add(_typteCm);
     
      fieldsPanel.add(new JLabel(_dirty));
    	_dirtyC = new JCheckBox("",_eCon.getDirty());
      fieldsPanel.add(_dirtyC);
     
     	return fieldsPanel;	
		
	}
	
	private JPanel getNotePanel(){
		JPanel notePanel= new JPanel();
		Dimension notePanelD= new Dimension(400,100);
      notePanel.setPreferredSize(notePanelD);
      
      notePanel.setLayout(new BorderLayout());
							//new GridLayout(2,1));
		
      notePanel.add(new JLabel(_note),BorderLayout.NORTH);
     	_noteA = new JTextArea(_eCon.getNote());
     	_noteA.setRows(4);	//4 rows of text
      notePanel.add(_noteA, BorderLayout.CENTER);
     	return notePanel;	
      
	}
	
	
	private JTabbedPane getCardPane(){
		JTabbedPane cardPane= new JTabbedPane();
		// Add the different tabs 
		cardPane.addTab(DmConcept._ENGLISH, null, getEnglihCard());
		cardPane.addTab(DmConcept._FRENCH, null, 	getFrechCrad());
		cardPane.addTab(DmConcept._CHINESE, null, getChineseCard());
		
     	return cardPane;	
      
	}
	
	private JPanel getEnglihCard(){
		_englishCard= new JPanel();
		_englishCard.setLayout(new GridLayout(3,2));

      _englishCard.add(new JLabel(_spelling));
    	EnglishNoun engNoun =(EnglishNoun)_eCon.getCard(DmConcept._ENGLISH);
    	_EngSpellingT = new JTextField(engNoun.getSpelling());
    	_englishCard.add(_EngSpellingT);
     
      _englishCard.add(new JLabel(_mass));
    	_massC = new JCheckBox("",engNoun.isMassNoun());
    	_massC.addActionListener(new MassNounChange());
      _englishCard.add(_massC);
     
      _englishCard.add(new JLabel(_plural));
      _pluralT = new JTextField();
    	if (engNoun instanceof IrregularNoun){
    		_pluralT.setText(((IrregularNoun)engNoun).getPlural());
    	} else {
    		_pluralT.setText("");
    	}
      _englishCard.add(_pluralT);
      
      //disable plural if it is a mass noun
      updatePluralT();
     	return _englishCard;	
      
	}
	
}