/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package domainModel;

/** 
* DmTag.java
* manager domain model tag used in XML documents;
*/

public class XDmTag
{
	//predefined XML doc tags
		// DmCOncept related tags
	private static String rootT = "Tamot";
	private static String versionT = "Version";

	private static String dmRootT = "Domain_Model";
	private static String _dmAIColorT = "Action_Instance_Color";
	private static String _dmEIColorT = "Entity_Instance_Color";
	private static String _dmConColorT = "Concept_Color";
	private static String _dmColorT = "Color";
	private static String _dmRedT = "Red";
	private static String _dmGreenT = "Green";
	private static String _dmBlueT = "Blue";

	// DmCOncept related tags
	private static String conceptT = "DmConcept";
	private static String dmIdT = "ID";
	private static String dmNameT = "Name";
	//private static String dmLexRT = "LexRoot"; //Shijian 2001-1-15
	private static String dmParentT = "Parent";
	private static String dmEnglishCardT = "EnglishCard";	//Shijian 2001-1-15
	private static String dmDirtyT = "Dirty";	//Shijian 2001-1-15
	private static String dmTypeT = "Type";
	private static String dmNoteT = "Note";
	
	// Entity related tags
	private static String entityT = "DmEntity";
	private static String eRelT = "ERelation";
	private static String cardiT = "Cardinality";
	private static String conceptOfT = "ConceptOf";
	private static String premodifierT = "PreModifier";	//Shijian 2001-1-15
	private static String postmodifierT = "PostModifier";	//Shijian 2001-1-15
	private static String determinatorT = "Determinator";	//Shijian 2001-10-17
	private static String noDeterminatorT = "NO_Determinator";
	
	private static String partOfT = "PartOf";
	private static String newERelT = "NewERel";
	private static String eRNameT = "ERName";
	private static String eRValueT = "ERValue";
	
	// Action related tags 
	private static String actionT = "DmAction";
	private static String aRelT = "ARelation";
	private static String actorT = "Actor";
	private static String acteeT = "Actee";
	private static String sourceT = "Source";
	private static String destiT = "Destination";
	private static String instruT = "Instrument";
	private static String newARelT = "NewARel";
	private static String aRNameT = "ARName";
	private static String aRValueT = "ARValue";
	private static String aARelT = "AARelation";
	private static String purposeRequestT = "PurposeRequest";
	
	//18-1-2002
	//introduce contextual type for entity instance in the 
	// action instance relations
	private static String _AEContextType = "AEContextType";
	private static String _NewContext = "NewContext";
	private static String _Context = "Context";

	
	// English cards related tags 	//Shijian 2001-1-15
	private static String _englishNounT = "EnglishNoun";
	private static String _englishVerbT = "EnglishVerb";
	private static String _irregularVerbT = "IrregularVerb";
	//private static String _cardNameT = "_name";
	private static String _massNounT = "_massNoun";
	private static String _spellingT = "_spelling";
	private static String _pluralT = "_plural";
	private static String _1stPersonT = "_1stPerson";
	private static String _3rdPersonT = "_3rdPerson";
	private static String _ingT = "_ing";
	private static String _pastT = "_past";
	private static String _ppT = "_pp";
	private static String _propT = "_prop";
	
	// interface instance Labels
	private static String _labelT = "Label";
	private static String _noLabelT = "NO_LaBel";
	
	// document style parameters
	private static String _styleHow = "Style_how";
	private static String _stepByStep = "StyleStepByStep";
	private static String _conjunction = "Conjunction";
	private static String _modalityCan = "ModalityCan";
	private static String _purposeFirst = "PurposeFirst";   

	//manipulation methods
	//-----------------------------------------------------
	public static void setRootT(String aT){
		rootT = aT;
		
	}
	public static void setVersionT(String aT){
		versionT = aT;
		
	}
	public static void setDmRootT(String aT){
		dmRootT = aT;
		
	}
	public static void setConceptT(String aT){
		conceptT = aT;
	}
	
	public static void setDmIdT(String aT){
		dmIdT = aT;
		
	}
	
	public static void setDmNameT(String aT){
		
		dmNameT = aT;
	}
	
//	public static void setDmLexRT(String aT){
//		dmLexRT = aT;
		
	//}
	
	public static void setDmParentT(String aT){
		
		dmParentT = aT;
	}
	
	public static void setDmTypeT(String aT){
		
		dmTypeT = aT;
	}
	
	public static void setDmNoteT(String aT){
		
		dmNoteT = aT;
	}

	public static void setEntityT(String aT){
		entityT = aT;
		
	}
	public static void setERelT(String aT){
		eRelT = aT;
	}
	
	public static void setCardiT(String aT){
		cardiT = aT;
		
	}
	
	public static void setConceptOfT(String aT){
		
		conceptOfT = aT;
	}
		
	public static void setPartOfT(String aT){
		partOfT = aT;
		
	}
	public static void setNewERelT(String aT){
		newERelT = aT;
	}
	
	public static void setERNameT(String aT){
		eRNameT = aT;
		
	}
	
	public static void setERValueT(String aT){
		
		eRValueT = aT;
	}
	
	//manipulation methods 
	//-----------------------------------------------------
	public static void setActionT(String aT){
		actionT = aT;
		
	}
	public static void setARelT(String aT){
		aRelT = aT;
	}
	
	public static void setActorT(String aT){
		actorT = aT;
		
	}
	
	public static void setActeeT(String aT){
		
		acteeT = aT;
	}
	
	public static void setSourceT(String aT){
		sourceT = aT;
		
	}
	
	public static void setDestiT(String aT){
		
		destiT = aT;
	}
	
	public static void setInstruT(String aT){
		
		instruT = aT;
	}
	
	public static void setNewARelT(String aT){
		
		newARelT = aT;
	}

	public static void setARNameT(String aT){
		aRNameT = aT;
		
	}
	public static void setARValueT(String aT){
		aRValueT = aT;
	}
	
	//manipulation methods 	 //shijian 200-1-15
	//-----------------------------------------------------
	public static void setEnglishNounT(String aT){
		_englishNounT  = aT;
		
	}
	public static void setEnglishVerbT(String aT){
		_englishVerbT  = aT;
	}
	
	public static void setIrregularVerbT (String aT){
		_irregularVerbT  = aT;
		
	}
	
	public static void setDmEnglishCardT(String aT){
		dmEnglishCardT  = aT;
		
	}
	
	public static void setDirtyT(String aT){
		dmDirtyT  = aT;
		
	}

	
	public static void setPremodifierT (String aT){
		premodifierT  = aT;
	}
	
	public static void setPostmodifierT (String aT){
		postmodifierT  = aT;
		
	}
	
//	public static void setCardNameT (String aT){
		
//		_cardNameT  = aT;
//	}
	
	public static void setMassNounT (String aT){
		_massNounT  = aT;
		
	}
	
	public static void setSpellingT (String aT){
		
		_spellingT  = aT;
	}
	
	public static void setPluralT (String aT){
		
		_pluralT  = aT;
	}
	
	public static void set1stPersonT (String aT){
		
		_1stPersonT  = aT;
	}

	public static void set3rdPersonT (String aT){
		_3rdPersonT  = aT;
		
	}
	public static void setIngT (String aT){
		_ingT  = aT;
	}
	
	public static void setPastT  (String aT){
		
		_pastT   = aT;
	}

	public static void setPpT  (String aT){
		_ppT   = aT;
		
	}
	public static void setPropT  (String aT){
		_propT   = aT;
	}


	//access methods 
	//----------------------------------------------------
	public static String getRootT(){
		return rootT;
		
	}
	public static String getVersionT(){
		return versionT;
		
	}
	public static String getDmRootT(){
		return dmRootT;
		
	}
	public static String getConceptT(){
		return conceptT;
		
	}
	
	public static String getDmIdT(){
		return dmIdT;
		
	}
	
	public static String getDmNameT(){
		
		return dmNameT;
	}
	
//	public static String getDmLexRT(){
//		return dmLexRT;
		
//	}
	
	public static String getDmParentT(){
		
		return dmParentT;
	}
	
	public static String getDmTypeT(){
		
		return dmTypeT;
	}
	
	public static String getDmNoteT(){
		
		return dmNoteT;
	}
	
	public static String getEntityT(){
		return 	entityT;
		
	}
	public static String getERelT(){
		return eRelT;
	}
	
	public static String getCardiT(){
		return cardiT;
		
	}
	
	public static String getConceptOfT(){
		
		return conceptOfT;
	}
	
	public static String getPartOfT(){
		return partOfT;
		
	}
	public static String getNewERelT(){
		return newERelT;
	}
	
	public static String getERNameT(){
		return eRNameT;
		
	}
	
	public static String getERValueT(){
		
		return eRValueT;
	}
	
	public static String getActionT(){
		return actionT;
		
	}
	public static String getARelT(){
		return aRelT;
	}
	
	public static String getActorT(){
		return actorT;
		
	}
	
	public static String getActeeT(){
		
		return acteeT;
	}
	
	public static String getSourceT(){
		return sourceT;
		
	}
	
	public static String getDestiT(){
		
		return destiT;
	}
	
	public static String getInstruT(){
		
		return instruT;
	}
	
	public static String getNewARelT(){
		
		return newARelT;
	}

	public static String getARNameT(){
		return aRNameT;
		
	}
	public static String getARValueT(){
		return aRValueT;
	}
	
	
	//access methods 	 //shijian 200-1-15
	//-----------------------------------------------------
	public static String getEnglishNounT(){
		return	_englishNounT ;
		
	}
	public static String getEnglishVerbT(){
		return _englishVerbT;
	}
	
	public static String getIrregularVerbT (){
		return _irregularVerbT ;
		
	}
	
	public static String getDmEnglishCardT(){
		return dmEnglishCardT;
		
	}
	
	public static String getDirtyT(){
		return dmDirtyT ;
		
	}

	public static String getPremodifierT (){
		return premodifierT;
	}
	
	public static String getPostmodifierT (){
		return postmodifierT;
		
	}
		
	public static String getMassNounT (){
		return _massNounT;
		
	}
	
	public static String getSpellingT (){
		
		return _spellingT;
	}
	
	public static String getPluralT (){
		
		return _pluralT ;
	}
	
	public static String get1stPersonT (){
		
		return _1stPersonT ;
	}

	public static String get3rdPersonT (){
		return _3rdPersonT;
		
	}
	public static String getIngT (){
		return _ingT;
	}
	
	public static String getPastT  (){
		
		return _pastT ;
	}

	public static String getPpT  (){
		return _ppT ;
		
	}
	public static String getPropT  (){
		return _propT ;
	}

	public static String getAIColorT (){
		
		return _dmAIColorT ;
	}
	
	public static String getEIColorT(){
		
		return _dmEIColorT;
	}

	public static String getConColorT (){
		return _dmConColorT;
		
	}
	public static String getColorT (){
		return _dmColorT;
	}
	
	public static String getRedT  (){
		
		return _dmRedT ;
	}

	public static String getGreenT  (){
		return _dmGreenT ;
		
	}
	public static String getBlueT  (){
		return _dmBlueT ;
	}
	public static String getLabelT(){
		return _labelT ;
	}
	public static String getInterfaceNoLabelT(){
		return _noLabelT ;
	}
	
	public static String getStyleHowT(){
		return _styleHow ;
	}
	public static String getStepByStepT(){
		return _stepByStep ;
	}
	public static String getConjunctionT(){
		return _conjunction ;
	}
	public static String getModalityCanT(){
		return _modalityCan ;
	}
	public static String getPurposeFirstT(){
		return _purposeFirst ; 
	}
	public static String getDeterminatorT(){
		return determinatorT ;
	}
	public static String getNoDeterminatorT(){ 
		return noDeterminatorT ;
	}
	public static String getPurposeRequestT(){
		return purposeRequestT ;
	}
	public static String getAARelT(){
		return aARelT ;
	}
	
	//18-1-2002
	public static String getAEContextTypeT(){ 
		return _AEContextType ;
	}
	public static String getNewContextT(){
		return _NewContext ;
	}
	public static String getContextT(){
		return _Context ;
	}

}