/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package domainModel;


import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import taskModellingTool.*;

import org.w3c.dom.*;
import com.ibm.xml.parsers.*;

/** 
* XConcept.java, it acts as a agent for communication
* between the DmConcept class and DOM Dmconcept element
* as defined by the NewDTDFile3.dtd
*/
public class XConcept
{
	private Document doc = null;

	public XConcept(Document aDoc){
		doc = aDoc;	
	}

	/** 
	* setDoc(), 
	* @PARAM: aDoc, the DOM doc 
	* @return void
	*/
	public void setDoc(Document aDoc)
  	{
		doc = aDoc;

  	} //setDoc()
	
	/** 
	* getDoc(), 
	* @return Document
	*/
	public Document getDoc()
  	{
		return doc;

  	} //getDoc()

	
	/** 
	* parse(), parses a XML document, if successful,
	* it'll procude a DOM document
	* @PARAM: uri, the file name of a XML doc to be parsed
	* @return void
	*/
	public void parse(String uri)
  	{
   	try
    	{
	      DOMParser parser = new DOMParser();
	      parser.parse(uri);
	      doc = parser.getDocument();
    	}
	   catch (Exception e)
	   {
	      System.err.println("Sorry, an error occurred: " + e);
	   }

  	} //parse()

  /** Prints the specified node, recursively. */
  public void printDOMTree(org.w3c.dom.Node node) 
  {
    int type = node.getNodeType();
    switch (type)
    {
      // print the document element
      case org.w3c.dom.Node.DOCUMENT_NODE: 
        {
          System.out.println("<?xml version=\"1.0\" ?>");
          
          //print doctype infor
          DocumentType tp= ((Document)node).getDoctype();
          if (tp!= null && 
          		tp.getSystemId() != null &&
          			tp.getName() != null){
          				
          		System.out.println("<!DOCTYPE " + 
          			tp.getName()+ " SYSTEM \""+
          			tp.getSystemId() + "\">");
          }

          printDOMTree(((Document)node).getDocumentElement());
          break;
        }

        // print element with attributes
      case org.w3c.dom.Node.ELEMENT_NODE: 
        {
          System.out.print("<");
          System.out.print(node.getNodeName());
          NamedNodeMap attrs = node.getAttributes();
          for (int i = 0; i < attrs.getLength(); i++)
          {
            org.w3c.dom.Node attr = attrs.item(i);
            System.out.print(" " + attr.getNodeName() + 
                             "=\"" + attr.getNodeValue() + 
                             "\"");
          }
          System.out.print(">");

          NodeList children = node.getChildNodes();
          if (children != null)
          {
            int len = children.getLength();
            for (int i = 0; i < len; i++)
              printDOMTree(children.item(i));
          }

          break;
        }

        // handle entity reference nodes
      case org.w3c.dom.Node.ENTITY_REFERENCE_NODE: 
        {
          System.out.print("&");
          System.out.print(node.getNodeName());
          System.out.print(";");
          break;
        }

        // print cdata sections
      case org.w3c.dom.Node.CDATA_SECTION_NODE: 
        {
          System.out.print("<![CDATA[");
          System.out.print(node.getNodeValue());
          System.out.print("]]>");
          break;
        }

        // print text
      case org.w3c.dom.Node.TEXT_NODE: 
        {
          System.out.print(node.getNodeValue());
          break;
        }

        // print processing instruction
      case org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE: 
        {
          System.out.print("<?");
          System.out.print(node.getNodeName());
          String data = node.getNodeValue();
          {
            System.out.print(" ");
            System.out.print(data);
          }
          System.out.print("?>");
          break;
        }
    }

    if (type == org.w3c.dom.Node.ELEMENT_NODE)
    {
      System.out.print("</");
      System.out.print(node.getNodeName());
      System.out.print('>');
      System.out.println();

    }
  } // printDOMTree(Node)

  	
  	/** 
  	* append a dmConcept to the DOM tree
  	*/
	public boolean appendConcept(DmConcept aCon){
		
		if (doc == null || aCon == null) return false;
		try {
			String conceptTag= XDmTag.getConceptT(); //"DmConcept";
			// create the DmConcept element with the right attributes
	  		Element elem = doc.createElement(conceptTag);
	      elem.setAttribute(XDmTag.getDmIdT(), aCon.getID());
	      elem.setAttribute(XDmTag.getDmNameT(), aCon.getName());
//	      elem.setAttribute(XDmTag.getDmLexRT(), aCon.getLexItem());//shijian 2001-1-15
	      if (aCon.getParent() != null)
	      	elem.setAttribute(XDmTag.getDmParentT(), aCon.getParent().getID());
	      if (aCon.getCard(DmConcept._ENGLISH) != null)		//shijian 2001-1-15
	      	elem.setAttribute(XDmTag.getDmEnglishCardT(), aCon.getCard(DmConcept._ENGLISH).getName());
	      		      	
	      //create the child-elements for the DmConcept
	      // for time-being Istances and Children are ignored
	      Element elemType = doc.createElement(XDmTag.getDmTypeT());
	      elemType.appendChild(doc.createTextNode(aCon.getType()));
	      elem.appendChild(elemType);
			if (aCon.getNote() != null){
		      Element elemNote = doc.createElement(XDmTag.getDmNoteT());
		      elemNote.appendChild(doc.createTextNode(aCon.getNote()));
		      elem.appendChild(elemNote);
			}
	      
	      //NodeList cons = doc.getDocumentElement().
	      NodeList cons = doc.getElementsByTagName(XDmTag.getDmRootT());
	    	if (cons != null)
	    	{	
	    		int len=cons.getLength();
	         //cons.item(0).getParentNode().insertBefore(elem,cons.item(0));
	         cons.item(0).appendChild(elem);
	         return true;
	    	}
	    
		}
		catch (Exception e)
		{
			System.err.println(e);
		}
		return false;
  	}//appendConcept()

  	
  	/** 
  	* conToEle, is get a Dmconcept object as input 
  	* and return a DOM DmConcept element. 
  	*/
	public  Element conToEle(DmConcept aCon){
		if (aCon == null) return null;
		Element elem = null;		
		try {
			String conceptTag= XDmTag.getConceptT(); //"DmConcept";
			// create the DmConcept element with the right attributes
	  		elem = doc.createElement(conceptTag);
	      	elem.setAttribute(XDmTag.getDmIdT(), aCon.getID());
		    
	      	// replace special XML characters
		    String sTemp =aCon.getName();
		    sTemp=XMLUtility.convertForEntities(sTemp);
		    
		    elem.setAttribute(XDmTag.getDmNameT(), sTemp);	//aCon.getName());
//	      	elem.setAttribute(XDmTag.getDmLexRT(), aCon.getLexItem()); //shijian 2001-1-15
	      	if (aCon.getParent() != null)
	      		elem.setAttribute(XDmTag.getDmParentT(), aCon.getParent().getID());
	      	if (aCon.getDirty() )
	      		elem.setAttribute(XDmTag.getDirtyT(), XManager._XML_YES);
	      	else
	      		elem.setAttribute(XDmTag.getDirtyT(), XManager._XML_NO);

	      	if (aCon.getCard(DmConcept._ENGLISH) != null)		//shijian 2001-1-15
	      		elem.setAttribute(XDmTag.getDmEnglishCardT(), 
	      			aCon.getCard(DmConcept._ENGLISH).getID());
	      	
	      	//create the child-elements for the DmConcept
	     	// for time-being Istances and Children are ignored
	      	Element elemType = doc.createElement(XDmTag.getDmTypeT());
	      	elemType.appendChild(doc.createTextNode(aCon.getType()));
	      	elem.appendChild(elemType);
			if (aCon.getNote() != null && (!aCon.getNote().trim().equals("")) ){
				System.out.println("notes=" + "\""+ aCon.getNote().trim()+"\"");
		      	// replace special XML characters
			    sTemp =aCon.getNote();
			    sTemp=XMLUtility.convertForEntities(sTemp);
			    
		      	Element elemNote = doc.createElement(XDmTag.getDmNoteT());
		      	elemNote.appendChild(doc.createTextNode(sTemp));	//aCon.getNote()));
		      	elem.appendChild(elemNote);
			}
	      
		}
		catch (Exception e)
		{
			System.err.println(e);
		}
		return elem;
  	}//conToEle()
  	  	
  	/** 
  	* eleToCon, is get a Dmconcept object as input 
  	* and return a DOM DmConcept element. 
  	* 
  	*/
	public  DmConcept eleToCon(Element ele){
		if (ele == null) return null;
		DmConcept con = null;
		if (ele.getTagName().equals(XDmTag.getConceptT())){	// if it is a DmConcept element
			try{
				String conId= ele.getAttribute(XDmTag.getDmIdT());
				if (conId == null || conId == "") System.out.println("no ID");

				String conName= ele.getAttribute(XDmTag.getDmNameT());
			//	String conLex= ele.getAttribute(XDmTag.getDmLexRT());
				String parent= ele.getAttribute(XDmTag.getDmParentT());
				
					//shijian 2001-1-15
				String dirty= ele.getAttribute(XDmTag.getDirtyT());
				String englishCardID= ele.getAttribute(XDmTag.getDmEnglishCardT());
				
				//System.out.println("conName name: "+conName);

				//retrieve "type" and "note"
				String conType = null;
				String conNote = null;
				NodeList children = ele.getElementsByTagName(XDmTag.getDmTypeT());
	         if (children != null && children.getLength() >0 ) {
	         	conType = children.item(0).getFirstChild().getNodeValue(); 
	         	//18-1-2002
	         	//promote contextual type to super-type for files generate
	         	// with older verstion
         	if (ConceptType.isInterfaceType(conType))
         		conType=ConceptType.getInterfaceType();
         	if (ConceptType.isObjectType(conType))
         		conType=ConceptType.getDefaultEntityType();
				//System.out.println("conType name: "+conType);

	         }
	         children = ele.getElementsByTagName(XDmTag.getDmNoteT());
	         //24-10-2001
	         //check for null exception
	         if (children != null && children.getLength() >0 ) 
	         	if(children.item(0)!= null)
	         		if (children.item(0).getFirstChild() != null)
	         			if (children.item(0).getFirstChild().getNodeValue()!= null)
	         				conNote =children.item(0).getFirstChild().getNodeValue(); 
	         
	         // create the DmConcept object
	         conName= XMLUtility.checkAndConvertForEntities(conName);


	         con = new DmConcept(conId,conName, conType);

	         if (parent != null)
	        		con.setParent(eleToCon(doc.getElementById(parent.trim())));
	         if (dirty.equals(XManager._XML_YES) )
	        		con.setDirty(true);
	        	else
	        		con.setDirty(false);
	        		
	        	//shijian 2001-1-15
	        	// create EglishCard instance here!!!!!!
	        	Element englishEle=getDoc().getElementById(englishCardID.trim());
	        	
	        	if (!(ConceptType.isActionType(conType))){
	        		//conType.equals(ConceptType.getDefaultActionType()))){
	        		XEnglishNoun xEn = new XEnglishNoun(getDoc());
	        		EnglishNoun engN =xEn.eleToEnglishNoun(englishEle);
	        		con.setCard(DmConcept._ENGLISH,engN);
	        		XManager.getDmManager().addEnglishN(engN);
	        	} else {
//	        		NamedNodeMap attributes = englishEle 
	        		String past= englishEle.getAttribute(XDmTag.getPastT());
	        			//System.out.println("past tag content: "+"\"" + past+"\"");
	        		if (past == null || past.equals("")){
	        			XEnglishVerb xEn = new XEnglishVerb(getDoc());
	        			EnglishVerb engV = xEn.eleToEnglishVerb(englishEle);
	        			con.setCard(DmConcept._ENGLISH,engV);
	        			XManager.getDmManager().addEnglishV(engV);
	        		//	System.out.println("english verb: "+engV.getName()
	        		//		+ " Spelling: " + engV.getSpelling());

	        		} else {
	        			XIrregularVerb xEn = new XIrregularVerb(getDoc());
	        			IrregularVerb engV = xEn.eleToIrregularVerb(englishEle);
	        			con.setCard(DmConcept._ENGLISH,engV);
	        			XManager.getDmManager().addEnglishV(engV);
	        		}
	        		
	        	}
	        		
	         	if (conNote != null){
	         		conNote= XMLUtility.checkAndConvertForEntities(conNote);
	         		con.setNote(conNote);
	         	}
	 	         
			}
			catch (Exception e)
			{
				System.err.println("Exception In XConcept.eleToCon() "+ e);
			}
			
		}
		return con;
	}//eleToCon()
  	
  	/** 
  	* add(), add an concept element to the doc. it 
  	* first try to add before the first Entity element, 
  	* if no Entity elements present, then try to add before 
  	* the first Action element, otherwise, simply append to 
  	* the Domain_model's children list. If Domain_model element
  	* is not present, the element is not added.
  	*/
  	public boolean add(Element ele){
		if (getDoc() == null || ele == null) return false;
		if (!(XManager.insertBEntity(getDoc(), ele)))
			if (!(XManager.insertBAction(getDoc(), ele)))
				if (!(XManager.append(getDoc(), ele))) return false;
	 	return true;
  	}//add()
  	
  	/** remove(), remove an element from Domain_model's chidren 
  	* list if it exists. 
  	*/
  	public void remove(String iD){
		if (doc == null || iD == null) return;
		try {
	      //get the Domain_model element.
	      Element theE = doc.getElementById(iD);
	    	if (theE != null)
	    	{	
	         theE.getParentNode().removeChild(theE);
	    	}
		}
		catch (Exception e)
		{
			System.err.println(e);
		}
  		
  	}//remove()
  	
  	
  	

  	/**
  	* Main program entry point. 
  	*/
  public static void main(String argv[]) 
  {
    if (argv.length == 0)
    {
      System.out.println("Usage:  java domOne uri");
      System.out.println("   where uri is the URI of the XML document you want to print.");
      System.out.println("   Sample:  java domOne sonnet.xml");
      System.exit(1);
    }

    XConcept d1 = new XConcept(XManager.parse(argv[0]));
    DmConcept dia = new DmConcept("dialog", "entity type");
    DmConcept win = new DmConcept("window", "entity type");
	win.setNote("this is a test for adding concept with DOM");
    
  	dia.setParent(win);

  //	XManager.insertBAction(d1.getDoc(),d1.conToEle(win));
  //	XManager.insertBEntity(d1.getDoc(),d1.conToEle(dia));
  	d1.add(d1.conToEle(win));
  	d1.add(d1.conToEle(dia));
  	
  	Element c1 = d1.getDoc().getElementById("dmC1");
  	if (c1 == null) System.out.println("no element");
  	XManager.remove(d1.getDoc(),"dmC1");
  	if (d1.eleToCon(c1) == null) System.out.println("no concept");
  	XManager.insertBEntity(d1.getDoc(),d1.conToEle(d1.eleToCon(c1)));

  	XManager.printDOMTree(d1.getDoc());

  }
}