/*
 * (C) Copyright IBM Corp. 1999  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package com.ibm.xml.parsers;

import java.io.IOException;

import org.xml.sax.*;

/**
 * Non-validating SAX Parser.
 *
 * SAXParser exists to provide backwards compatibility with XML4J V2.0
 *
 * @deprecated The W3C's DOM L3 working group will specify a standardized API for
 *             parser instantiation.  XML4J and Xerces will switch to this API
 *             when it becomes available
 *
 * @version Revision: %M% %I% %W% %Q%
 */
public class SAXParser implements Parser {

    //
    // Data
    //

    protected org.apache.xerces.parsers.SAXParser fParser = null;

    //
    // Constructors
    //

    /** Default constructor. */
    public SAXParser() {
        fParser = new org.apache.xerces.parsers.SAXParser();
        try{
            fParser.setFeature( "http://xml.org/sax/features/namespaces", false );
        }catch( SAXNotRecognizedException e ){ 
        }catch( SAXNotSupportedException  e ){ 
        }
    }

    //
    // Parser methods
    //

    /** Sets the entity resolver. */
    public void setEntityResolver(EntityResolver resolver) {
        fParser.setEntityResolver(resolver);
    }

    /** Sets the DTD handler. */
    public void setDTDHandler(DTDHandler handler) {
        fParser.setDTDHandler(handler);
    }

    /** Sets the document handler. */
    public void setDocumentHandler(DocumentHandler handler) {
        fParser.setDocumentHandler(handler);
    }

    /** Sets the error handler */
    public void setErrorHandler(ErrorHandler handler) {
        fParser.setErrorHandler(handler);
    }
    
    /** Sets the locale */
    public void setLocale(java.util.Locale locale) throws SAXException {
        fParser.setLocale(locale);
    }


    //
    // XMLDocumentTypeHandler interface
    //

    /**
     * This function will be called when a &lt;!DOCTYPE...&gt; declaration is
     * encountered.
     */
    public void doctypeDecl(int rootElementNameIndex) throws Exception {}

    /**
     * This function will be called at the start of the "internal subset" of a
     * doctype declaration.
     */
    public void startInternalSubset() throws Exception {}

    /**
     * This function will be called at the end of the "internal subset" of a
     * doctype declaration.
     */
    public void endInternalSubset() throws Exception {}

    /**
     * This function will be called at the start of the "external subset" of a
     * doctype declaration.
     */
    public void startExternalSubset(int publicIdStringIndex, int systemIdStringIndex) throws Exception {}

    /**
     * This function will be called at the end of the "external subset" of a
     * doctype declaration.
     */
    public void endExternalSubset() throws Exception {}

    /** Element decl. */
    public void elementDecl(int elementIndex) throws Exception {}

    /** Attlist decl. */
    public void attlistDecl(int elementIndex, int attDefIndex) throws Exception {}

    /** Internal entity decl. */
    public void internalEntityDecl(int entityIndex) throws Exception {}

    /** External entity decl. */
    public void externalEntityDecl(int entityIndex) throws Exception {}

    /** Unparsed entity decl. */
    public void unparsedEntityDecl(int entityIndex) throws Exception {
    }
    
    // REVISIT: Workaround for TX: getParameterEntityEnumeration
    public void parameterEntityDecl(int entityIndex) {
    }

    /** Notation decl. */
    public void notationDecl(int notationIndex) throws Exception {
    }

    //
    // XMLDocumentHandler interface
    //

    /** Send char data as array. */
    public boolean sendCharDataAsCharArray() {
        return true;
    }

    /** Start document. */
    public void startDocument(int versionIndex,
                              int encodingIndex,
                              int standAloneIndex)
        throws Exception {
    }

    /** End document. */
    public void endDocument() throws Exception {
    }

    /** Start element */
    public void startElement(int elementNameIndex, int attrListIndex)
        throws Exception {
    }

    /** End element. */
    public void endElement(int elementNameIndex) throws Exception {
    }

    /** Start entity reference. */
    public void startEntityReference(int entityIndex) throws Exception {}

    /** End entity reference. */
    public void endEntityReference(int entityIndex) throws Exception {}

    /** Not called. */
    public void characters(int dataIndex, boolean cdataSection) throws Exception {}

    /** Not called. */
    public void ignorableWhitespace(int dataIndex, boolean cdataSection) throws Exception {}

    /** Processing instruction. */
    public void processingInstruction(int targetIndex, int dataIndex) throws Exception {
    }

    /** Comment. */
    public void comment(int dataIndex) throws Exception {
    }

    /** Characters. */
    public void characters(char ch[], int start, int length, boolean cdataSection) throws Exception {
    }

    /** Ignorable whitespace. */
    public void ignorableWhitespace(char ch[], int start, int length, boolean cdataSection) throws Exception {
    }

    //
    // XMLParser methods
    //

    /**
     * Parses the specified input source.
     *
     * @param source The input source.
     *
     * @exception org.xml.sax.SAXException Throws exception on SAX error.
     * @exception java.io.IOException Throws exception on i/o error.
     */
    public void parse(InputSource source) throws SAXException, IOException {
        fParser.parse(source);
    } 

    /**
     * Parses the input source specified by the given system identifier.
     * <p>
     * This method is equivalent to the following:
     * <pre>
     *     parse(new InputSource(systemId));
     * </pre>
     *
     * @param source The input source.
     *
     * @exception org.xml.sax.SAXException Throws exception on SAX error.
     * @exception java.io.IOException Throws exception on i/o error.
     */
    public void parse(String systemId) throws SAXException, IOException {
        fParser.parse(systemId);
    }

    public void reset() throws Exception {
        fParser.reset();
    }


    /**
     * Return the <code>Locator</code> object.
     *
     * @return The locator.
     */
    protected org.xml.sax.Locator getLocator() {
        return fParser.getLocator();
    }
    /**
     *
     */
    public void setAllowJavaEncodingName(boolean flag) {
        setFeature("http://apache.org/xml/features/allow-java-encodings", flag);
    }
    /**
     *
     */
    public boolean getAllowJavaEncodingName() {
        return getFeature("http://apache.org/xml/features/allow-java-encodings");
    }
    /**
     *
     */
    public void setWarningOnDuplicateAttDef(boolean flag) {
        setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", flag);
    }
    /**
     *
     */
    public boolean getWarningOnDuplicateAttDef() {
        return getFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef");
    }
    /**
     *
     */
    public void setCheckNamespace(boolean flag) {
        setFeature("http://xml.org/sax/features/namespaces", flag);
    }
    /**
     *
     */
    public boolean getCheckNamespace() {
        return getFeature("http://xml.org/sax/features/namespaces");
    }
    /**
     *
     */
    public void setContinueAfterFatalError(boolean flag) {
        setFeature("http://apache.org/xml/features/continue-after-fatal-error", flag);
    }
    /**
     *
     */
    public boolean getContinueAfterFatalError() {
        return getFeature("http://apache.org/xml/features/continue-after-fatal-error");
    }

    private void setFeature(String name, boolean value) {
        try {
            fParser.setFeature(name, value);
        } catch (SAXException se) {
            se.printStackTrace();
        }
    }

    private boolean getFeature(String name) {
        boolean flag = false;
        try {
            return fParser.getFeature(name);
        } catch (SAXException se) {
            se.printStackTrace();
        }
        return flag;
    }
}
