/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

/* A child of javax.swing.text.html.HTMLEditorKit, patched to use
   PatchedStyleSheet rather than javax.swing.text.html.StyleSheet.

   kvlinden, 10Feb00
*/

package TV;

import javax.swing.text.html.*;
import javax.swing.text.*;
import java.io.*;

public class PatchedHTMLEditorKit extends HTMLEditorKit {

    /* This is changed to associate a PatchedStyleSheet with the 
       default document, rather than a StyleSheet. - kvlinden, 10feb00
    */
    public Document createDefaultDocument() {
	PatchedStyleSheet styles = (PatchedStyleSheet)getStyleSheet();
	// PENDING(prinz) We should be cloning the
	// sheet so the document can add it's own
	// styles to it.  Since clone isn't yet implemented
	// and the document doesn't yet install styles
	// this works temporarily.

	HTMLDocument doc = new HTMLDocument(styles);
	doc.setAsynchronousLoadPriority(4);
	doc.setTokenThreshold(100);
	return doc;
    }

    /* We can't use defaultStyles from HTMLEditorKit because it
       is declared as private, not protected.  It doesn't matter
       though, we just load the default isolde.css rules and return
       them; this basically ignores the value of defaultStyles in
       the parent class.  - kvlinden, 10Feb00
    */
    public StyleSheet getStyleSheet() {
	PatchedStyleSheet defaultStyles = new PatchedStyleSheet();
	try {
	    InputStream is;

	    //PENDING(prinz): Use new security model
	    is = PatchedHTMLEditorKit.class.getResourceAsStream("isolde.css");

	    Reader r = new BufferedReader(new InputStreamReader(is));
	    defaultStyles.loadRules(r, null);
	    r.close();
	} catch (Throwable e) {
	    // on error we simply have no styles... the html
	    // will look mighty wrong but still function.
	}
	return defaultStyles;
    }
}
