//Source file: D:/Projects/Isolde/parser/Transition.java

package FSParser;

import java.util.Vector;

public class Transition 
{
    private int _source;         // source state of the arc
    private int _destination;    // destination/target state of the arc
    private String _guard;       // condition placed on following the arc
    private Vector _operations;  // list of operations to perform when following the arc

    // operation codes:
    public static final int UNDERFLOW = 0;         // an underflow for the enumerated type
    public static final int INCREMENT_CURRENT = 1; // increment the current parse string index
    public static final int START_EQ_CURRENT = 2;  // set constituent start = current index
    public static final int START_EQ_WORKING = 3;  // set constituent start = working index
    public static final int WORKING_EQ_START = 4;  // set working index = constituent start index
    public static final int HEAD_EQ_CURRENT = 5;   // mark current word as constituent head
    public static final int END_EQ_CURRENT_MINUS_1 = 6;  // set constituent end position
    //       (also sets length and DM name)
    public static final int OVERFLOW = 7;          // an overflow for the enumerated type

    public Transition(int inSource, int inDestination, String inGuard) 
    {
	_source = inSource;
	_destination = inDestination;
	_guard = inGuard;
	_operations = new Vector();   // these will be added with addOperation()
    }

    public void addOperation(int inOpCode)
    {
 	if (inOpCode <= UNDERFLOW)
 	    System.out.println("Transition operation underflow for code: " + inOpCode);
 	else if (inOpCode >= OVERFLOW)
 	    System.out.println("Transition operation overflow for code: " + inOpCode);
 	else
	    _operations.add(new Integer(inOpCode));
	return;
    }

    public int source()
    {
	return _source;
    }

    public int destination()
    {
	return _destination;
    }

    public String guard()
    {
	return _guard;
    }

    public Vector operations()
    {
	return _operations;
    }
}
