//Source file: D:/Projects/Isolde/parser/Grammar.java

package FSParser;

import java.util.Vector;

public class Grammar 
{
    private Vector states;         // list of states in the grammar
    private Vector transitions;    // list of transitions in the grammar
    private int startState;        // index of the start state of the grammar
    private int currentState;      // index of the current state of the grammar
   
    public Grammar() 
    {
	states = new Vector();
	transitions = new Vector();
	load();
	initialize();
    }
   
    /**
       Sets the current state of the grammar to the start state.
       @roseuid 3959F8AA01B4
    */
    public void initialize() 
    {
	currentState = startState;
    }
   
    /**
       Returns true if the grammar is currently in a final state.
       @roseuid 3959F8B0004A
    */
    public boolean inTerminalState() 
    {
	return ((State)(states.elementAt(currentState))).terminal();
    }
   
    /**
       Loads the grammar from an ascii file
       @roseuid 3959FDC90119
    */
    public void load() 
    {
	Transition aTransition;

	// Just hard code this for now.
	states.add(new State("start", false, false));
	startState = 0;
	states.add(new State("agent", false, true));       
	states.add(new State("process", true, true));      
	states.add(new State("patient", true, true));      
	states.add(new State("instrument", true, true));   
	states.add(new State("source", true, true));   
	states.add(new State("destination", true, true));   
	states.add(new State("location", true, true));   

	aTransition = new Transition(indexOf("start"), indexOf("agent"), "noun");
	aTransition.addOperation(Transition.START_EQ_WORKING);
	aTransition.addOperation(Transition.HEAD_EQ_CURRENT);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("start"), indexOf("process"), "verb");
	aTransition.addOperation(Transition.START_EQ_WORKING);
	aTransition.addOperation(Transition.HEAD_EQ_CURRENT);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("agent"), indexOf("process"), "verb");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.HEAD_EQ_CURRENT);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("process"), indexOf("patient"), "noun");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.HEAD_EQ_CURRENT);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("process"), indexOf("instrument"), "\"using\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("process"), indexOf("location"), "\"at\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("process"), indexOf("source"), "\"from\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("process"), indexOf("destination"), "\"to\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("patient"), indexOf("instrument"), "\"using\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("patient"), indexOf("location"), "\"at\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("patient"), indexOf("source"), "\"from\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("patient"), indexOf("destination"), "\"to\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("instrument"), indexOf("location"), "\"at\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("instrument"), indexOf("source"), "\"from\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("instrument"), indexOf("destination"), "\"to\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("location"), indexOf("instrument"), "\"using\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("location"), indexOf("source"), "\"from\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("location"), indexOf("destination"), "\"to\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("source"), indexOf("instrument"), "\"using\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("source"), indexOf("location"), "\"at\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("source"), indexOf("destination"), "\"to\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("destination"), indexOf("instrument"), "\"using\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("destination"), indexOf("location"), "\"at\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("destination"), indexOf("source"), "\"from\"");
	aTransition.addOperation(Transition.END_EQ_CURRENT_MINUS_1);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("start"), indexOf("agent"), "unknown");
	aTransition.addOperation(Transition.START_EQ_WORKING);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("instrument"), indexOf("instrument"), "noun");
	aTransition.addOperation(Transition.START_EQ_WORKING);
	aTransition.addOperation(Transition.HEAD_EQ_CURRENT);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("location"), indexOf("location"), "noun");
	aTransition.addOperation(Transition.START_EQ_WORKING);
	aTransition.addOperation(Transition.HEAD_EQ_CURRENT);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("source"), indexOf("source"), "noun");
	aTransition.addOperation(Transition.START_EQ_WORKING);
	aTransition.addOperation(Transition.HEAD_EQ_CURRENT);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("destination"), indexOf("destination"), "noun");
	aTransition.addOperation(Transition.START_EQ_CURRENT);
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	aTransition.addOperation(Transition.WORKING_EQ_START);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("agent"), indexOf("agent"), "unknown");
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("process"), indexOf("process"), "unknown");
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("patient"), indexOf("patient"), "unknown");
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("instrument"), indexOf("instrument"), "unknown");
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("location"), indexOf("location"), "unknown");
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("source"), indexOf("source"), "unknown");
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	transitions.add(aTransition);
	aTransition = new Transition(indexOf("destination"), indexOf("destination"), "unknown");
	aTransition.addOperation(Transition.INCREMENT_CURRENT);
	transitions.add(aTransition);

	return;
    }
   
    // Utility function that returns the index of a state with the name stateName.
    private int indexOf(String stateName)
    {
	for (int i = 0; i < states.size(); i++)
	    if (stateName == ((State)states.elementAt(i)).name())
		return i;
	System.out.println("Warning (Grammar.java): No state exists for given name: " + stateName);
	return -1;
    }

    // Utility function that returns the name of a state with the index stateIndex.
    //     This one just calls name(), but it does error checking as well.
    private String nameOf(int stateIndex)
    {
	if ((stateIndex < states.size()) && (stateIndex >= 0))
	    return ((State)(states.elementAt(stateIndex))).name();
 	System.out.println("Warning: No state exists for given name: " + stateIndex);
	return "";
    }

    /**
       returns a vector of the names of the States that are designated as "official" 
       CNL constituents.
       @roseuid 395A0D8A0096
    */
    public Vector constituents() 
    {
	Vector constituentsList = new Vector();
	for (int i = 0; i < states.size(); i++)
	    if (((State)(states.elementAt(i))).constituent())
		constituentsList.add(((State)(states.elementAt(i))).name());
	return constituentsList;
    }
   
    /**
       returns a vector of strings identifying the possible transitions, not counting UNKNOWN.
       @roseuid 395A196A00DE
    */
    public Vector possibleTransitions() 
    {
	Vector transitionList = new Vector();
	for (int i = 0; i < transitions.size(); i++)
	    if (((Transition)(transitions.elementAt(i))).source() == currentState)
		transitionList.add(((Transition)(transitions.elementAt(i))).guard());
	return transitionList;
    }
   
    /**
       Moves the grammar to the state pointed to by the transition with guardName as its guard.
       Returns the operations associated with the transition that is followed so that the parser
       can execute them.
       @roseuid 395A1E94025B
    */
    public Vector transition(String guardName) 
    {
	for (int i = 0; i < transitions.size(); i++)
	    if ((((Transition)(transitions.elementAt(i))).source() == currentState) && 
		(((Transition)(transitions.elementAt(i))).guard() == guardName))
		{
		    currentState = ((Transition)(transitions.elementAt(i))).destination();
		    return ((Transition)(transitions.elementAt(i))).operations();
		}
	System.out.println("Warning: Invalid transition from state: " + nameOf(currentState)
			   + " using guard: " + guardName);
	return null;
    }
   
    public String getCurrentState()
    {
	return ((State)(states.elementAt(currentState))).name();
    }

}
