/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package utility;


import java.util.*;

/* StringSortTest.java
* testing the generic sorting ArrayList
*/
public class StringSortTest2 {
	static class StringCompare implements Compare {
		public boolean lessThan (Object l, Object r){
			return ((String)l).toLowerCase().compareTo(
			((String) r).toLowerCase()) <0;
			
		}//lessThan()
		
		public boolean lessThanOrEqual (Object l, Object r){
			return ((String)l).toLowerCase().compareTo(
			((String) r).toLowerCase()) <= 0;
			
		}//lessThanOrEqual()
		
	}// inner class StringCompare
	
	public static void main (String[] args){
		SortArrayList sv = new SortArrayList (new StringCompare());
		sv.add("d");
		sv.add("A");
		sv.add("C");
		sv.add("b");
		sv.add("B");
		sv.add("D");
		sv.add("A");
		sv.add("d");
		sv.sort();
		Iterator it = sv.iterator();
		while (it.hasNext())
			System.out.println(it.next());
	}//main()


}//class StringSortTest