/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package utility;

import java.util.*;


/* StringSortTest.java
* testing the generic sorting vector
*/
public class Sentence {

	private String _sen;
	
	public Sentence(String sen){
		_sen= sen;
		
	}
	
	
	//get the last word from the sentence name
	public String getLastWord() {
		StringTokenizer stk = new StringTokenizer(_sen);
		String head="";		
		while (stk.hasMoreTokens())
			head =stk.nextToken() ;
			
		return head;
	}
	
	//get the last word from the sentence name
	public int getWordCount() {
		StringTokenizer stk = new StringTokenizer(_sen);
		return stk.countTokens();
	}
		
	//get the last word from the sentence name
	public String getAllWordsButLast() {
		StringBuffer stbPre = new StringBuffer(_sen);
		int length = _sen.length();
		int lastIndexStart = _sen.lastIndexOf(getLastWord(),length);		
		stbPre.delete(lastIndexStart,length);
		return stbPre.toString();
	}
	
	//
	public boolean contains(String word) {
		StringTokenizer stk = new StringTokenizer(_sen);
		String temp;		
		while (stk.hasMoreTokens()){
			temp= stk.nextToken();
			if (temp.startsWith(word) || temp.endsWith(word))
				return true;
		}	
		return false;
	}
	
	//get all words before word
	public String getAllWordsBefore(String word) {
		StringBuffer stbPre = new StringBuffer(_sen);
		int length = _sen.length();
		int wordIndexStart = _sen.lastIndexOf(word,length);		
		stbPre.delete(wordIndexStart,length);
		return stbPre.toString().trim();
	}
	
	//get all words after word
	public String getAllWordsAfter(String word) {
		StringBuffer stbPre = new StringBuffer(_sen);
		int length = _sen.length();
		int wordIndexStart = _sen.lastIndexOf(word,length);		
		stbPre.delete(0,wordIndexStart+ word.length());
		return stbPre.toString().trim();
	}
	
	public static void main (String[] args){
		Sentence test = new Sentence("sdf test, nothing else ");
		
		if (test.contains("test")){
			System.out.println("success");
			System.out.println("words before = "+"\""+
				test.getAllWordsBefore("test")+"\"");
			System.out.println("words after = "+"\""+
				test.getAllWordsAfter("test")+ "\"");
		}
		else
			System.out.println("failer");
		
		
	}//main()


}//class StringSortTest