/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package utility;

import java.io.File;


public class LISPUtility {

    private static String DOUBLEQUOTE_SIGN = "\"";        
    private static String OPENBRACKET_SIGN = "(";      
    private static String CLOSEBRACKET_SIGN = ")";           
    private static String DOT_SIGN = ".";      
    private static String APOSTROPHE_SIGN = "'";  
    private static String COMA_SIGN = ",";  
   
    private static String DOUBLEQUOTE = "-double-quote-";        
    private static String OPENBRACKET = "-open-bracket-";      
    private static String CLOSEBRACKET = "-close-bracket-";           
    private static String DOT = "-dot-";      
    private static String APOSTROPHE = "-apostrophe-";   
    private static String COMA = "-coma-";  

    public static String replaceSigns(String ss) {
        String result = ss;
        
        result = replaceSign(result,DOUBLEQUOTE_SIGN,DOUBLEQUOTE);
        result = replaceSign(result,OPENBRACKET_SIGN,OPENBRACKET);
        result = replaceSign(result,CLOSEBRACKET_SIGN,CLOSEBRACKET);
        result = replaceSign(result,DOT_SIGN,DOT);
        result = replaceSign(result,APOSTROPHE_SIGN,APOSTROPHE);
        result = replaceSign(result,COMA_SIGN,COMA);
        
        return result;
    }
    
    public static String replaceSign(String ss,String specialCharString,String substitute) {
        char specialChar = specialCharString.charAt(0);
        char tmpChar;
        StringBuffer sbuf = new StringBuffer();
        
        for (int i=0; i<ss.length(); i++) {
            tmpChar = ss.charAt(i);
            
            if (tmpChar == specialChar)
                sbuf.append(substitute);
            else
                sbuf.append(tmpChar);
        }
        
        String result = sbuf.toString();
        
        
        return result;
        
    }
    
    public static String replaceDoubleQuotes(String ss) {
        return replaceSign(ss,DOUBLEQUOTE_SIGN,DOUBLEQUOTE);
    }
    public static String replaceComas(String ss) {
        return replaceSign(ss,COMA_SIGN,COMA);
    }
}