/**
 *  Tamot --- Task Modelling Editor
 *  Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
 *  (CSIRO), Australia. All rights reserved. 
 *
 *  The Software, owned by CSIRO Australia, habeen developed by the CSIRO 
 *  Intelligent Interactive Technology group. s 
 *  For more information, please see http://www.cmis.csiro.au/iit/.
 *
 *  The Software is a beta-test version for internal research and evaluation purposes 
 *  by the Licensee. The Software is still at a development stage. 
 *  It has not undergone complete testing and may have inherent errors,
 *  bugs or deficiencies that can affect the operation of the Software. 
 *
 *  We encourage your feedback and suggestions. Any bugs / suggestions found please email to
 *  Shijian.Lu@cmis.csiro.au. 
 *
 *  After you have signed the Beta-Test Software License Agreement with the CSIRO,
 *  CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
 *  personal, non-commercial and lawful end use. Implied licenses are negated. 
 *
 *  Warranty Disclaimer : 
 *
 *  CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
 *  the Software by the Licensee will not infringe any third partys 
 *  Intellectual Property Rights nor that the Software will be of merchantable quality,
 *  or suitable for a particular purpose. CSIRO excludes all terms, conditions and
 *  warranties implied by custom, the general law or statute in relation to the
 *  Software.
*/

package tmrose;

import java.util.*;
import rose.*;
import rosetm.*;
import tmrose.*;
import domainModel.*;
import taskModellingTool.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * class UseCaseDiagramTM is a wrapper class for RoseClassDiagram generated by 
 * using J-Integra. (See  <A HREF="http://www.linar.com/">http://www.linar.com/</A><P>)
 * The aim of this class is to provide customised functionality for create 
 * usecase diagrams, 20-11-2001
*/

public class LoginDialog //extends JDialog
{
	//graphical components
  	JLabel 	_domainL = new JLabel("Domain");
	JLabel 	_userNameL = new JLabel("User Name");
	JLabel 	_passwordL = new JLabel("Password");
	JTextField _domainT = new JTextField();
  	JTextField _userNameT = new JTextField();
  	JPasswordField _passwordT = new JPasswordField();
  	JButton _okButton = new JButton("OK");
  	JButton _cancelButton = new JButton("Cancel");
  	
  	//internal variables
  	String 	_domain = "CMIS", _userName = null,_password=null;
  	
	private JOptionPane  _pane ;
	private Frame  _parent = null; //default parent
	private JDialog _dmDialog;
  	private String 	_title = "Please Login";

  	//Construct the dialog
	public LoginDialog() {
		this(null,"Please Login");  	
	}

	//Construct the dialog
  	public LoginDialog(Frame owner, String t) {
  		super();
  		//if (owner != null);
  		_parent= owner;
  		_title = t;
	  	initialize();
  	}
  	
  	public void initialize() {
  		_userName = System.getProperty("user.name");
		_pane= new JOptionPane(getAllPanel(), JOptionPane.PLAIN_MESSAGE, 
			JOptionPane.OK_CANCEL_OPTION);
    	
	   	_dmDialog = _pane.createDialog(_parent, _title);
		_dmDialog.show();
	   //_dmDialog.setResizable(false);
		onButtonPress();
  		  		
  	}
  	
  	/**
  	* getAllPanel
  	*
  	* add graphical components to the dialog box
  	*
  	*/
  	public JPanel getAllPanel(){
  		JPanel contentPane = new JPanel();
    	contentPane.setLayout(new BorderLayout());
		contentPane.add(getTextFields(),BorderLayout.CENTER);
  		
		return contentPane;
  	}
  	  	
  	/**
  	* getTextFields
  	*
  	* @return    return value.  JPanel which contains  
   	*  the domain, user-name, and password panels
  	*
  	*/
  	public JPanel getTextFields(){
    	
    	JPanel aPanel = new JPanel();
    	aPanel.setLayout(new GridLayout(3,1));
    	aPanel.add(getLabelTextFieldPanel(_userNameL, 
    		_userNameT, _userName));
    	aPanel.add(getLabelTextFieldPanel(_passwordL, 
    		_passwordT, null));
    	aPanel.add(getLabelTextFieldPanel(_domainL, 
    		_domainT, _domain));
    	return aPanel;

  	}
  	
  	/**
  	* getLabelTextFieldPanel
  	*
    * @param     l (in); the JLabel to be added to the JPanel.
    * @param     t (in); the JTextField to be added to the JPanel
  	* @return    return value.  JPanel which contains  
   	*  the label and textfield
  	*
  	*/
  	public JPanel getLabelTextFieldPanel(JLabel l, JTextField t, String content){
    	
    	JPanel aPanel = new JPanel();
    	//aPanel.setLayout(new BorderLayout());
    	aPanel.setLayout(new GridLayout(1,2));
    	
    	if ((content != null) && !(content.equals("")))
    		t.setText(content);
     	t.setSize(new Dimension(150, 25));
	   	aPanel.add(l);
    	aPanel.add(t);
    	return aPanel;

  	}
  
  	/**
  	* onButtonPress
  	*
  	* display the dialog-box
  	*/
  	public void onButtonPress(){
  		if (oKButtonPressed(_pane)){
  			_userName = _userNameT.getText().trim();
  			_password = _passwordT.getText().trim();
  			_domain = _domainT.getText().trim();
  		}
     	//setSize(new Dimension(300, 150));
	    //setVisible(true);
	    //requestFocus();
  	}
    
    private boolean oKButtonPressed(JOptionPane pane) {
        boolean result = false;
        
        Object selectedValue = pane.getValue();
        if (selectedValue != null && selectedValue != JOptionPane.UNINITIALIZED_VALUE) {
            if (selectedValue instanceof Integer){
                Integer sv = (Integer)selectedValue;
                if(sv.intValue()  == JOptionPane.OK_OPTION) {
                    result = true;
                }
            }
        }
        
        return result;
    }
  	
  	/**
  	* getDomian
  	*
  	* @return    return value.  domain name  
  	*/
  	public String getDomain(){
		return _domain;
  	}
  	
  	/**
  	* getUserName
  	*
  	* @return    return value.  user name  
  	*/
  	public String getUserName(){
		return _userName;
  	}
    
  	
  	/**
  	* getPassword
  	*
  	* @return    return value.  getPassword  
  	*/
  	public String getPassword(){
		return _password;
  	}
    
    
    public static void main(String[] args) {

		LoginDialog ld = new LoginDialog(); 
	}
    
}