/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.awt.*;
import java.awt.event.*;

import java.util.*;
import java.io.*;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.text.rtf.*;
import javax.swing.text.html.*;
import javax.swing.event.*;
import javax.swing.undo.*;

import java.awt.datatransfer.*;
import java.awt.dnd.*;

class TextPaneTarget implements DropTargetListener{

    JTextPane textPane;   

    public TextPaneTarget(JTextPane pane) {
       textPane = pane;
    }
    public void dragEnter(DropTargetDragEvent e) {
        e.acceptDrag(DnDConstants.ACTION_COPY);
    }

    public void dragOver(DropTargetDragEvent e) {
        e.acceptDrag(DnDConstants.ACTION_COPY);
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
        DropTargetContext targetContext = e.getDropTargetContext();

        boolean outcome = false;

        if ((e.getSourceActions() & DnDConstants.ACTION_COPY) != 0)
            e.acceptDrop(DnDConstants.ACTION_COPY);
        else {
            e.rejectDrop();
            return;
        }
        
    	FileManager.MODIFIED=true;     	

        DataFlavor [] dataFlavors=e.getCurrentDataFlavors();
        DataFlavor transferDataFlavor=null;

        for (int i = 0; i < dataFlavors.length; i++) {
            System.out.println(dataFlavors[i].getMimeType());
            String s=dataFlavors[i].getSubType();
            System.out.println(s);
            if (s.equals("enriched")) {
                System.err.println("matched");
                transferDataFlavor = dataFlavors[i];
                break;
            }
        }

        if (transferDataFlavor != null) {
            Transferable t  = e.getTransferable();
            InputStream  is = null;

            try {
                System.err.println("get stream");
                is = (InputStream)t.getTransferData(transferDataFlavor);
                System.err.println("stream ok");
            } catch (IOException ioe) {
                ioe.printStackTrace();
                System.err.println(ioe.getMessage());
                targetContext.dropComplete(false);

                return;
            } catch (UnsupportedFlavorException ufe) {
                ufe.printStackTrace();
                System.err.println(ufe.getMessage());
                targetContext.dropComplete(false);

                return;
            }

            if (is != null) {
                try {
                    BufferedInputStream bis=new BufferedInputStream(is);
                    int pos=textPane.getCaretPosition();
                    DefaultStyledDocument doc=(DefaultStyledDocument)textPane.getStyledDocument();
                    EditorKit ed=textPane.getEditorKit();
                    ed.read(bis,doc,0);

                    outcome = true;
                } catch (Exception ex) {
                    ex.printStackTrace();
                    System.err.println(ex.getMessage());
                    targetContext.dropComplete(false);
                    return;
                }
            } else
                outcome = false;
        }

        targetContext.dropComplete(outcome);
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
        System.err.println("[Target] dropActionChanged");
    }
}
