/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import javax.swing.tree.*;
import java.util.Vector;

import domainModel.*;

//tape_recorder
public class TapeRecorder_TM_Manager {
    
  protected static boolean guiEnableFlag;

  // Assume this as the name of the TR's root task.  This is hard-coded
  // in the Rose-script and is assumed by the TR itself - kvlinden,22jan2001
  protected static String rootName = "TM_ROOT_TM";
    
  protected static MainFrame frame;                   // with GUI interface
    
  protected static TapeRecorder_MainFrame tr_frame;   // without GUI interface
    

  public TapeRecorder_TM_Manager(boolean guiEnableFlag) {
    this.guiEnableFlag = guiEnableFlag;
        
    if (guiEnableFlag) {
      Banner banner=new Banner();
            
      banner.setVisible(true);
            
      frame = new MainFrame();
            
      MainFrame.TITLE_FIXED = "Tape Recorder - ";
            
      banner.dispose();
            
      frame.setVisible(true);
    }
    else {
      tr_frame = new TapeRecorder_MainFrame();
    }
  }
    
  // The tape recorder needs access to the domain model - kvlinden, 22jan2001
  public static DmManager getDmManager() {
    return tr_frame.getDmManager();
  }

  public static void newTask(String childName,String semantics) {
    NewManager.newTask(childName,semantics);
  }

  public static void newTask(String parentName,String childName,String semantics) {
    //    System.out.println("creating task: " + childName + " with parent: " + parentName + " and semantics: " + semantics);
    if (parentName.equals(rootName))
      NewManager.newTask(childName,semantics);
    else
      NewManager.newTask(parentName,childName,semantics);
  }

  public static void deleteGenericComponent(String parentName,String childName) {
      if (parentName.equals(rootName))
          parentName = Manager.skeleton.ROOT_STRING;
            
      DeleteManager.deleteGenericComponent(childName,parentName);
  }
    
  public static String newBooleanConnectorAND(String parentName) {
    return (newBooleanConnector(parentName,"AND"));
  }
    
  public static String newBooleanConnectorOR(String parentName) {
    return (newBooleanConnector(parentName,"OR"));
  }
    
  public static String newBooleanConnectorXOR(String parentName) {
    return (newBooleanConnector(parentName,"XOR"));
  }
    
  private static String newBooleanConnector(String parentName,String type) {
    //    System.out.println("creating boolean " + type + " connector with parent: " + parentName);
    if (parentName.equals(rootName)) {
      Manager.tree.setSelectionRow(0);                    // point to the root
    }
    else {
      TreePath treePath = Manager.fetchTreePath(parentName,Manager.tree);
      Manager.tree.setSelectionPath(treePath);
    }
        
    BooleanConnector bc = NewManager.newBooleanConnector(type);
        
    return (bc.name);
  }
    
  public static void newLink(String fromTaskName,String toTaskName,String parentTaskName) {
    System.out.println("creating link from " + fromTaskName + " to " + toTaskName + " with parent " + parentTaskName);
        
    if (parentTaskName.equals(rootName))
      parentTaskName = Manager.skeleton.ROOT_STRING;
            
    GenericComponent gc1 = Manager.skeleton.getComponent(fromTaskName,parentTaskName);
    GenericComponent gc2 = Manager.skeleton.getComponent(toTaskName,parentTaskName);
        
    if ((gc1 instanceof LinkableComponent) && (gc2 instanceof LinkableComponent)) {
      LinkableComponent lc1 = (LinkableComponent) gc1;
      LinkableComponent lc2 = (LinkableComponent) gc2;
            
      NewManager.newLink(lc1,lc2,parentTaskName);
    }
  }

  private static String findLink(String fromTaskName,String toTaskName,String parentTaskName) {
    String result = null;
        
    GenericComponent gc1 = Manager.skeleton.getComponent(fromTaskName,parentTaskName);
    GenericComponent gc2 = Manager.skeleton.getComponent(toTaskName,parentTaskName);
        
    if ((gc1 instanceof LinkableComponent) && (gc2 instanceof LinkableComponent)) {
      LinkableComponent lc1 = (LinkableComponent) gc1;
      LinkableComponent lc2 = (LinkableComponent) gc2;
            
      Vector links = lc1.getLinks();
      int size = links.size();
      Link l;
      for (int i=size-1;i>=0;i--) {
	l = (Link)links.elementAt(i);
                
	if ((l.lc1 == lc2) || (l.lc2 == lc2)) {
	  result = l.name;
	  break;
	}
      }
    }
        
    return result;
  }

  public static void deleteLink(String fromTaskName,String toTaskName,String parentTaskName) {
      if (parentTaskName.equals(rootName))
          parentTaskName = Manager.skeleton.ROOT_STRING;
        
      String linkName = findLink(fromTaskName,toTaskName,parentTaskName);
      System.out.println("linkName = "+linkName);
        
      DeleteManager.deleteGenericComponent(linkName,parentTaskName);
  }
    
  public static void saveAs(String fileName) {
    Manager.saveAs(fileName);
  }
    
  public static void saveAs() {
    Manager.saveAs();
  }
    
  public static void readXML(String fileName) {
    Manager.readXML(fileName);
  }
    
  public static void closing() {
    if (!guiEnableFlag) {
      System.exit(0);
    }
  }
  
    
  //brasser 2001-6-18
  public static TapeRecorder_MainFrame getFrame() 
  {
  	return tr_frame;
  }

}