/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   Redistribution in source and binary forms, with or without modification, are not permitted.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

/*
 * TVLinkListener.java
 * A hyperlink listener for use with JEditorPane.  This
 * listener will change the cursor over hotspots based on enter/exit
 * events and also load a new page when a valid hyperlink is clicked.
 */

package taskModellingTool;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.net.URL;


public class TVLinkListener implements HyperlinkListener {

    private TVFrame tvFrame;
    
    private JEditorPane editorPane; // The pane we're using to display HTML

    private JLabel statusBar;       // An option label for showing where
                                    // a link would take you

    public TVLinkListener(TVFrame tvFrame, JEditorPane editorPane, JLabel statusBar) {
        this.tvFrame = tvFrame;
        this.editorPane = editorPane;
        this.statusBar = statusBar;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {

        HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
    
        if (eventType == HyperlinkEvent.EventType.ENTERED) {
            // Enter event.  Go the the "hand" cursor and fill in the status bar
            editorPane.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
            statusBar.setText("click to edit " + hyperlinkEvent.getDescription());
        }
        else if (eventType == HyperlinkEvent.EventType.EXITED) {
            // Exit event.  Go back to the default cursor and clear the status bar
            editorPane.setCursor(Cursor.getDefaultCursor());
            statusBar.setText(" ");
        }
        else {
            // Jump event.  Get the url, and if it's not null, switch to that
            // page in the main editor pane and update the "site url" label.
            //System.out.println(hyperlinkEvent.getDescription());
            
            tvFrame.displayNewUrlPage(hyperlinkEvent.getURL());
            tvFrame.updateButtonStatus();
        }
    }
    
}