/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.reflect.*;
import java.util.*;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;


public class SystemOptions {
    static final String SYSTEM_OPTIONS_FILE="cfg"+File.separator+"sysopts.cfg";

    //protected static boolean domainModelFlag = true;
    protected static boolean domainModelFlag = false;
    
    protected void saveFile() {
        try {
            BufferedWriter fileOut = new BufferedWriter(new FileWriter(SYSTEM_OPTIONS_FILE));            
    
            String ss;
            
            if (domainModelFlag) ss = "T";
            else ss = "F";
            ss = "domainModelFlag : "+ss;
               
            fileOut.write(ss,0,ss.length());
            fileOut.newLine();
           
            fileOut.close();
        }
        catch (Exception e) {
            String err = e.toString();
            System.out.println(err);
        }
    }
    
    protected void readFile() {
        try {
            BufferedReader fileIn = new BufferedReader(new FileReader(SYSTEM_OPTIONS_FILE));            
    
            int i;
            boolean flag;
            String ss, tmpField, tmpValue;
            
            while ((ss = fileIn.readLine()) != null) {
                i = ss.indexOf(" : ");
                tmpField = ss.substring(0,i);
                tmpValue = ss.substring(i+3,ss.length()).toLowerCase();
                
                if (tmpValue.charAt(0) == 't') flag = true;
                else flag = false;
                
                setValue(tmpField,flag);
            }
           
            fileIn.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("The system cannot find the file ("+SYSTEM_OPTIONS_FILE+").");
        }
        catch (Exception e) {
            String err = e.toString();
            System.out.println(err);
        }
    }
    
    private void setValue(String tmpField, boolean flag) {
        //System.out.println(tmpField+" = "+flag);

        if (tmpField.equals("domainModelFlag")) {
            domainModelFlag = flag;
        }
    }
    //20-02-2002
    public static boolean getDomainF(){
    	return domainModelFlag;
    }
    	
    
    
}