/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.image.*;
import javax.swing.*;
import java.io.File;

// toolbar under main menu
public class ProgramToolBar extends JToolBar{
    
    private static final int WIDTH=16;
    private static final int HEIGHT=16;

    //Thomas
    //private static final ImageIcon NEW_IMAGE=new ImageIcon("icons"+File.separator+"new.gif");
    //private static final ImageIcon OPEN_IMAGE=new ImageIcon("icons"+File.separator+"open.gif");
    //private static final ImageIcon SAVE_IMAGE=new ImageIcon("icons"+File.separator+"save.gif");
    //private static final ImageIcon PRINT_IMAGE=new ImageIcon("icons"+File.separator+"print.gif");
    //private static final ImageIcon SEARCH_IMAGE=new ImageIcon("icons"+File.separator+"search.gif");
    //private static final ImageIcon PLUS_IMAGE=new ImageIcon("icons"+File.separator+"plus.gif");
    //private static final ImageIcon MOINS_IMAGE=new ImageIcon("icons"+File.separator+"moins.gif");
    private static final ImageIcon NEW_IMAGE=new ImageIcon(ClassLoader.getSystemResource("icons"+File.separator+"new.gif"));
    private static final ImageIcon OPEN_IMAGE=new ImageIcon(ClassLoader.getSystemResource("icons"+File.separator+"open.gif"));
    private static final ImageIcon SAVE_IMAGE=new ImageIcon(ClassLoader.getSystemResource("icons"+File.separator+"save.gif"));
    private static final ImageIcon PRINT_IMAGE=new ImageIcon(ClassLoader.getSystemResource("icons"+File.separator+"print.gif"));
    private static final ImageIcon SEARCH_IMAGE=new ImageIcon(ClassLoader.getSystemResource("icons"+File.separator+"search.gif"));
    private static final ImageIcon PLUS_IMAGE=new ImageIcon(ClassLoader.getSystemResource("icons"+File.separator+"plus.gif"));
    private static final ImageIcon MOINS_IMAGE=new ImageIcon(ClassLoader.getSystemResource("icons"+File.separator+"moins.gif"));

    private AbstractButton bNew,bOpen,bSave,bPrint,bSearch,bZoomPlus,bZoomMoins;
    private JComboBox cZoom;
    
    public ProgramToolBar(){
        super(HORIZONTAL);
        setMargin(new Insets(0,0,0,0));
        
                        
        bNew=new JButton(NEW_IMAGE);
        bNew.setToolTipText("New model");
        bNew.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
            	Manager.newTree();
            }
        });
        add(bNew);        

        bOpen=new JButton(OPEN_IMAGE);
        bOpen.setToolTipText("Open model");
        bOpen.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent e) {
		    	//Thomas ?V5
			    Manager.resetID();
			    
	        	Frame owner = (Frame)MainFrame.mainFrame; 
		    	JProgressBarDia jpbarDia = new JProgressBarDia( owner,"Openning file: ");
        		OpenASCIFileThread pOpenFile =new OpenASCIFileThread(jpbarDia);
	    		pOpenFile.start();
		   	    //Manager.open();
        	}
        });        
        add(bOpen);
                
        bSave=new JButton(SAVE_IMAGE);
        bSave.setToolTipText("Save model");
        bSave.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
            	Manager.save();
            }
        });        
        add(bSave);
         
        addSeparator();
                
        bPrint=new JButton(PRINT_IMAGE);
        bPrint.setToolTipText("Print current frame");
        bPrint.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
            	Manager.printFrame();
            }
        });        
        add(bPrint);
                
        addSeparator();
                
        bSearch=new JButton(SEARCH_IMAGE);
        bSearch.setToolTipText("Search a component");
        bSearch.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
            	Manager.search();
            }
        });        
        add(bSearch);

        addSeparator();
        
        //add(new JLabel("Zoom"));
                
        bZoomPlus=new JButton(PLUS_IMAGE);
        bZoomPlus.setToolTipText("Zoom +");
        bZoomPlus.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
            	Double d=(Double)cZoom.getSelectedItem();
            	Manager.resizeAll(d.doubleValue());
            }
        });
        add(bZoomPlus);
                
        bZoomMoins=new JButton(MOINS_IMAGE);
        bZoomMoins.setToolTipText("Zoom -");
        bZoomMoins.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e){
            	Double d=(Double)cZoom.getSelectedItem();
            	Manager.resizeAll(1/d.doubleValue());
            }
        });        
        add(bZoomMoins);
        
        Container c=new Container();
        c.setLayout(null);
        Double [] tab={new Double(1.01),new Double(1.05),new Double(1.1),
        	new Double(1.25),new Double(1.5),new Double(1.75),new Double(2)};
        cZoom=new JComboBox(tab);
        cZoom.setSelectedItem(tab[3]);
        cZoom.setBounds(0,0,60,bZoomMoins.getPreferredSize().height);
        c.add(cZoom);
        add(c);
        
        setMargin(new Insets(0,0,0,0));
    }    
}