/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   Redistribution in source and binary forms, with or without modification, are not permitted.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class PopupListener extends MouseAdapter {
    //shijian, 13-11-2001
    //in order to show popup menu within screen bounds
    static Dimension _screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    //	setBounds(FRAME_INSET,FRAME_INSET,
    //		screenSize.width-FRAME_INSET*2,
    //		screenSize.height-FRAME_INSET*2);
	
    public void mousePressed(MouseEvent e) {
        maybeShowPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
	    	double xLoc = e.getX();
			double yLoc = e.getY();
			//System.out.println("x= " + xLoc+ " y = "+ yLoc);
			
			Dimension popupSize = Manager.popup.getPreferredSize();
			Point topLeft= e.getComponent().getLocationOnScreen();
		
			if ((topLeft.getX() + xLoc+popupSize.width) >
        		_screenSize.width){
        		xLoc = _screenSize.width - popupSize.width -
        				topLeft.getX();
        	}
        	if ((topLeft.getY() + yLoc + popupSize.height) >
        		_screenSize.height){
        		yLoc = _screenSize.height - 
        			topLeft.getY() - popupSize.height;
        	}
        		
			//System.out.println("xnew = " + xLoc+ " ynew = "+ yLoc);
			//Manager.popup.setLocation(((int)xLoc), ((int)yLoc));
			//Manager.popup.setVisible(true);
            Manager.popup.show(e.getComponent(),((int)xLoc), ((int)yLoc));
        }
    }
}
