/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.awt.*;
import javax.swing.*;
import java.io.CharArrayReader;


public class PasswordDialog {
    
    // MARGINX SIZEX1 GAPX SIZEX2 MARGINX

    private static final int MARGINX=5;
    private static final int MARGINY=5;
    private static final int GAPX=10;
    private static final int GAPY=5;
    private static final int SIZEX1=80;
    private static final int SIZEX2=250;
    private static final int SIZEY=20;
    
    private static final Color BACKGROUND_COLOR = null;   //Color.white;
    private static final String PASSWORD = "i2tech";

    private static JDialog dialog;
    private static JPasswordField jpassword;
    
    protected static boolean correctFlag;
    
    public PasswordDialog() {
        JOptionPane pane = new JOptionPane(createPanel(),
            JOptionPane.PLAIN_MESSAGE,JOptionPane.OK_CANCEL_OPTION);

        dialog = pane.createDialog(MainFrame.mainFrame, "Password Checking");
        
        correctFlag = false;
        
        dialog.show();
        
        Object selectedValue = pane.getValue();
        if (selectedValue != null && selectedValue != JOptionPane.UNINITIALIZED_VALUE) {
            if (selectedValue instanceof Integer) {
                Integer sv = (Integer)selectedValue;

                if (sv.intValue()  == JOptionPane.OK_OPTION) {
                    if (checkPasswordOK(jpassword.getPassword())) correctFlag = true;
                }
            }
        }
    }

    private boolean checkPasswordOK(char[] password) {
        boolean flag = false;
        
        String tmpPassword = new String(password);
        //System.out.println("password = "+tmpPassword);
        
        if (tmpPassword.equals(PASSWORD)) flag = true;
        else {
            JOptionPane.showMessageDialog(MainFrame.mainFrame,
                "Wrong password !\n"+
                "Domain modeling not enabled.",
                "Error", JOptionPane.ERROR_MESSAGE);
        }
        
        return flag;
    }
    
    private JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(BACKGROUND_COLOR);
        panel.setFont(new Font("Helvetica", Font.PLAIN, 14));        
        panel.setLayout(null);
        //panel.setLayout(new GridLayout(2,1));     //2 rows, 1 column
        //panel.setLayout(new FlowLayout());

        int posx = MARGINX;
        int posy = MARGINY;
        
        int lineNum = 3;
            
        panel.setPreferredSize(new Dimension(MARGINX*2+SIZEX1+GAPX+SIZEX2+GAPX,    
            MARGINY+(SIZEY+GAPY)*lineNum));
        
        JComponent jc;

        jc = new JLabel("<html>\n"+
            "In order to enable domain modeling, \n"+
            "correct password must be entered : ");
        jc.setBounds(posx,posy,SIZEX1+GAPX+SIZEX2,SIZEY*2+GAPY);
        panel.add(jc);
        posy += (SIZEY+GAPY)*2;
        
        jc = new JLabel("<html>"+"Password");
        jc.setBounds(posx,posy,SIZEX1,SIZEY);
        posx += SIZEX1+GAPX;
        panel.add(jc);

        jpassword = new JPasswordField(20);
        jpassword.setFont(new Font("Helvetica", Font.PLAIN, 14));        
        jpassword.setBounds(posx,posy,SIZEX2,SIZEY);
        panel.add(jpassword);

        return panel;
    }
}