/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   Redistribution in source and binary forms, with or without modification, are not permitted.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.io.Writer;
import java.io.IOException;
import javax.swing.text.*;
import javax.swing.text.html.MinimalHTMLWriter;

public class MinimalHTMLWriter2 extends MinimalHTMLWriter {
    private static final int BOLD = 0x01;
    private static final int ITALIC = 0x02;
    private static final int UNDERLINE = 0x04;

    private int fontMask = 0;

    public MinimalHTMLWriter2(Writer w, StyledDocument doc, int pos, int len) {
        super(w,doc,pos,len);
    }

    public void write() throws IOException, BadLocationException {
		writeStartTag("<html>");
		writeHeader();
		writeBody();
		writeEndTag("</html>");
    }
    
    protected void writeBody() throws IOException, BadLocationException {
		ElementIterator it = getElementIterator();

		it.current();

		Element next = null;

		writeStartTag("<body>");

		boolean inContent = false;

		while((next = it.next()) != null) {
	    	if (!inRange(next)) {
				continue;
	    	}
		    if (next instanceof AbstractDocument.BranchElement) {
				if (inContent) {
		    		writeEndParagraph();
		    		inContent = false;
				    fontMask = 0;
				}
				writeStartParagraph(next);
	    	}
		    else if (isText(next)) {
				writeContent(next, !inContent);
				inContent = true;
		    }
		    else {
				writeLeaf(next);
				inContent = true;
		    }
		}
		if (inContent) {
		    writeEndParagraph();
		}
		writeEndTag("</body>");
    }
    
    protected void writeContent(Element elem,  boolean needsIndenting) throws IOException, BadLocationException {
		AttributeSet attr = elem.getAttributes();

		writeHTMLTags(attr);			// rearranged order to correct underlining space at end of attributes
		writeNonHTMLAttributes(attr);
		if (needsIndenting) {
		    indent();
		}
		
		text(elem);
    }

    protected void writeEndParagraph() throws IOException {
		writeEndMask(fontMask);
		if (inFontTag()) {
	    	endFontTag();
		}
		else {
	    	write(NEWLINE);
		}
		writeEndTag("</p>");
    }
    
    private void writeStartMask(int mask) throws IOException  {
		if (mask != 0) {
		    if ((mask & UNDERLINE) != 0) {
				write("<u>");
	    	}
		    if ((mask & ITALIC) != 0) {
				write("<i>");
		    }
		    if ((mask & BOLD) != 0) {
				write("<b>");
	    	}
		}
    }
    
    private void writeEndMask(int mask) throws IOException {
		if (mask != 0) {
		    if ((mask & BOLD) != 0) {
				write("</b>");
		    }
		    if ((mask & ITALIC) != 0) {
				write("</i>");
		    }
		    if ((mask & UNDERLINE) != 0) {
				write("</u>");
		    }
		}
    }
    protected void writeHTMLTags(AttributeSet attr) throws IOException {
		int oldMask = fontMask;
		setFontMask(attr);

		int endMask = 0;
		int startMask = 0;
		if ((oldMask & BOLD) != 0) {
		    if ((fontMask & BOLD) == 0) {
				endMask |= BOLD;
		    }
		}
		else if ((fontMask & BOLD) != 0) {
	    	startMask |= BOLD;
		}

		if ((oldMask & ITALIC) != 0) {
	    	if ((fontMask & ITALIC) == 0) {
				endMask |= ITALIC;
	    	}
		}
		else if ((fontMask & ITALIC) != 0) {
	    	startMask |= ITALIC;
		}

		if ((oldMask & UNDERLINE) != 0) {
	    	if ((fontMask & UNDERLINE) == 0) {
				endMask |= UNDERLINE;
	    	}
		}
		else if ((fontMask & UNDERLINE) != 0) {
	    	startMask |= UNDERLINE;
		}
		writeEndMask(endMask);
		writeStartMask(startMask);
    }
    
    private void setFontMask(AttributeSet attr) {
    	//Thomas : in order to fix the bug of bold / italic / underline not terminated properly (bug N6)
    	fontMask = 0;
    	
		if (StyleConstants.isBold(attr)) {
		    fontMask |= BOLD;
		}

		if (StyleConstants.isItalic(attr)) {
	    	fontMask |= ITALIC;
		}

		if (StyleConstants.isUnderline(attr)) {
	    	fontMask |= UNDERLINE;
		}
    }
}