/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   Redistribution in source and binary forms, with or without modification, are not permitted.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.awt.*;
import javax.swing.*;
import java.io.CharArrayReader;


public class MessageDialog {
    private static final Color BACKGROUND_COLOR = null;   //Color.white;

    public static void errorDialog(Component parentComponent, String title, String message) {
        JOptionPane pane = new JOptionPane(createPanel(message),
            JOptionPane.ERROR_MESSAGE,JOptionPane.DEFAULT_OPTION);

        JDialog dialog = pane.createDialog(parentComponent, title);
        
        dialog.show();
    }

    public static boolean askIfYesWithWarning(Component parentComponent, String title, String message,
        String yesButton, String noButton) {
        
        boolean result = false;
        
        String [] options = {yesButton, noButton};
        
        JOptionPane pane = new JOptionPane(createPanel(message),
            JOptionPane.WARNING_MESSAGE,JOptionPane.YES_NO_OPTION,null,options,options[0]);

        JDialog dialog = pane.createDialog(parentComponent, title);
        
        dialog.show();

        Object selectedValue = pane.getValue();

        if (selectedValue.toString() == yesButton) result = true;
        
        //TMUtility.display("askIfYesWithWarning : result",result);
        
        return result;
    }

    private static JPanel createPanel(String message) {
        JPanel panel = new JPanel();
        panel.setBackground(BACKGROUND_COLOR);
        panel.setFont(new Font("Helvetica", Font.PLAIN, 14));        
        panel.setLayout(new GridLayout(0,1));
        
        int iStart = 0;
        
        while (iStart < message.length()) {
            int iEnd = message.indexOf('\n',iStart);
            if (iEnd < 0) iEnd = message.length();
            String text = message.substring(iStart,iEnd);
            
            //TMUtility.display("MessageDialog",text);
            JComponent jc = new JLabel(text);
            panel.add(jc);
            
            iStart = iEnd+1;
        }

        return panel;
    }
}