/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   Redistribution in source and binary forms, with or without modification, are not permitted.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import utility.*;
import domainModel.*;

import parser.FSParser.*;
import parser.slider.*;
import java.io.File;
import tmrose.*;



public class MainMenu extends JMenuBar {
	
    protected JMenu pop;
    
    protected static final String versionNum = "4.02";
    
    //style parameter menuitems
    protected static final String CONJUNCTION_LABEL = "Conjunction Style";
    protected static final String STYLE_HOW_LABEL = "How Style";
    protected static final String MODALITY_CAN_LABEL = "Can-Modality Style";
    protected static final String PURPOSE_FIRST_LABEL = "Purpose-First Style";
    protected static final String STEP_BY_STEP_LABEL = "Step-By-Step Style";

    private static  JCheckBoxMenuItem _conjunctionJcbmi  = null;
    private static  JCheckBoxMenuItem _howJcbmi  = null;
    private static  JCheckBoxMenuItem _modalityCanJcbmi  = null;
    private static  JCheckBoxMenuItem _purposeFirstJcbmi  = null;
    private static  JCheckBoxMenuItem _stepByStepJcbmi  = null;

    private static  Component _comCurrent  = null;
    
    //28-6-2002, wordNet flag
    private static  boolean WRODNET_FLAG = true;
    
    static final Boolean
        bT=new Boolean(true),
        bF=new Boolean(false);
    
      
    static class MType { MType(int i) {} };
    static final MType
        mi = new MType(1), // Normal menu item
        cbT = new MType(2), // Checkbox menu item
        cbF = new MType(3), // Checkbox menu item
        rb = new MType(4); // Radio button menu item
      

    //shijian 2001-2-12
    private JMenu _editMenu,_domainNemu, _langMenu, _optionMenu,
    	_helpMenu;
    
    static ActionListener alSetHTML = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.setHTML();
   	    
   	    }
    };
    
    static ActionListener alGeneratHTML = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        //Manager.search();
   	    }
    };
      
      
    static ActionListener alSearch = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.search();
   	    }
    };

    static ActionListener alOpenAllFrames = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.openAllFramesInternaly();
   	    }
    };

    static ActionListener alOpenAllInvisibleFrames = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.openAllInvisibleFramesInternaly();
   	    }
    };

    static ActionListener alDebugRegister = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            if (Manager.currentComponent != null) {
                // collect details of the selected component
                String name = Manager.currentComponent.getName();
                Integer id2 = new Integer(Manager.currentComponent.ID);
                
                // find the node of the selected component
                TreeMap parentTreeMap = (TreeMap)Manager.skeleton.nodeRegister.get(name);
                Set keys = parentTreeMap.keySet();
        
                for (Iterator it=keys.iterator();it.hasNext();) {
                    String tmpParentName = (String)(it.next());
                    Node tmpParentNode = (Node)parentTreeMap.get(tmpParentName);
        
                    if (tmpParentNode.hasChild(name,id2)) {
                        Node node = tmpParentNode.getChild(name,id2);

                        // print the immediate decomposition of the selected component
                        System.out.println("ID of \""+name+"\" = "+id2);
                        Manager.skeleton.printNode(node,name);
                    }
                }
            }
            else
   	            Manager.skeleton.printRegister();
   	    }
    };

    static ActionListener alDebugTree = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.skeleton.printTree();
   	    }
    };

    
    static ActionListener alComponentsOptions = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        new ComponentsOptionsDialog();
   	    }
    };
    
    static ActionListener alDisplayOptions = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        new DisplayOptionsDialog();
   	    }
    };
    
    static ActionListener alDomainModel = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            if (!Manager.systemOptions.domainModelFlag) {
               PasswordDialog dialog = new PasswordDialog();
               //System.out.println("correctFlag = "+dialog.correctFlag);
               if (!dialog.correctFlag) {
                   Manager.menu.setOptions();
                   return;
               }
            }
            
            Manager.systemOptions.domainModelFlag = !Manager.systemOptions.domainModelFlag;
            
            Manager.systemOptions.saveFile();
            Manager.menu.setOptions();
            
            //shijian 2001-3-22
            Manager.menu.changeMenuItems(Manager.menu._optionMenu, 
            	Manager.menu.optionsMenu);
            Manager.attributesPanel.displayAttributes(Manager.currentComponent);
        }
    };

    static ActionListener alQuit = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
    	    if (Manager.fileSaved()) {        
            	MainFrame.editor.closing();
            	MainFrame.closing();
   	    	    System.exit(0);
   	        }
   	    }
    };
   
    static ActionListener alNew = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.newTree();
   	    }
    };
   
   
    static ActionListener alOpen = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
	    	//Thomas ?V5
		    Manager.resetID();
			    
        	Frame owner = (Frame)MainFrame.mainFrame; 
	    	JProgressBarDia jpbarDia = new JProgressBarDia(owner,"Openning file: ");
        	OpenASCIFileThread pOpenFile = new OpenASCIFileThread(jpbarDia);
	    	pOpenFile.start();
	    	 
   	        //Manager.open();
   	    }
    };
   
    static ActionListener alSave = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.save();
   	    }
    };
    
    static ActionListener alSaveAs = new ActionListener(){
        public void actionPerformed(ActionEvent e){
   	    Manager.saveAs();
   	}
    };   
    static ActionListener alPrintFrame = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.printFrame();
   	    }
    };
 //shijian 2001-2-12
 // menuItems for domain model menu
    static ActionListener alNEConcept = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.newECon();
   	    }
    };
    static ActionListener alNAConcept = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.newACon();
   	    }
    };
    static ActionListener alNEInstance = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.newEIns();
   	    }
    };
    static ActionListener alNAInstance = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.newAIns();
   	    }
    };
    static ActionListener alNERelation = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.newERels();
   	    }
    };
    static ActionListener alNARelation = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.newARels();
   	    }
    };
    static ActionListener alEDM = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.editDM();
   	    }
    };
    static ActionListener alALlDM = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.createDMAll();
   	    }
    };
    static ActionListener alTrackIns = new ActionListener() {
    	public void actionPerformed(ActionEvent e) {
	        Manager.getXDM().getDmManager().trackingInstnaces();
	    }
    };

    static ActionListener alIfNil = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.createDMIfNil();
   	    }
    };
    static ActionListener alDirty = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.markDirty();
   	    }
    };
    static ActionListener alClean = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.markClean();
   	    }
    };
    static ActionListener alClearAllIns = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.getXDM().getDmManager().clearDMAllIns();
   	    }
    };
    static ActionListener alClearAllUn = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.getXDM().getDmManager().clearDMAllUnIns();
   	    }
    };
    
    static ActionListener alClearAll = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.clearDMAll();
   	    }
    };
    
    static ActionListener alConjunction = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
        	if (_conjunctionJcbmi.isSelected())
   	        	Manager.getXDM().getDmManager().setConjunction(true);
   	        else
   	        	Manager.getXDM().getDmManager().setConjunction(false);
   	    }
    };

    static ActionListener alStyleHow = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
        	if (_howJcbmi.isSelected())
   	        	Manager.getXDM().getDmManager().setStyleHow(true);
   	        else
   	        	Manager.getXDM().getDmManager().setStyleHow(false);
   	    }
    };
    
    static ActionListener alModalityCan = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
        	if (_modalityCanJcbmi.isSelected())
   	        	Manager.getXDM().getDmManager().setModalityCan(true);
   	        else
   	        	Manager.getXDM().getDmManager().setModalityCan(false);
   	    }
    };
    
    static ActionListener alPurposeFirst = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
        	if (_purposeFirstJcbmi.isSelected())
   	        	Manager.getXDM().getDmManager().setPurposeFirst(true);
   	        else
   	        	Manager.getXDM().getDmManager().setPurposeFirst(false);
   	    }
    };

    static ActionListener alStepByStep = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
        	if (_stepByStepJcbmi.isSelected())
   	        	Manager.getXDM().getDmManager().setStepByStep(true);
   	        else
   	        	Manager.getXDM().getDmManager().setStepByStep(false);
   	    }
    };

    
    static ActionListener alExportLG = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.exportLG();
   	    }
    };

    static ActionListener alExportGenerateLG = new ActionListener(){
        public void actionPerformed(ActionEvent e) {
   	        Manager.exportGenerateLG();
   	    }
    };

    static ActionListener alDocStyle = new ActionListener(){
        public void actionPerformed(ActionEvent e) {
   	        Manager.getXDM().getDmManager().setDocStyle();
   	    }
    };


   static ActionListener alLGhelp = new ActionListener() {
       public void actionPerformed(ActionEvent e) {
           // String helpInfor = "Generate on-line help";
           //JOptionPane.showMessageDialog(MainFrame.mainFrame, helpInfor);

           Manager.LGhelp();
  	    }
    };

   static ActionListener alLGlogin=new ActionListener() {
       public void actionPerformed(ActionEvent e) {
           Manager.LGlogin();
  	    }
    };

    static ActionListener alSetLGServerName=new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            Manager.setLGServerName();
        }
    };

    static ActionListener alOpenHTMLView=new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.openHTMLView();
   	    }
    };

    static ActionListener alListenHelp=new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.listenHelp();
   	    }
    };

    static ActionListener alContents = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
               Manager.openHelpContents();
        }
    };
   
    static ActionListener alExportHTML = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.exportHTML();
   	    }
    };
    
    static ActionListener alExportHTMLfromXSL = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            Manager.exportHTMLfromXSL();
        }
    };
    
    static ActionListener alGenerateRose = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            TaskRoseManager.generateRoseModel();
        }
    };
   
    static ActionListener alImportDomain = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.importDomain();
   	    }
    };
   
    static ActionListener alWindowsLookAndFeel = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            /*try{
                MainFrame.mainFrame.setVisible(false);
                UIManager.setLookAndFeel("javax.swing.plaf.multi.MultiLookAndFeel");
                SwingUtilities.updateComponentTreeUI(Manager.tree);
                //frame.pack();
                MainFrame.mainFrame.setVisible(true);
            } catch (Exception excep){System.out.println("LookAndFeel error: "+excep.toString());}
   	        */
   	    }
    };
    
    static ActionListener alDelete = new ActionListener() { 
        public void actionPerformed(ActionEvent e) {
    	    //Thomas
   	   	    //System.out.println("Delete key pressed !");
   	        if (Manager.currentComponent != null) {
   	    	    DeleteManager.delete();
   	        }
   	    }
    };
   
    static ActionListener alCut = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            if (Manager.currentComponent != null) {
                CutManager.cut();
            }
   	    }
    };
   
    static ActionListener alCopy = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            if (Manager.currentComponent != null) {
                CopyManager.copy();
            }
        }
    };
   
    static ActionListener alNewTask = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        NewManager.newTask();
   	    }
    };
   
    static ActionListener alNewBooleanConnectorOR = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        NewManager.newBooleanConnector("OR");
   	    }
    };
   
    static ActionListener alNewBooleanConnectorAND = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        NewManager.newBooleanConnector("AND");
       	}
    };
   
    static ActionListener alNewBooleanConnectorXOR = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        NewManager.newBooleanConnector("XOR");
   	    }
    };
   
   
    static ActionListener alPaste = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        if (Manager.tree.getSelectionPath() != null) PasteManager.paste();
            //TMUtility.display("alPaste : popup",Manager.popup.isVisible());
   	    }
    };
    
    static ActionListener alPromote = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            if (Manager.tree.getSelectionPath() != null) PromoteManager.promote();
        }
    };
   
    static ActionListener alDemote = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            if (Manager.tree.getSelectionPath() != null) DemoteManager.demote();
        }
    };
   
    static ActionListener alEdit = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        if (Manager.tree.getSelectionPath() != null) EditManager.edit(true);
       	}
    };
  
    //shijian 2001-3-21
    static ActionListener alEditSemantic = new ActionListener() {
        public void actionPerformed(ActionEvent e){
        	if (_comCurrent != null && _comCurrent instanceof Task){
	        	Task t = (Task) _comCurrent;
	   	    	DmManager.editSemantics(t);
        	}
        	return;
       	}
    };
   
    static ActionListener alEditPrecon = new ActionListener() {
        public void actionPerformed(ActionEvent e){
         	if (_comCurrent != null && _comCurrent instanceof Task){
	        	Task t = (Task) _comCurrent;
  	    		DmManager.editPrecon(t);
         	}
        	return;
       	}
    };
    
   
    static ActionListener alEditFeedback = new ActionListener() {
        public void actionPerformed(ActionEvent e){
         	if (_comCurrent != null && _comCurrent instanceof Task){
	        	Task t = (Task) _comCurrent;
  	    		DmManager.editFeedback(t);
         	}
        	return;
       	}
    };
    
   
    static ActionListener alEditCondition = new ActionListener() {
        public void actionPerformed(ActionEvent e){
         	if (_comCurrent != null && _comCurrent instanceof Link){
	        	Link l = (Link) _comCurrent;
    	    	DmManager.editLinkCon(l);
         	}
      		return;
       	}
    };
    
    
    static ActionListener alDomainActionEdit = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
   	        Manager.editDM();	//domainDialog();
   	    }
    };
    
    static ActionListener alAbout=new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            AboutDialog dialog = new AboutDialog();
            /*StringBuffer buf = new StringBuffer();
            
            buf.append("TAMOT 3 \n Version ");
            buf.append(versionNum);
            
            String helpInfor = buf.toString();
            
            JOptionPane.showMessageDialog(MainFrame.mainFrame, helpInfor);*/
        }
    };
	
	//brasser 2001-6-21
	//function for extracting tasks from a text file
	static ActionListener alExtractTasks = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
			JFileChooser fc = new JFileChooser();
			int returnVal = fc.showOpenDialog(MainFrame.getMainFrame());

    		if (returnVal == JFileChooser.APPROVE_OPTION) {
        		File file = fc.getSelectedFile();	
				FileManager.extractText(file);
        
    		}
   	        //System.out.println("Not fully implemented yet!");
   	    }
    };
	
	//brasser 2001-6-21
	//function for interactive task creation using the parser
	static ActionListener alTextInput = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
        
        		//28-6-2002, if not wordNet 
        		if (!WRODNET_FLAG){
	    		TaskInput ti=  new TaskInput(MainFrame.getMainFrame());
			Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	    		ti.setLocation((screenSize.width - ti.getWidth()) / 2,
					(screenSize.height - ti.getHeight()) / 2);
			ti.run( "Task Input");
		} else {
	   	      GenericComponent _gc = null;
	            Parser parser = new Parser(Manager.getXDM().getDmManager(),"action.grammar");
	    		ParseFrame slider = new ParseFrame(MainFrame.getMainFrame(), ParseFrame.TASK_MODE, ParseFrame.REPEAT_MODE);
			Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	    		slider.setLocation((screenSize.width - slider.getWidth()) / 2,
					(screenSize.height - slider.getHeight()) / 2);
			slider.run(parser, Manager.getXDM().getDmManager(), "Task Input", _gc);
		}	
   	    }
    };
   
    //private static final String file="menu.cfg";
   
    public Object[][] fileMenu = {
    	{"File",new Character('F')},
    	//
   	    //{"New Task",mi,new Character('N'),alNewTask,bF},
   	    //{null},
   	    /*{"LookAndFeel",mi,new Character('L'),alWindowsLookAndFeel,bT},
   	    {null},*/
        {"New",mi,new Character('N'),alNew,bT},
        {"Open",mi,new Character('O'),alOpen,bT},
        {"Close",mi,new Character('C'),alNew,bT},
        {"Save",mi,new Character('S'),alSave,bT},
        {"Save As",mi,new Character('V'),alSaveAs,bT},
        {null},
        {"Print current frame",mi,new Character('I'),alPrintFrame,bT},
       // {null},
       // {"Import Domain",mi,new Character('I'),alImportDomain,bT},
        //{"Export HTML",mi,new Character('E'),alExportHTML,bT},
        //{"Export L.G.",mi,new Character('L'),alExportLG,bT},
   	    {null},
   	    {"Quit",mi,new Character('Q'),alQuit,bT}
    };
   /*
    public Object[][] editionMenu = {
    	{"Edit",new Character('E')},
    	//
   	    {"New Task",mi,new Character('N'),alNewTask,bT},
   	    {"New Boolean connector OR",mi,new Character('O'),alNewBooleanConnectorOR,bT},
   	    {"New Boolean connector AND",mi,new Character('A'),alNewBooleanConnectorAND,bT},
   	    {"New Boolean connector XOR",mi,new Character('X'),alNewBooleanConnectorXOR,bT},
        {null},
   	    {"Delete",mi,new Character('D'),alDelete,bT},
           
        // temporarily diable cut, copy & paste
   	    //{"Cut",mi,new Character('C'),alCut,bT},
   	    //{"Paste",mi,new Character('P'),alPaste,bT},
        {"Cut",mi,new Character('C'),alCut,bF},
        {"Paste",mi,new Character('P'),alPaste,bF},
        {null},
   	    {"Edit",mi,new Character('E'),alEdit,bT},
   	    {"Edit Domain Models",mi,new Character('D'),alDomainActionEdit,bT},
   	    {null},
   	    {"Debug register",mi,new Character('R'),alDebugRegister,bT},
        //{"Debug tree",mi,new Character('T'),alDebugTree,bT},
   	    {"Open All Frames",mi,new Character('F'),alOpenAllFrames,bT}
   	    //{"Open Invisible Frames",mi,new Character('I'),alOpenAllInvisibleFrames,bT}
    };
  */ 
    //shijian 2001-3-21
    //when nothing is selected
    public static final Object[][] editionMenu = {
    	{"Edit",new Character('E')},
    	//
   	    {"New Task",mi,new Character('N'),alNewTask,bT},
   	    {"New Boolean connector OR",mi,new Character('O'),alNewBooleanConnectorOR,bT},
   	    {"New Boolean connector AND",mi,new Character('A'),alNewBooleanConnectorAND,bT},
   	    {"New Boolean connector XOR",mi,new Character('X'),alNewBooleanConnectorXOR,bT},
        {null},
        {"Paste",mi,new Character('P'),alPaste,bT},
        {null},
   	    {"Edit Domain Models",mi,new Character('D'),alDomainActionEdit,bT},
   	    {null},
   	    {"Debug register",mi,new Character('R'),alDebugRegister,bT},
   	    {"Open All Frames",mi,new Character('F'),alOpenAllFrames,bT},
   	    		//brasser 2001-6-21
   	    {null},
		{"Extract Tasks from file",mi,new Character('T'),alExtractTasks,bT},
   	    {"Text Input for Tasks",mi,new Character('I'),alTextInput,bT}

    };
   
   
    //shijian 2001-3-21
    //when task is selected
    public static final Object[][] editionMenuTask = {
    	{"Edit",new Character('E')},
    	//
   	    {"New Task",mi,new Character('N'),alNewTask,bT},
   	    {"New Boolean connector OR",mi,new Character('O'),alNewBooleanConnectorOR,bT},
   	    {"New Boolean connector AND",mi,new Character('A'),alNewBooleanConnectorAND,bT},
   	    {"New Boolean connector XOR",mi,new Character('X'),alNewBooleanConnectorXOR,bT},
        {null},
   	    {"Edit",mi,new Character('E'),alEdit,bT},
   	    {"Delete",mi,new Character('D'),alDelete,bT},
        {"Cut",mi,new Character('C'),alCut,bT},
        {"Copy",mi,new Character('O'),alCopy,bT},
        {"Paste",mi,new Character('P'),alPaste,bT},
        {null},
   	    {"Edit Semantic Domain",mi,new Character('S'),alEditSemantic,bT},
   	    {"Edit Precondition Domain",mi,new Character('T'),alEditPrecon,bT},
   	    {"Edit Feedback Domain",mi,new Character('B'),alEditFeedback,bT},
   	    {"Edit Domain Models",mi,new Character('M'),alDomainActionEdit,bT},
        {null},
        {"Add Level",mi,new Character('A'),alPromote,bT},
        {"Remove Level",mi,new Character('R'),alDemote,bT},
   	    {null},
   	    {"Debug register",mi,new Character('R'),alDebugRegister,bT},
   	    {"Open All Frames",mi,new Character('F'),alOpenAllFrames,bT},
   	    		//brasser 2001-6-21
   	    {null},
		{"Extract Tasks from file",mi,new Character('T'),alExtractTasks,bT},
   	    {"Text Input for Tasks",mi,new Character('I'),alTextInput,bT}

    };
     
    public static final Object[][] editionMenuMultiComponents = {
        {"Edit",new Character('E')},
        //
        {"Delete",mi,new Character('D'),alDelete,bT},
        {"Cut",mi,new Character('C'),alCut,bT},
        {"Copy",mi,new Character('O'),alCopy,bT},
        {"Paste",mi,new Character('P'),alPaste,bT},
        {null},
        {"Add Level",mi,new Character('A'),alPromote,bT},
        //{"Remove Level",mi,new Character('R'),alDemote,bT},
        {null},
        {"Debug Register",mi,new Character('R'),alDebugRegister,bT},
        {"Open All Frames",mi,new Character('F'),alOpenAllFrames,bT}
    };
     
    //shijian 2001-3-21
    //when link is selected
    public static final Object[][] editionMenuLink = {
    	{"Edit",new Character('E')},
        //
   	    {"Edit",mi,new Character('E'),alEdit,bT},
   	    {"Delete",mi,new Character('D'),alDelete,bT},
        {null},
   	    {"Edit Condition Domain",mi,new Character('C'),alEditCondition,bT},
   	    {"Edit Domain Models",mi,new Character('M'),alDomainActionEdit,bT},
   	    {null},
   	    {"Debug register",mi,new Character('R'),alDebugRegister,bT},
   	    {"Open All Frames",mi,new Character('F'),alOpenAllFrames,bT}
    };
     
    //shijian 2001-3-21
    //when boolean connector is selected
    public static final Object[][] editionMenuBoolean = {
    	{"Edit",new Character('E')},
        //
   	    {"Delete",mi,new Character('D'),alDelete,bT},
        {"Cut",mi,new Character('C'),alCut,bT},
        {"Copy",mi,new Character('O'),alCopy,bT},
        {"Paste",mi,new Character('P'),alPaste,bT},
        {null},
   	    {"Edit Domain Models",mi,new Character('M'),alDomainActionEdit,bT},
  	    {null},
   	    {"Debug register",mi,new Character('R'),alDebugRegister,bT},
   	    {"Open All Frames",mi,new Character('F'),alOpenAllFrames,bT}
    };
   
    public Object[][] actionsMenu = {
    	{"Actions",new Character('A')},
    	//
   	    {"HTML Report settings",mi,new Character('h'),alSetHTML,bT},
   	    //shijian 2001-10-5
   	    //{"Generate HTML Report",mi,new Character('G'),alExportHTML,bT},
        {"Generate HTML using XSL",mi,new Character('X'),alExportHTMLfromXSL,bT},
    /*	{null},
        {"Export LISP Models",mi,new Character('E'),alExportLG,bT},  //   
        {"Generate online help",mi,new Character('N'),alLGhelp,bT},
        {"Export and Generate",mi,new Character('R'),alExportGenerateLG,bT}, 
        {"Set Language Server",mi,new Character('S'),alSetLGServerName,bT}, 
        {"Language Server login",mi,new Character('L'),alLGlogin,bT}, 
        {"Open on-line help",mi,new Character('O'),alOpenHTMLView,bT}, 

     */   {null},
        {"Generate Rose model",mi,new Character('R'),alGenerateRose,bT},
        {null},
   	    {"Search",mi,new Character('H'),alSearch,bT},
    };
   
    //shijian 2001-2-12
    // add domain model menu
    public Object[][] dmMenu = {
    	{"Domain",new Character('D')},
    	//
   	    {"New Entity Concept",mi,new Character('E'),alNEConcept,bT},
   	    {"New Action Concept",mi,new Character('A'),alNAConcept,bT},
   	    {"New Entity Instance",mi,new Character('I'),alNEInstance,bT},
   	    {"New Action Instance",mi,new Character('N'),alNAInstance,bT},
   	    {"New Entity Relation",mi,new Character('T'),alNERelation,bT},
   	    {"New Action Relation",mi,new Character('W'),alNARelation,bT},
   	    {null},
   	    {"Edit Domain Model",mi,new Character('M'),alEDM,bT},
    	{null},
        {"Finalise Knowledge Base",mi,new Character('F'),alIfNil,bT},
        {"Track Instances",mi,new Character('S'),alTrackIns,bT},	//alALlDM,bT},  //   
      	{null},
      	{"Mark All Task Dirty",mi,new Character('R'),alDirty,bT}, 
        {"Mark All Task Clean",mi,new Character('K'),alClean,bT}, 
    	{null},
        {"Clear All Un-Referenced Instances",mi,new Character('Y'),alClearAllUn,bT}, 
    	{"Clear All Instances",mi,new Character('X'),alClearAllIns,bT}, 
        {"Clear All DM Elements",mi,new Character('Z'),alClearAll,bT}, 
    };
   
    //shijian 2001-2-12
    // ad language generation menu
    public Object[][] langMenu = {
    	{"Language",new Character('L')},
    	//
		{"Export LISP Models",mi,new Character('E'),alExportLG,bT},  //   
        {"Generate online help",mi,new Character('G'),alLGhelp,bT},
        {"Export and Generate",mi,new Character('A'),alExportGenerateLG,bT}, 
    	{null},
    	{"Set Document Style",mi,new Character('S'),alDocStyle,bT}, 

    		/*
        {MODALITY_CAN_LABEL,cbF,new Character('M'),alModalityCan,bT},
      	{CONJUNCTION_LABEL,cbF,new Character('C'),alConjunction,bT},
        {STYLE_HOW_LABEL,cbF,new Character('H'),alStyleHow,bT},
        {PURPOSE_FIRST_LABEL,cbF,new Character('P'),alPurposeFirst,bT},
        {STEP_BY_STEP_LABEL,cbF,new Character('S'),alStepByStep,bT},
        */
        {null},
        {"Open on-line help",mi,new Character('O'),alOpenHTMLView,bT}, 
        {null},
        {"Listen to help",mi,new Character('L'),alListenHelp,bT}, 

    };
  /*
  CONJUNCTION_LABEL = "Conjunction Style";
    protected static final String STYLE_HOW_LABEL = "How Style";
    protected static final String MODALITY_CAN_LABEL = "Modality-Can Style";
    protected static final String PURPOSE_FIRST_LABEL = "Purpose-First Style";
    protected static final String STEP_BY_STEP_LABEL
  */
    
    public Object[][] optionsMenu = {
    	{"Options",new Character('O')},
    	//
        {"Components",mi,new Character('C'),alComponentsOptions,bT},
        {"Display",mi,new Character('D'),alDisplayOptions,bT},

        {null},
        {"Domain Model",cbF,new Character('M'),alDomainModel,bT},
    };
    
    public Object[][] helpMenu = {
    	{"Help",new Character('H')},
        //
       	{"Contents",mi,new Character('C'),alContents,bT},
        {"About",mi,new Character('A'),alAbout,bT},
    };
    
    //shijian 2001-2-12 
    //add LG menu
    public Object[] menuBar={fileMenu,editionMenu,actionsMenu, optionsMenu,helpMenu};//null,helpMenu};
    public Object[] menuDM={fileMenu,editionMenu,actionsMenu,dmMenu,langMenu, optionsMenu,helpMenu};//null,helpMenu};
//    public Object[] menuBar={fileMenu,editionMenu,actionsMenu,optionsMenu,helpMenu};//null,helpMenu};
   
    public void createMenuBar(Object[] menuBarData) {
    	//shijian 2001-2-12
    	//removeAll();
    	
        for (int i = 0; i < menuBarData.length; i++) {
            if (menuBarData[i]==null) add(Box.createHorizontalGlue());
            else{
            	JMenu menu =createMenu((Object[][])menuBarData[i]);
        
		        //shijian 2001-2-12 
		        if (menuBarData[i].equals(editionMenu)){
		        	_editMenu= menu;
		        	add(_editMenu);
		        }
		        else if (menuBarData[i].equals(dmMenu)){
		        	_domainNemu= menu;
		        	add(_domainNemu);
		        }
		        else if (menuBarData[i].equals(langMenu)){
		        	_langMenu= menu;
		        	add(_langMenu);
		        }
		        else if (menuBarData[i].equals(optionsMenu)){
		        	_optionMenu= menu;       
		        	add(_optionMenu);
		        }
		        else if (menuBarData[i].equals(helpMenu)){
		        	_helpMenu= menu;
		        	add(_helpMenu);

		        } else
            		add(menu);
            	
            }
        }
    }
  
    ButtonGroup bgroup;
    
    public JMenu createMenu(Object[][] menuData) {
        JMenu menu = new JMenu();
        menu.setText((String)menuData[0][0]);
        menu.setMnemonic(((Character)menuData[0][1]).charValue());
        SystemOptions so = new SystemOptions();
        so.readFile();
        
        // Create redundantly, in case there are any radio buttons:
        bgroup = new ButtonGroup();
        for (int i = 1; i < menuData.length; i++) {
           if (menuData[i][0] == null)
               menu.add(new JSeparator());
           else {
           		Sentence sen = new Sentence((String)menuData[i][0]);
           		if (!(so.domainModelFlag) &&
           			sen.contains("Domain")){
           			Component jmi=	menu.getMenuComponent(menu.getMenuComponentCount()-1);
           			if( jmi instanceof JSeparator)
           				menu.remove(jmi); //remove the separator	
           			continue;	
           		}
           		
               menu.add(createMenuItem(menuData[i]));
           }
        }
        
        return menu;
    }
    
    
    //shijian 2001-3-21
    public void changeMenuItems(JMenu menu,Object[][] menuData) {
        menu.removeAll();
        for (int i = 1; i < menuData.length; i++) {
           if (menuData[i][0] == null)
               menu.add(new JSeparator());
           else {
           		Sentence sen = new Sentence((String)menuData[i][0]);
           		if (!(Manager.systemOptions.domainModelFlag) &&
           			sen.contains("Domain")){
           			Component jmi=	menu.getMenuComponent(menu.getMenuComponentCount()-1);
           			if( jmi instanceof JSeparator)
           				menu.remove(jmi); //remove the separator	
           			continue;	
           		}
           		
               menu.add(createMenuItem(menuData[i]));
           }
        }
        
        return ;
    }
    
    public JMenuItem createMenuItem(Object[] data) {
        JMenuItem m = null;
        
        MType type = (MType)data[1];
        String label= (String)data[0];
      
        if (type == mi)
            m = new JMenuItem();
        else if(type == cbF){
            m = new JCheckBoxMenuItem();
            
         	if (label.equals(CONJUNCTION_LABEL)){
      	    	m.setSelected(false);
      	    	_conjunctionJcbmi  =(JCheckBoxMenuItem) m;
       		}else if (label.equals(STYLE_HOW_LABEL)){
      	    	m.setSelected(false);
      	    	_howJcbmi  =(JCheckBoxMenuItem) m;
        	}else if(label.equals(MODALITY_CAN_LABEL)){
      	    	m.setSelected(false);
      	    	_modalityCanJcbmi  =(JCheckBoxMenuItem) m;
       		}else if (label.equals(PURPOSE_FIRST_LABEL)){
      	    	m.setSelected(false);
      	    	_purposeFirstJcbmi  =(JCheckBoxMenuItem) m;
        	}else if(label.equals(STEP_BY_STEP_LABEL)){
      	    	m.setSelected(true);
      	    	_stepByStepJcbmi  =(JCheckBoxMenuItem) m;

        	}else{
            	Manager.systemOptions.readFile();
      	    	m.setSelected(Manager.systemOptions.domainModelFlag);
        	}
       }
        else if(type == cbT){
            	m = new JCheckBoxMenuItem(null,true);
     //	    m.setSelected(Manager.systemOptions.domainModelFlag);
       	}else if(type == rb) {
            m = new JRadioButtonMenuItem();
            
            bgroup.add(m);
        }
        
        m.setText((String)data[0]);
        m.setMnemonic(((Character)data[2]).charValue());
        m.addActionListener((ActionListener)data[3]);
        m.setEnabled(((Boolean)data[4]).booleanValue());
        if(data.length == 6) m.setIcon((Icon)data[5]);
        
        return m;
    }
   
    public MainMenu() {
        super();
        createMenuBar(menuDM);
        
        //28-6-2002, if no domain req, set wordnet flag to false
       if(!(Manager.systemOptions.domainModelFlag))
       	WRODNET_FLAG = false;
        
    }
   
    protected void setOptions() {
        setOptions(menuBar,"Options","Domain Model",Manager.systemOptions.domainModelFlag);
       
        setOptions(menuBar,"File","Import Domain",Manager.systemOptions.domainModelFlag);
       
        setOptions(menuBar,"Edit","Edit Domain Models",Manager.systemOptions.domainModelFlag);
       
		//shijian 2001-2-13
        updateMenuBar();
        /*
        setOptions(menuBar,"Actions","Export LISP Models",Manager.systemOptions.domainModelFlag);
        setOptions(menuBar,"Actions","Generate online help",Manager.systemOptions.domainModelFlag);
        setOptions(menuBar,"Actions","Export and Generate",Manager.systemOptions.domainModelFlag);
        setOptions(menuBar,"Actions","Set Language Server",Manager.systemOptions.domainModelFlag);
        setOptions(menuBar,"Actions","Language Server login",Manager.systemOptions.domainModelFlag);
        setOptions(menuBar,"Actions","Open on-line help",Manager.systemOptions.domainModelFlag);
        */ 
         
        setOptions(Manager.popup,"Edit Domain Models",Manager.systemOptions.domainModelFlag);
    }

/*  protected void setOptions(Component component) {
       boolean editFlag = false;
       boolean deleteFlag = false;

       if (component != null) {
           if (component instanceof Task) {
               editFlag = true;
               deleteFlag = true;
           }
           
           if (component instanceof BooleanConnector) {
               editFlag = false;
               deleteFlag = true;
           }
           
           if (component instanceof Link) {
               editFlag = true;
               deleteFlag = true;
           }
       }
       
       setOptions(menuBar,"Edit","Edit",editFlag);
       setOptions(Manager.popup,"Edit",editFlag);
       
       setOptions(menuBar,"Edit","Delete",deleteFlag);
       setOptions(Manager.popup,"Delete",deleteFlag);
   }
   
   	           		menu.changePopupMenuItems(Manager.popup,
	           			MainMenu.editionMenuTask);
					System.out.println("select task");
	           } else if (gcSel instanceof BooleanConnector) {
	           		menu.changePopupMenuItems(Manager.popup,
	           			MainMenu.editionMenuBoolean);
	           }else if (gcSel instanceof Link) {
	           		menu.changePopupMenuItems(Manager.popup,
	           			MainMenu.editionMenuLink);
	           }
	       	} else
	           	menu.changePopupMenuItems(Manager.popup,
	           		MainMenu.editionMenu);

 */
 
    //shijian 2001-3-21
    protected void setOptions(Component component) {
        _comCurrent = component;
		
        if (component != null) {
            if (BottomUp.isMultiComponentsSelected()) {
                changeMenuItems(_editMenu,editionMenuMultiComponents);
                changePopupMenuItems(Manager.popup,editionMenuMultiComponents);
            } else if (component instanceof Task) {
                changeMenuItems(_editMenu,editionMenuTask);
                changePopupMenuItems(Manager.popup,editionMenuTask);
				//System.out.println("select task");
            } else if (component instanceof BooleanConnector) {
                changeMenuItems(_editMenu,editionMenuBoolean);
	          	changePopupMenuItems(Manager.popup,editionMenuBoolean);
            } else if (component instanceof Link) {
                changeMenuItems(_editMenu,editionMenuLink);
 	          	changePopupMenuItems(Manager.popup,editionMenuLink);
            }
        } else {
            if (BottomUp.isMultiComponentsSelected()) {
                changeMenuItems(_editMenu,editionMenuMultiComponents);
                changePopupMenuItems(Manager.popup,editionMenuMultiComponents);
            } else {
                changeMenuItems(_editMenu,editionMenu);
                changePopupMenuItems(Manager.popup,editionMenu);
            }
        }
       		
		_editMenu.invalidate();
		_editMenu.revalidate();
      	_editMenu.paintImmediately(getBounds());
    }
  
    private void setOptions(Object[] menuBarData,String menuName, String menuItemName, boolean flag) {
       String tmpMenu;
       Object [][] menuData;
       JMenu menu = null;
       
       for (int i = 0; i < menuBarData.length; i++) {
           menuData = (Object [][]) menuBarData[i];
           tmpMenu = (String) menuData[0][0];
           if (tmpMenu.equals(menuName)) {
               //System.out.println("tmpMenu = "+tmpMenu);
               
               menu = getMenu(i);
               
               setOptions(menu,menuItemName,flag);
               
               return;
           }
       }
    }

    private void setOptions(JMenu menu, String menuItemName, boolean flag) {
       int count = menu.getItemCount();
       
       JMenuItem menuItem;
       JCheckBoxMenuItem checkBoxMenuItem;
       String tmpMenuItemName;
       
       for (int i = 0; i < count; i++) {
           menuItem = menu.getItem(i);
           if (menuItem == null) continue;
           
           tmpMenuItemName = menuItem.getText();
           //System.out.println("tmpMenuItemName = "+tmpMenuItemName);
           
           if (tmpMenuItemName.equals(menuItemName)) {
               if (menuItem instanceof JCheckBoxMenuItem) {
                   checkBoxMenuItem = (JCheckBoxMenuItem) menuItem;
               
                   checkBoxMenuItem.setState(flag);
               }
               else {
                   menuItem.setEnabled(flag);
               }
               
               return;
           }
       }
    }
   
    private void setOptions(JPopupMenu menu, String menuItemName, boolean flag) {
       Component component;
       JMenuItem menuItem;
       String tmpMenuItemName;
       
       for (int i = 0; i < menu.getComponentCount(); i++) {
           component = menu.getComponent(i);
           if (component instanceof JMenuItem) {
               menuItem = (JMenuItem) component;
               tmpMenuItemName = menuItem.getText();
               if (tmpMenuItemName.equals(menuItemName))
                   menuItem.setEnabled(flag);
           }
       }
    }
   
    public JPopupMenu getGraphicPanelPopup() {
       JPopupMenu menu = new JPopupMenu();
       
       bgroup = new ButtonGroup();
       
       for (int i = 1; i < editionMenu.length; i++) {
           if (editionMenu[i][0] == null)
               menu.add(new JSeparator());
           else
               menu.add(createMenuItem(editionMenu[i]));
       }
       
       setOptions(menu,"Edit Domain Models",Manager.systemOptions.domainModelFlag);
       
       return menu;
    }
   
   //shijian 2001-3-21
/*   public JPopupMenu getGraphicPanelPopup(Object[][] menuData) {
       JPopupMenu menu = new JPopupMenu();
       changePopupMenuItems(menu,menuData);
       return menu;
   }
 */   
    //shijian 2001-3-21
    public void changePopupMenuItems(JPopupMenu menu,Object[][] menuData) {
        menu.removeAll();
        for (int i = 1; i < menuData.length; i++) {
           if (menuData[i][0] == null)
               menu.add(new JSeparator());
           else {
           		Sentence sen = new Sentence((String)menuData[i][0]);
           		if (!(Manager.systemOptions.domainModelFlag) &&
           			sen.contains("Domain")){
           			Component jmi=	menu.getComponentAtIndex(menu.
           						getComponentCount()-1);
           			if( jmi instanceof JSeparator)
           				menu.remove(jmi); //remove the separator	
           			continue;	
           		}
           		
               menu.add(createMenuItem(menuData[i]));
           }
        }
        
        return ;
    }
    
    //shijian 2001-2-12
    private void addDmMenu() {
        //first remove option and help menus
        //domain and language menus
        removeOHMenu();
        removeDmMenu();
        //now add domain and language menus
        add(_domainNemu);
        add(_langMenu);
        add(_optionMenu);
        add(_helpMenu);
    }
   
    //shijian 2001-2-13
    private void addOHMenu() {
        //first remove option and help menus
   	    //domain and language menus
   	    removeOHMenu();
   	    removeDmMenu();
   	
   	    //now add option and help menus
   	    add(_optionMenu);
        add(_helpMenu);
    }
   
    //shijian 2001-2-12
    private void removeDmMenu() {
        boolean dm= false;
   	    boolean lan= false;
   	    int menuNo = getMenuCount();
   	    //System.out.println("number of menus = " + menuNo);

   	    if (menuNo >0){
	   	    for (int i = 1; i< menuNo; i++){
	   		    if (getMenu(i).equals(_domainNemu) )
	   			    dm = true;
	   		    else if (getMenu(i).equals(_langMenu))
	   			    lan=true;
	   	    }
	   	    if (dm) remove(_domainNemu);
	   	    if (lan) remove(_langMenu);
   	    }
    }
   
    //shijian 2001-2-13
    private void removeOHMenu() {
   	    boolean opt= false;
   	    boolean help= false;
   	
   	    int menuNo = getMenuCount();
   	    //System.out.println("number of menus = "+ menuNo);

   	    if (menuNo > 0) {
	   	    for (int i = 0; i< menuNo; i++){
	   		    if (getMenu(i).equals(_optionMenu))
	   			    opt=true;
	   		    else if (getMenu(i).equals(_helpMenu))
	   			    help=true;
	   	    }
	   	    if (opt) remove(_optionMenu);
	   	    if (help) remove(_helpMenu);
   	    }
    }
   
    //shijian 2001-2-13
    private void updateMenuBar() {
        if (Manager.systemOptions.domainModelFlag){
            addDmMenu();
        }
        else{
   			addOHMenu();
        }
        revalidate();
        paintImmediately(getBounds());

    }
   
    //shijian 2001-3-23
    public static Component getComCurrent() {
   		return _comCurrent;
    }
    
    //shijian 2001-7-13
    public static JCheckBoxMenuItem getHowMi() {
   		return _howJcbmi;
    }
     //shijian 2001-7-13
    public static JCheckBoxMenuItem getStepByStepMi() {
   		return _stepByStepJcbmi;
    }
    
    //shijian 2001-7-25
    public static JCheckBoxMenuItem getConjunctionMi() {
   		return _conjunctionJcbmi;
    }
     //shijian 2001-7-25
    public static JCheckBoxMenuItem getModalityCanMi() {
   		return _modalityCanJcbmi;
    }
         //shijian 2001-7-25
    public static JCheckBoxMenuItem getPurposeFirstMi() {
   		return _purposeFirstJcbmi;
    }
    

}