/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;


import java.net.*;
import java.io.*;
import javax.swing.*;
public class LGServer {

    protected static  String  DEFAULT_serverName = null;  //"lansvale-nh.nsw.cmis.csiro.au";
    protected static  int  DEFAULT_portNumber =7724;  //8080; //7724;
    protected static  String  serverName;
    protected static  int  portNumber;
    protected static  Socket sock;
    protected static  BufferedReader in;
    protected static  PrintWriter send;


 
    public void finalise() throws IOException {
    	sock.close();  	
    }
  
    
   
    public String generateOLP(String fullPathName) throws IOException,InterruptedException{

		//String form= "(Isolde::Isolde \"D:/projects/Isolde/Lisp/BMS/BMS00-1-12a.exp\")";

        if (fullPathName.equals(""))  fullPathName= "D:/projects/Isolde/Lisp/BMS/BMS00-1-12a.exp";

        String form= "Isolde::Isolde \"" + fullPathName + "\" :compute-actions t";

		return sendCommand(form);
        
		
	}

    public String quitLGServer() throws IOException, InterruptedException{

         return sendCommand("isolde::isolde-quit");
         
         
    }


    public String sendCommand(String com) throws IOException, InterruptedException{
      String feedBack ="Generation in progress...";
      try{
            String form= "(" + com + ")";
            send.println(form);
           // send.flush();
            System.out.println("Sent: "+form);
            //System.out.println("Received: ");   //+receive.readLine());  

            MainFrame.mainFrameMessage.setText( "Generation in progress...");


            //JDialog progressD= new JDialog(MainFrame.mainFrame, feedBack);  , false); 
            //JOptionPane.showMessageDialog(MainFrame.mainFrame, feedBack);
            //progressD.show();
            System.out.println("Before receiving: "+ feedBack);

             String feedBack1= in.readLine();


             MainFrame.mainFrameMessage.setText(" Generation Completed."); 

             System.out.println("Received: "+ feedBack1); 
            // dialog.dispose();
             JOptionPane.showMessageDialog(MainFrame.mainFrame, " Generation Completed.");

             MainFrame.mainFrameMessage.setText("");






      }  catch(NullPointerException e)
      {
          feedBack ="NullPointerException...";
          JOptionPane.showMessageDialog(MainFrame.mainFrame, feedBack);
      }
        //JDialog progressD2= new JDialog(MainFrame.mainFrame, feedBack); 
        //progressD2.show();
        //progressD.dispose();
         return feedBack;   
         //readFeedBack();
         

    }    
    
    public String getLGServerName() {

           return DEFAULT_serverName;

    }

   public void setLGServerName(String sn) {

          DEFAULT_serverName = sn;

   }

   public int getDEFAULT_portNumber() {

          return DEFAULT_portNumber;

   }

   public void connect(String sName, int porNum) throws IOException, UnknownHostException  {
        InetAddress addr = InetAddress.getByName(sName);   //null);     //sName);
        
        sock = new Socket(addr, porNum);      
        in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
        send  = new PrintWriter(
                                new BufferedWriter(
                                new OutputStreamWriter(
                                sock.getOutputStream())), true);   //new PrintWriter(sock.getOutputStream());
        System.out.println("Found the socket");
 
 
   }
/*   
protected String readFeedBack() throws IOException,InterruptedException{
    String feedBack="";
         
         while (!feedBack.equals("generation completed."))
         {   
          try{
                feedBack= receive.readLine();
         
             }catch(NullPointerException e)
             {
                 feedBack ="Generation in progress...";
                 JOptionPane.showMessageDialog(MainFrame.mainFrame, feedBack);
                 //readFeedBack();

               //  wait(500);
             }
             
             feedBack = "generation completed.";
             JOptionPane.showMessageDialog(MainFrame.mainFrame, feedBack);
             
             
          }
          return feedBack;
   }

 */



}

