/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class JProgressBarDia extends JDialog implements ActionListener {
	protected int m_min = 0;
	protected int m_max = 10;
    //protected int m_counter = 0;
	protected JProgressBar jpb;
	protected Timer timer;
	
	public JProgressBarDia(Frame owner, String title) {
		super(owner,title);
		
   		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
   		int diaSizeX=700;
   		int diaSizeY=50;
      	setBounds(screenSize.width/2-diaSizeX/2,screenSize.height/2-diaSizeY/2,diaSizeX,diaSizeY);
		//setSize(300,50);
		//UIManager.put("ProgressBar.selectionBackground", Color.black);
		//UIManager.put("ProgressBar.selectionForeground", Color.white);
		//UIManager.put("ProgressBar.foreground", new Color(8,32,128));
      	
		jpb = new JProgressBar();
		jpb.setMinimum(m_min);
		jpb.setMaximum(m_max);
		//jpb.setStringPainted(true);
		jpb.setValue(0);
		
		getContentPane().add(jpb, BorderLayout.CENTER);
		setVisible(false);
		//show();
		
		//addActionListener(new ActionListener());
		timer = new Timer(5, this);
    	//timer.start();
/*	    	
    	for( int i=0; i<600; i++) {
	    	jpb.setValue(Manager.progressBarValue);
			System.out.println("............progress bar value:"+ Manager.progressBarValue);  
	    }
*/	}

	/*public void setJPBarCounter(int val) { 
		m_counter= val;  
	}*/
	
	public void actionPerformed (ActionEvent e) {
	    //if (Manager.progressBarValue > m_min)setVisible(true);

		if(Manager.progressBarValue < m_max) {
			jpb.setValue(Manager.progressBarValue);
			//System.out.println("............progress bar value:"+ Manager.progressBarValue);  
	    } else {
	    	jpb.setValue(Manager.progressBarValue);
	    	//System.out.println(".........it should be 10...progress bar value:"+ Manager.progressBarValue); 
	        stopLoading();
        }
    }

    public void stopLoading() {
		if (timer != null) {
	   		timer.stop();
	   		timer = null;
	   		dispose();
		}
    }
}

 