/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.awt.*;
import javax.swing.*;
import javax.swing.tree.*;
import java.io.File;


public class GenericComponentTreeCellRenderer extends DefaultTreeCellRenderer {
    
    //private static final ImageIcon ROOT_IMAGE=new ImageIcon("icons"+File.separator+"root.gif");
    private static final ImageIcon ROOT_IMAGE=new ImageIcon(ClassLoader.getSystemResource("icons"+File.separator+"root.gif"));
    
    public Component getTreeCellRendererComponent(JTree tree,Object value,boolean selected,boolean expanded,boolean leaf,int row,boolean hasFocus) {
	    JLabel l = (JLabel)super.getTreeCellRendererComponent(tree,value,selected,expanded,leaf,row,hasFocus);
        
    	String name = value.toString();
        
    	if (Manager.skeleton!=null) if (Manager.skeleton.isInRegister(name)) {
    	    GenericComponent gc=Manager.skeleton.getFirstComponent(name);
    	    if (gc instanceof Task) {
    	    	l.setIcon(Task.getIcon(16,16,true));
    	    }
    	    else if (gc instanceof BooleanConnector) {
    	    	l.setIcon(BooleanConnector.getIcon(16,16,((BooleanConnector)gc).type,true));
    	        l.setText("Boolean connector");
    	    }
    	    else if (gc instanceof Link){
    	    	l.setIcon(Link.getIcon(16,16,true));
    	    	l.setText("Link");
    	    }
    	    //l.setToolTipText(gc.getName());
    	}
    	if (name.equals("/")){
    	    l.setIcon(ROOT_IMAGE);
    	    l.setText("");
    	}
    	return l;
    }
}

/*public class GenericComponentTreeCellRenderer implements TreeCellRenderer {
    public Component getTreeCellRendererComponent(JTree tree,Object value,boolean selected,boolean expanded,boolean leaf,int row,boolean hasFocus){
        //if (tree instanceof MainTree){
            //String s=(String)value;
            Task c=new Task("");
            c.setSize(10,10);
            return c;
       // }
    }
}*/

