/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.awt.*;
import javax.swing.*;
import java.util.*;
import com.helplets.awt.PercentLayout;

/**
 * Manages the Footpane in the mainframe
 */
///
public class FootPane extends JPanel implements Runnable{
    
    //the component currently selected
    //protected JProgressBar progressbar=new JProgressBar(0,10);
    protected Label label =null;
    protected static JProgressBar progressbar=null;
  //  protected Timer timer;
    
    private final int jPBarMini = 0;
    private final int jPBarMax = 10;
    private Thread jPBarThread = null;


    public FootPane(){
    	label =new Label("");
    	progressbar=new JProgressBar(jPBarMini,jPBarMax);
    	setLayout(new PercentLayout());
	add("left=1, right=20, top=20", label);
	add("left=20, right=99,top=20", progressbar);
	progressbar.setValue(0);
	progressbar.setVisible(false);
//	timer = new Timer(25, this);
//	timer.addActionListner(this);

    }
    
    
    public void reSet(){
    	label.setText("");
    	progressbar.setVisible(false);
	repaint();
	
    }

	
    public void showProgressBar(){
        progressbar.setVisible(true);
	repaint();
    }

    public void setLabelText(String str){
    	label.setText(str);
    	//repaint();
    }
    
    public void setPBarValue(int val){
    	progressbar.setValue(val);
	repaint();
	
    }
/*
    public void actionPerformed (ActionEvent e) {
	    if(progressBar.getValue() < progressBar.getMaximum()) {
		progressBar.setValue(progressBar.getValue() );
	    } else {
	        stopLoading();
            }
    }

    public void startLoading() {
        if(timer == null) {
	    timer = new Timer(25, this);
	    timer.start();
        }
    }
*/    
    public void stopLoading() {
/*	if(timer != null) {
	   timer.stop();
	   timer = null;
	}
	
*/   	if(jPBarThread != null) {
	   jPBarThread.stop();
	   jPBarThread = null;
	}
     }
	
    public void start() {
        if (jPBarThread == null) {
            jPBarThread = new Thread(this, "Progress");
            jPBarThread.start();
        }
    }
    public void run() {
    	
	    while(progressbar.getValue() < progressbar.getMaximum()) 
	    {
		progressbar.setValue(progressbar.getValue() );
		try {
                	Thread.sleep(500);
            	} catch (InterruptedException e){ }
	    } 
	    
	    stopLoading();
            
    
     }	

}    

       	
