/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.io.*;

public class DomainObject implements Serializable/*Externalizable*/{
    public String name; //the first field is not editable
    public String class_name;
    public String part_of;
    public String cardinality;
    public String lexical_root;
    public String documentation;
    
    public DomainObject(String name){
        //this.name=name;
        this.name=name.toLowerCase();

        this.class_name="object";
        this.part_of="";
        this.cardinality=DomainModelManager.CARDINALITY_CONTENTS[0]; 	//"singular"; //
        this.lexical_root="";
        this.documentation="";
    }

	public void setName(String s){
   		name=s.toLowerCase(); // use lower case only
    }
    
    public void setClassName(String s){
   		class_name=s.toLowerCase(); // use lower case only
    }
    
    public void setPartOf(String s){
   		part_of=s.toLowerCase(); // use lower case only
	}
	
 	public void setCardinality(String s){
   		cardinality=s.toLowerCase(); // use lower case only
    }
    
	public void setLexicalRoot(String s){
   		lexical_root=s.toLowerCase(); // use lower case only
    }
    
	public void setDocumentation(String s){
   		documentation=s;				 // don't change case 
    }

    
    /*public void writeExternal(ObjectOutput out) throws IOException{
    	out.writeObject(name);
    	out.writeObject(class_name);		.toLowerCase()
    	out.writeObject(part_of);
    	out.writeObject(cardinality);
    	out.writeObject(lexical_root);
    	out.writeObject(documentation);
    }
    
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException{
    	name=(String)in.readObject();
    	class_name=(String)in.readObject();
    	part_of=(String)in.readObject();
    	cardinality=(String)in.readObject();
    	lexical_root=(String)in.readObject();
    	documentation=(String)in.readObject();
    }*/
}