/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.io.*;

public class DomainAction implements Serializable/*Externalizable*/{
   public String name; //the first field is not editable
   public String actor;
   public String verb;
   public String actee;
   public String proposition;   
   public String documentation;   
   
   public DomainAction(String name){
       //this.name=name;
   		//this.actor=DomainDefault.DEFAULTUSER;

       this.name=name.toLowerCase();
       this.actor=(DomainDefault.DEFAULTUSER).toLowerCase();
       this.verb="";
       this.actee="";
       this.proposition="";
       this.documentation="";
   }
   
	public void setName(String s){
   		name=s.toLowerCase(); // use lower case only
    }
    
    public void setActor(String s){
   		actor=s.toLowerCase(); // use lower case only
    }
    
    public void setVerb(String s){
   		verb=s.toLowerCase(); // use lower case only
	}
	
 	public void setActee(String s){
   		actee=s.toLowerCase(); // use lower case only
    }
    
	public void setProposition(String s){
   		proposition=s.toLowerCase(); // use lower case only
    }
    
	public void setDocumentation(String s){
   		documentation=s;				 // don't change case 
    }
    

    /*public void writeExternal(ObjectOutput out) throws IOException{
    	out.writeObject(name);
    	out.writeObject(actor);
    	out.writeObject(verb);
    	out.writeObject(actee);
    	out.writeObject(proposition);
    	out.writeObject(documentation);
    }
    
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException{
    	name=(String)in.readObject();
    	actor=(String)in.readObject();
    	verb=(String)in.readObject();
    	actee=(String)in.readObject();
    	proposition=(String)in.readObject();
    	documentation=(String)in.readObject();
    }*/
}