/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.io.File;

public class DisplayOptionsDialog{
	
    //private static final Color BACKGROUND_COLOR=Color.lightGray;
	
	//Thomas
    //private static final ImageIcon RENDERING_IMAGE=new ImageIcon("icons"+File.separator+"delete.gif");
    //private static final ImageIcon ZOOM_IMAGE=new ImageIcon("icons"+File.separator+"delete.gif");
    private static final ImageIcon RENDERING_IMAGE=new ImageIcon(ClassLoader.getSystemResource("icons"+File.separator+"delete.gif"));
    private static final ImageIcon ZOOM_IMAGE=new ImageIcon(ClassLoader.getSystemResource("icons"+File.separator+"delete.gif"));
    
    private JDialog dialog;
    private AbstractButton bAntiAliasing,bQuality,bDithering,bCornerZoom,bCenterZoom;
    private JPanel renderingPane,zoomPane;
    public DisplayOptionsDialog(){
    	JTabbedPane tab=new JTabbedPane();
    	
    	renderingPane=new JPanel();
    	renderingPane.setLayout(new GridLayout(3,2,50,10));
    	
    	renderingPane.add(new JLabel("AntiAliasing"));
    	bAntiAliasing=new JCheckBox("",DisplayManager.antiAliasing);
    	renderingPane.add(bAntiAliasing);
    	
    	renderingPane.add(new JLabel("Quality"));
    	bQuality=new JCheckBox("",DisplayManager.quality);
    	renderingPane.add(bQuality);
    	
    	renderingPane.add(new JLabel("Dithering"));
    	bDithering=new JCheckBox("",DisplayManager.dithering);
    	renderingPane.add(bDithering);
    	
    	zoomPane=new JPanel();
    	zoomPane.setLayout(new GridLayout(3,1,50,10));
    	
    	zoomPane.add(new JLabel("Zoom position:"));
    	ButtonGroup g=new ButtonGroup();
    	
    	bCornerZoom=new JRadioButton("top left corner",!DisplayManager.centeredZoom);
    	renderingPane.add(bCornerZoom);
    	g.add(bCornerZoom);
    	zoomPane.add(bCornerZoom);
    	
    	bCenterZoom=new JRadioButton("center",DisplayManager.centeredZoom);
    	bCenterZoom.setEnabled(false);
    	renderingPane.add(bCenterZoom);
    	g.add(bCenterZoom);
    	zoomPane.add(bCenterZoom);
    	
    	
    	
    	
    	tab.addTab("Rendering",RENDERING_IMAGE,renderingPane,"Rendering options");
    	//tab.setDisabledIconAt(0,);
    	tab.setSelectedIndex(0);
    	tab.addTab("Zoom",ZOOM_IMAGE,zoomPane,"Zoom options");
    	//tab.setDisabledIconAt(1,);
    	
    	tab.setPreferredSize(new Dimension(290,350));
    	    	    	
    	String [] options={"OK","Cancel"};
    	int n=JOptionPane.showOptionDialog(MainFrame.mainFrame,tab,"Display options",JOptionPane.OK_CANCEL_OPTION,JOptionPane.PLAIN_MESSAGE,null,options,options[0]);

    	if (n == JOptionPane.OK_OPTION) {
    	    DisplayManager.antiAliasing=bAntiAliasing.isSelected();
    	    DisplayManager.quality=bQuality.isSelected();
    	    DisplayManager.dithering=bDithering.isSelected();
    	    DisplayManager.centeredZoom=bCenterZoom.isSelected();
        }

    	
    	
    }
}