/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   Redistribution in source and binary forms, with or without modification, are not permitted.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import javax.swing.*;
import java.util.*;
import javax.swing.tree.*;


public class CopyManager {

    private static boolean checkCopyComponentIsLink() {
        boolean result = false;

        if (Manager.currentComponent instanceof Link) {
            MessageDialog.errorDialog(MainFrame.mainFrame,"Operation not allowed",
                "Cannot copy a link.");
                
            result = true;
        }
        
        return result;
    }
    
    private static boolean checkCopyMultiComponentsAreLink() {
        boolean result = false;

        if (BottomUp.isLinksOnly()) {
            MessageDialog.errorDialog(MainFrame.mainFrame,"Operation not allowed",
                "Cannot copy links only.");
            result = true;
        }
        
        return result;
    }
    
    private static void multipleCopy() {
        // if link(s) only, cannot copy
        if (checkCopyMultiComponentsAreLink()) return;
        
        BottomUp.updateRegisters();
        
        TMClipboard.init();
        
        // get the LinkableComponent list
        LinkableComponent [] lcList = BottomUp.getLinkableComponents();

        for (int i=0; i<lcList.length; i++) {
            copyLinkableComponent(lcList[i]);
        }
        
        // get the Link list
        Link [] linkList = BottomUp.getLinks();

        for (int i=0; i<linkList.length; i++) {
            copyLink(linkList[i]);
        }
        
        //TMClipboard.displayContent();
        
        BottomUp.resetAllSelection();
    }

    public static void copy() {
        if (BottomUp.isMultiComponentsSelected()) {
            multipleCopy();
            return;
        }
        
        // if link, cannot copy
        if (checkCopyComponentIsLink()) return;
        
        if (!(Manager.currentComponent instanceof LinkableComponent)) return;
        LinkableComponent lc = (LinkableComponent) Manager.currentComponent;
        
        TMClipboard.init();
        
        copyLinkableComponent(lc);

        //TMClipboard.displayContent();
    }

    private static void copyLink(Link link) {
        if (link == null) return;

        // get information about the component
        Integer id2 = new Integer(link.ID);
        String name = link.getName();

        String parentName = Manager.skeleton.toParentName(name,id2);
        
        // can't copy root
        TreePath treePath = Manager.fetchTreePath(name,parentName,Manager.tree,id2);
        if (Manager.isRoot(treePath)) return;
        
        // value to be put in the clipboard
        TMClipboard.addLink(link);
    }

    private static void copyLinkableComponent(LinkableComponent lc) {
        if (lc == null) return;

        // get component details
        Integer id2 = new Integer(lc.ID);
        String name = lc.getName();
        
        String parentName = Manager.skeleton.toParentName(name,id2);

        // can't copy root
        TreePath treePath = Manager.fetchTreePath(name,parentName,Manager.tree,id2);
        if (Manager.isRoot(treePath)) return;
        
        Node parentNode = Manager.skeleton.toParentNode(name,parentName);
                    
        // value to put in the clipboard
        //Clipboard.add(parentNode.getComponent(name,id2),Manager.skeleton.toChildNode(name,id2));
        TMClipboard.addLinkableComponent(lc,Manager.skeleton.toChildNode(name,id2));
        
        // set type in graphicToolBar
        TMClipboard.setToolBar(lc);
    }
    
}