/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.lang.reflect.*;

public class ComponentsOptionsDialog /*extends JDialog*/{
	
    private static final Color BACKGROUND_COLOR=Color.lightGray;
    
    private boolean [] taskVal;
    private boolean [] booleanConnectorVal;
    private boolean [] linkVal;
    private JDialog dialog;
    
    public ComponentsOptionsDialog(){
    	//super(MainFrame.mainFrame,"Components'options",true);
    	
    	taskVal=OptionsManager.task.getUserAttributes();
    	booleanConnectorVal=OptionsManager.booleanConnector.getUserAttributes();
    	linkVal=OptionsManager.link.getUserAttributes();
    	
    	//Container contentPane=getContentPane();
    	JTabbedPane tab=new JTabbedPane();
    	tab.addTab("Task",Task.getIcon(24,24,true),new JScrollPane(new JScrollPane(new ComponentsOptionsPane(OptionsManager.task))),"Change the attributes to display");
    	tab.setDisabledIconAt(0,Task.getIcon(24,24,false));
    	tab.setSelectedIndex(0);
    	tab.addTab("Boolean connector",BooleanConnector.getIcon(24,24,"",true),new JScrollPane(new ComponentsOptionsPane(OptionsManager.booleanConnector)),"Change the attributes to display");
    	tab.setDisabledIconAt(1,BooleanConnector.getIcon(24,24,"",false));
    	tab.addTab("Link",Link.getIcon(24,24,true),new JScrollPane(new ComponentsOptionsPane(OptionsManager.link)),"Change the attributes to display");
    	tab.setDisabledIconAt(2,Link.getIcon(24,24,false));
    	
    	tab.setPreferredSize(new Dimension(290,350));
    	    	
    	/*JOptionPane option=new JOptionPane(tab,JOptionPane.PLAIN_MESSAGE,JOptionPane.OK_CANCEL_OPTION);

    	dialog=option.createDialog(MainFrame.mainFrame,"Components'options");
    	dialog.pack();
    	dialog.setVisible(true);*/
    	
    	String [] options={"OK","Cancel"};
    	int n=JOptionPane.showOptionDialog(MainFrame.mainFrame,tab,"Components'options",JOptionPane.OK_CANCEL_OPTION,JOptionPane.PLAIN_MESSAGE,null,options,options[0]);

    	if (n == JOptionPane.OK_OPTION) {
    	    OptionsManager.task.setUserAttributes(taskVal);
    	    OptionsManager.booleanConnector.setUserAttributes(booleanConnectorVal);
    	    OptionsManager.link.setUserAttributes(linkVal);
    	    Manager.attributesPanel.updateAttributes();    	    
        }

    	
    	
    }
    
/*private void setVal(GenericComponent gc,boolean [] b){
    if (gc==OptionsManager.task) taskVal=gc.getUserAttributes();
    else if (gc==OptionsManager.booleanConnector) booleanConnectorVal=gc.getUserAttributes();
    else if (gc==OptionsManager.link) linkVal=gc.getUserAttributes();
}

private boolean [] getVal(GenericComponent gc){
    if (gc==OptionsManager.task) return taskVal;
    else if (gc==OptionsManager.booleanConnector) return booleanConnectorVal;
    else if (gc==OptionsManager.link) return linkVal;
    else return null;
}*/

class ComponentsOptionsPane extends JPanel{
    private GenericComponent gc;
    public ComponentsOptionsPane(GenericComponent gc){
        super();
        this.gc=gc;
        JPanel panel=new JPanel();
        panel.setBackground(BACKGROUND_COLOR); 
        add(new JScrollPane(panel),BorderLayout.CENTER);
        //add(new JButton("Ok"),BorderLayout.SOUTH);
        fillPane(panel);        
    }
    public void fillPane(JPanel panel){
        Border padding = BorderFactory.createEmptyBorder(10,10,10,10);
        panel.setBorder(padding);
    	Class cl=gc.getClass();
    	Object [][] obj=gc.getAttributesToDisplay();
    	//boolean [] val=getVal(gc);
    	Field field;
    	AbstractButton b;
    	JLabel jc;
    	panel.setLayout(new GridLayout(obj.length,2,50,10));
    	    	    
    	for (int i=0;i<obj.length;i++){
            try{
    	        field=(cl.getField((String)obj[i][0]));
    		    
    		//Label
    		jc=new JLabel((String)obj[i][0]);
    	        jc.setBackground(BACKGROUND_COLOR);
    	        //jc.setForeground(Color.black);    		    
                panel.add(jc);
                

                if (gc==OptionsManager.task){
                    b=new JCheckBox("",taskVal[i]);
                    b.setActionCommand(Integer.toString(i));
                    b.addActionListener(new ActionListener(){
                        public void actionPerformed(ActionEvent e){
                            String s=e.getActionCommand();
                            try{
                                int index=Integer.parseInt(s);
                                taskVal[index]=!taskVal[index];
                            }catch(NumberFormatException ex){System.err.println(ex);}
                        }
                    });
		}
                else if (gc==OptionsManager.booleanConnector){
                    b=new JCheckBox("",booleanConnectorVal[i]);
                    b.setActionCommand(Integer.toString(i));
                    b.addActionListener(new ActionListener(){
                        public void actionPerformed(ActionEvent e){
                            String s=e.getActionCommand();
                            try{
                                int index=Integer.parseInt(s);
                                booleanConnectorVal[index]=!booleanConnectorVal[index];
                            }catch(NumberFormatException ex){System.err.println(ex);}
                        }
                    });
		}
                else if (gc==OptionsManager.link){
                    b=new JCheckBox("",linkVal[i]);
                    b.setActionCommand(Integer.toString(i));
                    b.addActionListener(new ActionListener(){
                        public void actionPerformed(ActionEvent e){
                            String s=e.getActionCommand();
                            try{
                                int index=Integer.parseInt(s);
                                linkVal[index]=!linkVal[index];
                            }catch(NumberFormatException ex){System.err.println(ex);}
                        }
                    });
		} else b=new JCheckBox("");

    	        b.setBackground(BACKGROUND_COLOR);
    	        //b.setForeground(Color.black);    		    
                panel.add(b);
                    
            } catch (Exception e){System.out.println("getField error");}
    	}
    	//scrollRectToVisible(new Rectangle(0,0,0,0));
    	//revalidate();
    }
}


}

